/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.AAPT2OptimizeFlags;
import com.android.build.gradle.internal.tasks.OptimizeResourcesTask;
import com.android.ide.common.process.BaseProcessOutputHandler;
import com.android.ide.common.process.CachedProcessOutputHandler;
import com.android.ide.common.process.DefaultProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.ILogger;
import com.android.utils.LineCollector;
import com.android.utils.StdLogger;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a/\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\n\"\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u000e"}, d2={"doFullTaskAction", "", "params", "Lcom/android/build/gradle/internal/tasks/OptimizeResourcesTask$OptimizeResourcesParams;", "invokeAapt", "", "", "aapt2Executable", "Ljava/io/File;", "args", "", "(Ljava/io/File;[Ljava/lang/String;)Ljava/util/List;", "verifyAaptFlagEnabled", "", "gradle"})
public final class OptimizeResourcesTaskKt {
    /*
     * WARNING - void declaration
     */
    public static final void doFullTaskAction(@NotNull OptimizeResourcesTask.OptimizeResourcesParams params) {
        void $this$toTypedArray$iv;
        boolean bl;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        if (!OptimizeResourcesTaskKt.verifyAaptFlagEnabled(params)) {
            throw (Throwable)new NoSuchElementException("No AAPT OPTIMIZE flags enabled.");
        }
        boolean bl2 = false;
        Set optimizeFlags = new LinkedHashSet();
        if (params.getEnableResourceObfuscation()) {
            Collection collection = optimizeFlags;
            string = AAPT2OptimizeFlags.COLLAPSE_RESOURCE_NAMES.getFlag();
            bl = false;
            collection.add(string);
        }
        if (params.getEnableResourcePathShortening()) {
            Collection collection = optimizeFlags;
            string = AAPT2OptimizeFlags.SHORTEN_RESOURCE_PATHS.getFlag();
            bl = false;
            collection.add(string);
        }
        if (params.getEnableSparseResourceEncoding()) {
            Collection collection = optimizeFlags;
            string = AAPT2OptimizeFlags.ENABLE_SPARSE_ENCODING.getFlag();
            bl = false;
            collection.add(string);
        }
        File file = params.getAapt2Executable();
        SpreadBuilder spreadBuilder = new SpreadBuilder(5);
        spreadBuilder.add((Object)"optimize");
        String string2 = params.getInputApkFile().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"params.inputApkFile.path");
        spreadBuilder.add((Object)string2);
        Collection collection = optimizeFlags;
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        SpreadBuilder spreadBuilder3 = spreadBuilder;
        File file2 = file;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        SpreadBuilder spreadBuilder4 = spreadBuilder3;
        spreadBuilder2.addSpread((Object)stringArray2);
        spreadBuilder4.add((Object)"-o");
        String string3 = params.getOutputApkFile().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"params.outputApkFile.path");
        spreadBuilder4.add((Object)string3);
        OptimizeResourcesTaskKt.invokeAapt(file2, (String[])spreadBuilder4.toArray((Object[])new String[spreadBuilder4.size()]));
        if (params.getOutputApkFile().length() >= params.getInputApkFile().length()) {
            Files.copy(params.getInputApkFile().toPath(), params.getOutputApkFile().toPath(), new CopyOption[0]);
        }
    }

    @NotNull
    public static final List<String> invokeAapt(@NotNull File aapt2Executable, String ... args2) {
        Intrinsics.checkParameterIsNotNull((Object)aapt2Executable, (String)"aapt2Executable");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        CachedProcessOutputHandler processOutputHeader = new CachedProcessOutputHandler();
        ProcessInfoBuilder processInfoBuilder = new ProcessInfoBuilder().setExecutable(aapt2Executable).addArgs(args2);
        DefaultProcessExecutor processExecutor2 = new DefaultProcessExecutor((ILogger)new StdLogger(StdLogger.Level.ERROR));
        processExecutor2.execute(processInfoBuilder.createProcess(), (ProcessOutputHandler)processOutputHeader).rethrowFailure();
        BaseProcessOutputHandler.BaseProcessOutput baseProcessOutput = processOutputHeader.getProcessOutput();
        Intrinsics.checkExpressionValueIsNotNull((Object)baseProcessOutput, (String)"processOutputHeader.processOutput");
        BaseProcessOutputHandler.BaseProcessOutput output2 = baseProcessOutput;
        LineCollector lineCollector = new LineCollector();
        output2.processStandardOutputLines((LineProcessor)lineCollector);
        List list = lineCollector.getResult();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"lineCollector.result");
        return list;
    }

    public static final boolean verifyAaptFlagEnabled(@NotNull OptimizeResourcesTask.OptimizeResourcesParams params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        return params.getEnableResourceObfuscation() || params.getEnableResourcePathShortening() || params.getEnableSparseResourceEncoding();
    }
}

