/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataDelegate$WhenMappings;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataRunnable;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataTask;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.workers.WorkerExecutorFacade;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataDelegate;", "", "workers", "Lcom/android/ide/common/workers/WorkerExecutorFacade;", "inputDir", "Ljava/io/File;", "outputDir", "objcopyExecutableMap", "", "Lcom/android/build/gradle/internal/core/Abi;", "debugSymbolLevel", "Lcom/android/build/gradle/internal/dsl/NdkOptions$DebugSymbolLevel;", "processExecutor", "Lcom/android/ide/common/process/ProcessExecutor;", "(Lcom/android/ide/common/workers/WorkerExecutorFacade;Ljava/io/File;Ljava/io/File;Ljava/util/Map;Lcom/android/build/gradle/internal/dsl/NdkOptions$DebugSymbolLevel;Lcom/android/ide/common/process/ProcessExecutor;)V", "getInputDir", "()Ljava/io/File;", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getLogger", "()Lcom/android/build/gradle/internal/LoggerWrapper;", "getOutputDir", "getProcessExecutor", "()Lcom/android/ide/common/process/ProcessExecutor;", "getWorkers", "()Lcom/android/ide/common/workers/WorkerExecutorFacade;", "run", "", "gradle"})
public final class ExtractNativeDebugMetadataDelegate {
    @NotNull
    private final WorkerExecutorFacade workers;
    @NotNull
    private final File inputDir;
    @NotNull
    private final File outputDir;
    private final Map<Abi, File> objcopyExecutableMap;
    private final NdkOptions.DebugSymbolLevel debugSymbolLevel;
    @NotNull
    private final ProcessExecutor processExecutor;

    private final LoggerWrapper getLogger() {
        return new LoggerWrapper(Logging.getLogger(ExtractNativeDebugMetadataTask.class));
    }

    public final void run() {
        FileUtils.cleanOutputDir((File)this.outputDir);
        Iterator iterator = FileUtils.getAllFiles((File)this.inputDir).iterator();
        while (iterator.hasNext()) {
            File inputFile;
            File file = inputFile = (File)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputFile");
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inputFile.name");
            if (!StringsKt.endsWith((String)string, (String)".so", (boolean)true)) continue;
            File outputFile = null;
            List objcopyArgs = null;
            switch (ExtractNativeDebugMetadataDelegate$WhenMappings.$EnumSwitchMapping$0[this.debugSymbolLevel.ordinal()]) {
                case 1: {
                    StringBuilder stringBuilder = new StringBuilder();
                    File file2 = inputFile.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"inputFile.parentFile");
                    outputFile = new File(this.outputDir, stringBuilder.append(file2.getName()).append('/').append(inputFile.getName()).append(".dbg").toString());
                    objcopyArgs = CollectionsKt.listOf((Object)"--only-keep-debug");
                    break;
                }
                case 2: {
                    StringBuilder stringBuilder = new StringBuilder();
                    File file3 = inputFile.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"inputFile.parentFile");
                    outputFile = new File(this.outputDir, stringBuilder.append(file3.getName()).append('/').append(inputFile.getName()).append(".sym").toString());
                    objcopyArgs = CollectionsKt.listOf((Object)"--strip-debug");
                    break;
                }
                case 3: {
                    throw (Throwable)new RuntimeException("NativeDebugMetadataMode.NONE not supported in " + this.getClass().getName());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Map<Abi, File> map = this.objcopyExecutableMap;
            File file4 = inputFile.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"inputFile.parentFile");
            Abi abi = Abi.getByName(file4.getName());
            boolean bl = false;
            File objcopyExecutable = map.get((Object)abi);
            if (objcopyExecutable == null) {
                LoggerWrapper loggerWrapper = this.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("Unable to extract native debug metadata from ").append(inputFile.getAbsolutePath()).append(' ').append("because unable to locate the objcopy executable for the ");
                File file5 = inputFile.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"inputFile.parentFile");
                loggerWrapper.warning(stringBuilder.append(file5.getName()).append(" ABI.").toString(), new Object[0]);
                continue;
            }
            this.workers.submit(ExtractNativeDebugMetadataRunnable.class, (Serializable)new ExtractNativeDebugMetadataRunnable.Params(inputFile, outputFile, objcopyExecutable, objcopyArgs, this.processExecutor));
        }
    }

    @NotNull
    public final WorkerExecutorFacade getWorkers() {
        return this.workers;
    }

    @NotNull
    public final File getInputDir() {
        return this.inputDir;
    }

    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    @NotNull
    public final ProcessExecutor getProcessExecutor() {
        return this.processExecutor;
    }

    public ExtractNativeDebugMetadataDelegate(@NotNull WorkerExecutorFacade workers, @NotNull File inputDir, @NotNull File outputDir, @NotNull Map<Abi, ? extends File> objcopyExecutableMap, @NotNull NdkOptions.DebugSymbolLevel debugSymbolLevel, @NotNull ProcessExecutor processExecutor2) {
        Intrinsics.checkParameterIsNotNull((Object)workers, (String)"workers");
        Intrinsics.checkParameterIsNotNull((Object)inputDir, (String)"inputDir");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        Intrinsics.checkParameterIsNotNull(objcopyExecutableMap, (String)"objcopyExecutableMap");
        Intrinsics.checkParameterIsNotNull((Object)((Object)debugSymbolLevel), (String)"debugSymbolLevel");
        Intrinsics.checkParameterIsNotNull((Object)processExecutor2, (String)"processExecutor");
        this.workers = workers;
        this.inputDir = inputDir;
        this.outputDir = outputDir;
        this.objcopyExecutableMap = objcopyExecutableMap;
        this.debugSymbolLevel = debugSymbolLevel;
        this.processExecutor = processExecutor2;
    }
}

