/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataTask;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataRunnable$Params;", "(Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataRunnable$Params;)V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getLogger", "()Lcom/android/build/gradle/internal/LoggerWrapper;", "getParams", "()Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataRunnable$Params;", "run", "", "Params", "gradle"})
final class ExtractNativeDebugMetadataRunnable
implements Runnable {
    @NotNull
    private final Params params;

    private final LoggerWrapper getLogger() {
        return new LoggerWrapper(Logging.getLogger(ExtractNativeDebugMetadataTask.class));
    }

    @Override
    public void run() {
        ProcessResult result;
        FileUtils.mkdirs((File)this.params.getOutputFile().getParentFile());
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.params.getObjcopyExecutable());
        builder.addArgs(this.params.getObjcopyArgs());
        builder.addArgs(this.params.getInputFile().toString(), this.params.getOutputFile().toString());
        ProcessResult processResult = result = this.params.getProcessExecutor().execute(builder.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler((ILogger)new LoggerWrapper(Logging.getLogger(ExtractNativeDebugMetadataTask.class))));
        Intrinsics.checkExpressionValueIsNotNull((Object)processResult, (String)"result");
        if (processResult.getExitValue() != 0) {
            this.getLogger().warning("Unable to extract native debug metadata from " + this.params.getInputFile().getAbsolutePath() + ' ' + "because of non-zero exit value from objcopy.", new Object[0]);
        }
    }

    @NotNull
    public final Params getParams() {
        return this.params;
    }

    @Inject
    public ExtractNativeDebugMetadataRunnable(@NotNull Params params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        this.params = params;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003JA\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataRunnable$Params;", "Ljava/io/Serializable;", "inputFile", "Ljava/io/File;", "outputFile", "objcopyExecutable", "objcopyArgs", "", "", "processExecutor", "Lcom/android/ide/common/process/ProcessExecutor;", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/util/List;Lcom/android/ide/common/process/ProcessExecutor;)V", "getInputFile", "()Ljava/io/File;", "getObjcopyArgs", "()Ljava/util/List;", "getObjcopyExecutable", "getOutputFile", "getProcessExecutor", "()Lcom/android/ide/common/process/ProcessExecutor;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle"})
    public static final class Params
    implements Serializable {
        @NotNull
        private final File inputFile;
        @NotNull
        private final File outputFile;
        @NotNull
        private final File objcopyExecutable;
        @NotNull
        private final List<String> objcopyArgs;
        @NotNull
        private final ProcessExecutor processExecutor;

        @NotNull
        public final File getInputFile() {
            return this.inputFile;
        }

        @NotNull
        public final File getOutputFile() {
            return this.outputFile;
        }

        @NotNull
        public final File getObjcopyExecutable() {
            return this.objcopyExecutable;
        }

        @NotNull
        public final List<String> getObjcopyArgs() {
            return this.objcopyArgs;
        }

        @NotNull
        public final ProcessExecutor getProcessExecutor() {
            return this.processExecutor;
        }

        public Params(@NotNull File inputFile, @NotNull File outputFile, @NotNull File objcopyExecutable, @NotNull List<String> objcopyArgs, @NotNull ProcessExecutor processExecutor2) {
            Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            Intrinsics.checkParameterIsNotNull((Object)objcopyExecutable, (String)"objcopyExecutable");
            Intrinsics.checkParameterIsNotNull(objcopyArgs, (String)"objcopyArgs");
            Intrinsics.checkParameterIsNotNull((Object)processExecutor2, (String)"processExecutor");
            this.inputFile = inputFile;
            this.outputFile = outputFile;
            this.objcopyExecutable = objcopyExecutable;
            this.objcopyArgs = objcopyArgs;
            this.processExecutor = processExecutor2;
        }

        @NotNull
        public final File component1() {
            return this.inputFile;
        }

        @NotNull
        public final File component2() {
            return this.outputFile;
        }

        @NotNull
        public final File component3() {
            return this.objcopyExecutable;
        }

        @NotNull
        public final List<String> component4() {
            return this.objcopyArgs;
        }

        @NotNull
        public final ProcessExecutor component5() {
            return this.processExecutor;
        }

        @NotNull
        public final Params copy(@NotNull File inputFile, @NotNull File outputFile, @NotNull File objcopyExecutable, @NotNull List<String> objcopyArgs, @NotNull ProcessExecutor processExecutor2) {
            Intrinsics.checkParameterIsNotNull((Object)inputFile, (String)"inputFile");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            Intrinsics.checkParameterIsNotNull((Object)objcopyExecutable, (String)"objcopyExecutable");
            Intrinsics.checkParameterIsNotNull(objcopyArgs, (String)"objcopyArgs");
            Intrinsics.checkParameterIsNotNull((Object)processExecutor2, (String)"processExecutor");
            return new Params(inputFile, outputFile, objcopyExecutable, objcopyArgs, processExecutor2);
        }

        public static /* synthetic */ Params copy$default(Params params, File file, File file2, File file3, List list, ProcessExecutor processExecutor2, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.inputFile;
            }
            if ((n & 2) != 0) {
                file2 = params.outputFile;
            }
            if ((n & 4) != 0) {
                file3 = params.objcopyExecutable;
            }
            if ((n & 8) != 0) {
                list = params.objcopyArgs;
            }
            if ((n & 0x10) != 0) {
                processExecutor2 = params.processExecutor;
            }
            return params.copy(file, file2, file3, list, processExecutor2);
        }

        @NotNull
        public String toString() {
            return "Params(inputFile=" + this.inputFile + ", outputFile=" + this.outputFile + ", objcopyExecutable=" + this.objcopyExecutable + ", objcopyArgs=" + this.objcopyArgs + ", processExecutor=" + this.processExecutor + ")";
        }

        public int hashCode() {
            File file = this.inputFile;
            File file2 = this.outputFile;
            File file3 = this.objcopyExecutable;
            List<String> list = this.objcopyArgs;
            ProcessExecutor processExecutor2 = this.processExecutor;
            return ((((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (processExecutor2 != null ? processExecutor2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.inputFile, (Object)params.inputFile) || !Intrinsics.areEqual((Object)this.outputFile, (Object)params.outputFile) || !Intrinsics.areEqual((Object)this.objcopyExecutable, (Object)params.objcopyExecutable) || !Intrinsics.areEqual(this.objcopyArgs, params.objcopyArgs) || !Intrinsics.areEqual((Object)this.processExecutor, (Object)params.processExecutor)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

