/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.DependencyResolutionChecks;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.google.common.base.Throwables;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"REGISTERED_EXTENSION_EXT_PROPERTY_NAME", "", "errorMessage", "configurationName", "registerDependencyCheck", "", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "gradle"})
@JvmName(name="DependencyResolutionChecks")
public final class DependencyResolutionChecks {
    private static final String REGISTERED_EXTENSION_EXT_PROPERTY_NAME = "_internalAndroidGradlePluginDependencyCheckerRegistered";

    public static final void registerDependencyCheck(@NotNull Project project2, @NotNull ProjectOptions projectOptions) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        Project project3 = project2.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project.rootProject");
        if (project3.getExtensions().findByName(REGISTERED_EXTENSION_EXT_PROPERTY_NAME) != null) {
            return;
        }
        Project project4 = project2.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project.rootProject");
        project4.getExtensions().add(REGISTERED_EXTENSION_EXT_PROPERTY_NAME, (Object)true);
        boolean warn = projectOptions.get(BooleanOption.WARN_ABOUT_DEPENDENCY_RESOLUTION_AT_CONFIGURATION);
        boolean fail = projectOptions.get(BooleanOption.DISALLOW_DEPENDENCY_RESOLUTION_AT_CONFIGURATION);
        AtomicBoolean isProjectEvaluated = new AtomicBoolean(false);
        project2.getGradle().projectsEvaluated((Action)new Action<Gradle>(isProjectEvaluated){
            final /* synthetic */ AtomicBoolean $isProjectEvaluated;

            public final void execute(Gradle it) {
                this.$isProjectEvaluated.set(true);
            }
            {
                this.$isProjectEvaluated = atomicBoolean;
            }
        });
        project2.getConfigurations().all((Action)new Action<Configuration>(isProjectEvaluated, project2, fail, warn){
            final /* synthetic */ AtomicBoolean $isProjectEvaluated;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $fail;
            final /* synthetic */ boolean $warn;

            public final void execute(Configuration configuration2) {
                Configuration configuration3 = configuration2;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
                configuration3.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(this, configuration2){
                    final /* synthetic */ registerDependencyCheck.2 this$0;
                    final /* synthetic */ Configuration $configuration;

                    public final void execute(ResolvableDependencies it) {
                        if (this.this$0.$isProjectEvaluated.get()) {
                            return;
                        }
                        Configuration configuration2 = this.$configuration;
                        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
                        if (Intrinsics.areEqual((Object)configuration2.getName(), (Object)"classpath")) {
                            return;
                        }
                        Object object = this.this$0.$project.findProperty(BooleanOption.IDE_BUILD_MODEL_ONLY.getPropertyName());
                        if (object != null) {
                            Object object2 = object;
                            boolean bl = false;
                            boolean bl2 = false;
                            Object it2 = object2;
                            boolean bl3 = false;
                            Object object3 = it2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                            if (BooleanOption.IDE_BUILD_MODEL_ONLY.parse(object3).booleanValue()) {
                                return;
                            }
                        }
                        Configuration configuration3 = this.$configuration;
                        Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
                        String string = configuration3.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configuration.name");
                        String errorMessage = DependencyResolutionChecks.access$errorMessage(string);
                        if (this.this$0.$fail) {
                            throw (Throwable)new RuntimeException(errorMessage);
                        }
                        if (this.this$0.$warn) {
                            this.this$0.$project.getLogger().warn(errorMessage + "\nRun with --info for a stacktrace.");
                        }
                        if (this.this$0.$project.getLogger().isEnabled(LogLevel.INFO)) {
                            this.this$0.$project.getLogger().info(Throwables.getStackTraceAsString((Throwable)new RuntimeException(errorMessage)));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$configuration = configuration2;
                    }
                });
            }
            {
                this.$isProjectEvaluated = atomicBoolean;
                this.$project = project2;
                this.$fail = bl;
                this.$warn = bl2;
            }
        });
    }

    private static final String errorMessage(String configurationName) {
        return "Configuration '" + configurationName + "' was resolved during configuration time.\nThis is a build performance and scalability issue.\nSee https://github.com/gradle/gradle/issues/2298";
    }

    public static final /* synthetic */ String access$errorMessage(String configurationName) {
        return DependencyResolutionChecks.errorMessage(configurationName);
    }
}

