/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.internal.tasks.IncrementalFileMergerTaskUtils$WhenMappings;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.files.KeyedFileCache;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.files.ZipCentralDirectory;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInput;
import com.android.builder.merge.LazyIncrementalFileMergerInputs;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a0\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\fH\u0002\u001a8\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u001at\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\b\u0000\u0012\u00020\u001a0\u00192\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020 \u0018\u00010\u0019\u001a&\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a8\u0006\""}, d2={"computeFilesFromDir", "", "Lcom/android/builder/files/RelativeFile;", "dir", "Ljava/io/File;", "computeFilesFromJar", "jar", "Lcom/android/builder/files/ZipCentralDirectory;", "computeUpdatesFromDir", "Lcom/google/common/collect/ImmutableMap;", "Lcom/android/ide/common/resources/FileStatus;", "changedInputs", "", "computeUpdatesFromJar", "zipCache", "Lcom/android/builder/files/KeyedFileCache;", "toIncrementalInput", "Lcom/android/builder/merge/IncrementalFileMergerInput;", "input", "cacheUpdates", "", "Ljava/lang/Runnable;", "toInputs", "Lcom/google/common/collect/ImmutableList;", "inputMap", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "full", "", "contentType", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "contentMap", "Lcom/android/build/api/transform/QualifiedContent;", "toNonIncrementalInput", "gradle"})
@JvmName(name="IncrementalFileMergerTaskUtils")
public final class IncrementalFileMergerTaskUtils {
    @NotNull
    public static final IncrementalFileMergerInput toIncrementalInput(@NotNull File input, @NotNull Map<File, ? extends FileStatus> changedInputs, @NotNull KeyedFileCache zipCache2, @NotNull List<Runnable> cacheUpdates) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(changedInputs, (String)"changedInputs");
        Intrinsics.checkParameterIsNotNull((Object)zipCache2, (String)"zipCache");
        Intrinsics.checkParameterIsNotNull(cacheUpdates, (String)"cacheUpdates");
        String string = input.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.name");
        if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
            ZipCentralDirectory jarCDR = new ZipCentralDirectory(input);
            if (changedInputs.containsKey(input)) {
                Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(input, zipCache2, jarCDR){
                    final /* synthetic */ File $input;
                    final /* synthetic */ KeyedFileCache $zipCache;
                    final /* synthetic */ ZipCentralDirectory $jarCDR;

                    public final void run() {
                        if (this.$input.isFile()) {
                            this.$zipCache.add(this.$jarCDR);
                        } else {
                            this.$zipCache.remove(this.$input);
                        }
                    }
                    {
                        this.$input = file;
                        this.$zipCache = keyedFileCache;
                        this.$jarCDR = zipCentralDirectory;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"IOExceptionRunnable.asRu\u2026          }\n            }");
                cacheUpdates.add(runnable);
            }
            return (IncrementalFileMergerInput)new LazyIncrementalFileMergerInput(input.getAbsolutePath(), new CachedSupplier(new Supplier<T>(jarCDR, changedInputs, zipCache2){
                final /* synthetic */ ZipCentralDirectory $jarCDR;
                final /* synthetic */ Map $changedInputs;
                final /* synthetic */ KeyedFileCache $zipCache;

                @NotNull
                public final Map<RelativeFile, FileStatus> get() {
                    return IncrementalFileMergerTaskUtils.access$computeUpdatesFromJar(this.$jarCDR, this.$changedInputs, this.$zipCache);
                }
                {
                    this.$jarCDR = zipCentralDirectory;
                    this.$changedInputs = map;
                    this.$zipCache = keyedFileCache;
                }
            }), new CachedSupplier(new Supplier<T>(jarCDR){
                final /* synthetic */ ZipCentralDirectory $jarCDR;

                @NotNull
                public final Set<RelativeFile> get() {
                    return IncrementalFileMergerTaskUtils.access$computeFilesFromJar(this.$jarCDR);
                }
                {
                    this.$jarCDR = zipCentralDirectory;
                }
            }));
        }
        Preconditions.checkState((!input.isFile() ? 1 : 0) != 0, (String)("Non-directory inputs must have .jar extension: " + input), (Object[])new Object[0]);
        return (IncrementalFileMergerInput)new LazyIncrementalFileMergerInput(input.getAbsolutePath(), new CachedSupplier(new Supplier<T>(input, changedInputs){
            final /* synthetic */ File $input;
            final /* synthetic */ Map $changedInputs;

            @NotNull
            public final ImmutableMap<RelativeFile, FileStatus> get() {
                return IncrementalFileMergerTaskUtils.access$computeUpdatesFromDir(this.$input, this.$changedInputs);
            }
            {
                this.$input = file;
                this.$changedInputs = map;
            }
        }), new CachedSupplier(new Supplier<T>(input){
            final /* synthetic */ File $input;

            @NotNull
            public final Set<RelativeFile> get() {
                return IncrementalFileMergerTaskUtils.access$computeFilesFromDir(this.$input);
            }
            {
                this.$input = file;
            }
        }));
    }

    @Nullable
    public static final IncrementalFileMergerInput toNonIncrementalInput(@NotNull File input, @NotNull KeyedFileCache zipCache2, @NotNull List<Runnable> cacheUpdates) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)zipCache2, (String)"zipCache");
        Intrinsics.checkParameterIsNotNull(cacheUpdates, (String)"cacheUpdates");
        if (!input.isFile() && !input.isDirectory()) {
            return null;
        }
        if (input.isFile()) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache2, input){
                final /* synthetic */ KeyedFileCache $zipCache;
                final /* synthetic */ File $input;

                public final void run() {
                    this.$zipCache.add(this.$input);
                }
                {
                    this.$zipCache = keyedFileCache;
                    this.$input = file;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"IOExceptionRunnable.asRu\u2026 {  zipCache.add(input) }");
            cacheUpdates.add(runnable);
        }
        return (IncrementalFileMergerInput)LazyIncrementalFileMergerInputs.fromNew((String)input.getAbsolutePath(), (Set)((Set)ImmutableSet.of((Object)input)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Map<RelativeFile, FileStatus> computeUpdatesFromJar(ZipCentralDirectory jar, Map<File, ? extends FileStatus> changedInputs, KeyedFileCache zipCache2) {
        Map<File, ? extends FileStatus> map = changedInputs;
        File file = jar.getFile();
        boolean bl = false;
        Map<File, ? extends FileStatus> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(file)) {
            FileStatus fileStatus = changedInputs.get(jar.getFile());
            try {
                FileStatus fileStatus2 = fileStatus;
                if (fileStatus2 == null) throw (Throwable)((Object)new AssertionError((Object)("Unexpected FileStatus: " + fileStatus)));
                switch (IncrementalFileMergerTaskUtils$WhenMappings.$EnumSwitchMapping$0[fileStatus2.ordinal()]) {
                    case 1: {
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZip((ZipCentralDirectory)jar, (FileStatus)FileStatus.NEW);
                        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"IncrementalRelativeFileS\u2026mZip(jar, FileStatus.NEW)");
                        Map map3 = (Map)immutableMap;
                        return map3;
                    }
                    case 2: {
                        File file2 = zipCache2.get(jar.getFile());
                        if (file2 == null) {
                            throw (Throwable)new RuntimeException("File '" + jar + "' was deleted, but previous version not found in cache");
                        }
                        File cached = file2;
                        ImmutableMap immutableMap = IncrementalRelativeFileSets.fromZip((File)cached, (FileStatus)FileStatus.REMOVED);
                        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"IncrementalRelativeFileS\u2026ched, FileStatus.REMOVED)");
                        Map map3 = (Map)immutableMap;
                        return map3;
                    }
                    case 3: {
                        Map map4 = IncrementalRelativeFileSets.fromZip((ZipCentralDirectory)jar, (KeyedFileCache)zipCache2, (Set)new HashSet());
                        Map map3 = map4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)map4, (String)"IncrementalRelativeFileS\u2026jar, zipCache, HashSet())");
                        return map3;
                    }
                    default: {
                        throw (Throwable)((Object)new AssertionError((Object)("Unexpected FileStatus: " + fileStatus)));
                    }
                }
            }
            catch (IOException e) {
                throw (Throwable)new UncheckedIOException(e);
            }
        }
        ImmutableMap immutableMap = ImmutableMap.of();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.of()");
        return (Map)immutableMap;
    }

    private static final Set<RelativeFile> computeFilesFromJar(ZipCentralDirectory jar) {
        if (!jar.getFile().isFile()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of()");
            return (Set)immutableSet;
        }
        try {
            Set set = RelativeFiles.fromZip((ZipCentralDirectory)jar);
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"RelativeFiles.fromZip(jar)");
            return set;
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final ImmutableMap<RelativeFile, FileStatus> computeUpdatesFromDir(File dir, Map<File, ? extends FileStatus> changedInputs) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Object object = changedInputs;
        boolean bl = false;
        Iterator<Map.Entry<File, ? extends FileStatus>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void file;
            Map.Entry<File, ? extends FileStatus> entry;
            Map.Entry<File, ? extends FileStatus> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            FileStatus status = entry2.getValue();
            if (!FileUtils.isFileInDirectory((File)file, (File)dir)) continue;
            RelativeFile rf = new RelativeFile(dir, (File)file);
            File file2 = rf.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"rf.file");
            if (file2.isDirectory()) continue;
            builder.put((Object)rf, (Object)status);
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"builder.build()");
        return immutableMap;
    }

    private static final Set<RelativeFile> computeFilesFromDir(File dir) {
        if (!dir.isDirectory()) {
            ImmutableSet immutableSet = ImmutableSet.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of()");
            return (Set)immutableSet;
        }
        Set set = RelativeFiles.fromDirectory((File)dir);
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"RelativeFiles.fromDirectory(dir)");
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ImmutableList<IncrementalFileMergerInput> toInputs(@NotNull Map<File, ? super QualifiedContent.Scope> inputMap, @Nullable Map<File, ? extends FileStatus> changedInputs, @NotNull KeyedFileCache zipCache2, @NotNull List<Runnable> cacheUpdates, boolean full, @NotNull QualifiedContent.ContentType contentType, @Nullable Map<IncrementalFileMergerInput, QualifiedContent> contentMap) {
        Intrinsics.checkParameterIsNotNull(inputMap, (String)"inputMap");
        Intrinsics.checkParameterIsNotNull((Object)zipCache2, (String)"zipCache");
        Intrinsics.checkParameterIsNotNull(cacheUpdates, (String)"cacheUpdates");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        if (full) {
            Runnable runnable = IOExceptionRunnable.asRunnable((IOExceptionRunnable)new IOExceptionRunnable(zipCache2){
                final /* synthetic */ KeyedFileCache $zipCache;

                public final void run() {
                    this.$zipCache.clear();
                }
                {
                    this.$zipCache = keyedFileCache;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)runnable, (String)"IOExceptionRunnable.asRu\u2026able { zipCache.clear() }");
            cacheUpdates.add(runnable);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator<Map.Entry<File, ? super QualifiedContent.Scope>> iterator = inputMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map<IncrementalFileMergerInput, QualifiedContent> map;
            IncrementalFileMergerInput incrementalFileMergerInput;
            IncrementalFileMergerInput fileMergerInput;
            IncrementalFileMergerInput incrementalFileMergerInput2;
            void input;
            Map.Entry<File, ? super QualifiedContent.Scope> entry;
            Map.Entry<File, ? super QualifiedContent.Scope> entry2 = entry = iterator.next();
            boolean bl = false;
            File file = entry2.getKey();
            entry2 = entry;
            bl = false;
            QualifiedContent.Scope scope = entry2.getValue();
            if (full) {
                incrementalFileMergerInput2 = IncrementalFileMergerTaskUtils.toNonIncrementalInput((File)input, zipCache2, cacheUpdates);
            } else {
                if (changedInputs == null) {
                    throw (Throwable)new RuntimeException("changedInputs must be specified for incremental merging.");
                }
                incrementalFileMergerInput2 = fileMergerInput = IncrementalFileMergerTaskUtils.toIncrementalInput((File)input, changedInputs, zipCache2, cacheUpdates);
            }
            if (fileMergerInput == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            IncrementalFileMergerInput it = incrementalFileMergerInput;
            boolean bl4 = false;
            builder.add((Object)it);
            if (contentMap == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            Map<IncrementalFileMergerInput, QualifiedContent> contentMap2 = map;
            boolean bl7 = false;
            QualifiedContent qualifiedContent = new QualifiedContent(it, builder, contentMap, (File)input, contentType, scope){
                final /* synthetic */ IncrementalFileMergerInput $it$inlined;
                final /* synthetic */ ImmutableList.Builder $builder$inlined;
                final /* synthetic */ Map $contentMap$inlined;
                final /* synthetic */ File $input$inlined;
                final /* synthetic */ QualifiedContent.ContentType $contentType$inlined;
                final /* synthetic */ Object $scope$inlined;
                {
                    this.$it$inlined = incrementalFileMergerInput;
                    this.$builder$inlined = builder;
                    this.$contentMap$inlined = map;
                    this.$input$inlined = file;
                    this.$contentType$inlined = contentType;
                    this.$scope$inlined = object;
                }

                @NotNull
                public String getName() {
                    return "file-merger-qualified-content";
                }

                @NotNull
                public File getFile() {
                    return this.$input$inlined;
                }

                @NotNull
                public Set<QualifiedContent.ContentType> getContentTypes() {
                    return SetsKt.mutableSetOf((Object[])new QualifiedContent.ContentType[]{this.$contentType$inlined});
                }

                @NotNull
                public Set<Object> getScopes() {
                    return SetsKt.mutableSetOf((Object[])new Object[]{this.$scope$inlined});
                }
            };
            contentMap2.put(it, qualifiedContent);
        }
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return immutableList;
    }

    public static final /* synthetic */ Map access$computeUpdatesFromJar(ZipCentralDirectory jar, Map changedInputs, KeyedFileCache zipCache2) {
        return IncrementalFileMergerTaskUtils.computeUpdatesFromJar(jar, changedInputs, zipCache2);
    }

    public static final /* synthetic */ Set access$computeFilesFromJar(ZipCentralDirectory jar) {
        return IncrementalFileMergerTaskUtils.computeFilesFromJar(jar);
    }

    public static final /* synthetic */ ImmutableMap access$computeUpdatesFromDir(File dir, Map changedInputs) {
        return IncrementalFileMergerTaskUtils.computeUpdatesFromDir(dir, changedInputs);
    }

    public static final /* synthetic */ Set access$computeFilesFromDir(File dir) {
        return IncrementalFileMergerTaskUtils.computeFilesFromDir(dir);
    }
}

