/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.DetermineUsedStlResult;
import com.android.build.gradle.internal.cxx.services.CxxProcessServiceKt;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.GeneratePrefabPackagesKt$WhenMappings;
import com.android.ide.common.process.ProcessInfoBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u001c\u0010\t\u001a\u0018\u0012\u000e\u0012\f\u0012\b\b\u0000\u0012\u0004\u0018\u00010\f0\u000b\u0012\u0004\u0012\u00020\r0\n\u00a8\u0006\u000e"}, d2={"generatePrefabPackages", "", "moduleModel", "Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;", "abiModel", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "packages", "", "Ljava/io/File;", "execOperation", "Lkotlin/Function1;", "Lorg/gradle/api/Action;", "Lorg/gradle/process/JavaExecSpec;", "Lorg/gradle/process/ExecResult;", "gradle"})
public final class GeneratePrefabPackagesKt {
    /*
     * WARNING - void declaration
     */
    public static final void generatePrefabPackages(@NotNull CxxModuleModel moduleModel, @NotNull CxxAbiModel abiModel, @NotNull List<? extends File> packages, @NotNull Function1<? super Action<? super JavaExecSpec>, ? extends ExecResult> execOperation) {
        String string;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)moduleModel, (String)"moduleModel");
        Intrinsics.checkParameterIsNotNull((Object)abiModel, (String)"abiModel");
        Intrinsics.checkParameterIsNotNull(packages, (String)"packages");
        Intrinsics.checkParameterIsNotNull(execOperation, (String)"execOperation");
        Iterable $this$map$iv = packages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getPath();
            collection.add(string2);
        }
        List packagePaths = (List)destination$iv$iv;
        switch (GeneratePrefabPackagesKt$WhenMappings.$EnumSwitchMapping$0[abiModel.getVariant().getModule().getBuildSystem().ordinal()]) {
            case 1: {
                string = "ndk-build";
                break;
            }
            case 2: {
                string = "cmake";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String buildSystem2 = string;
        int osVersion = abiModel.getAbiPlatformVersion();
        File file = abiModel.getVariant().getPrefabClassPath();
        if (file == null) {
            throw (Throwable)new RuntimeException("CxxAbiModule.prefabClassPath cannot be null when Prefab is used");
        }
        File prefabClassPath2 = file;
        DetermineUsedStlResult result = CxxVariantModelKt.determineUsedStl(abiModel.getVariant());
        if (!(result instanceof DetermineUsedStlResult.Success)) {
            if (result instanceof DetermineUsedStlResult.Failure) {
                LoggingEnvironmentKt.errorln(((DetermineUsedStlResult.Failure)result).getError(), new Object[0]);
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        Stl selectedStl = ((DetermineUsedStlResult.Success)result).getStl();
        ProcessInfoBuilder builder = new ProcessInfoBuilder().setClasspath(prefabClassPath2.toString()).setMain("com.google.prefab.cli.AppKt").addArgs("--build-system", buildSystem2).addArgs("--platform", "android").addArgs("--abi", abiModel.getAbi().getTag()).addArgs("--os-version", String.valueOf(osVersion)).addArgs("--stl", selectedStl.getArgumentName()).addArgs("--ndk-version", String.valueOf(abiModel.getVariant().getModule().getNdkVersion().getMajor())).addArgs("--output", FilesKt.resolve((File)abiModel.getPrefabFolder(), (String)"prefab").toString()).addArgs(packagePaths);
        File file2 = CxxAbiModelKt.getSoFolder(abiModel);
        String string3 = "prefab_" + buildSystem2 + '_' + abiModel.getAbi().getTag();
        ProcessInfoBuilder processInfoBuilder = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)processInfoBuilder, (String)"builder");
        CxxProcessServiceKt.createProcessOutputJunction(moduleModel, file2, string3, processInfoBuilder, "prefab").javaProcess().logStderrToInfo().execute(execOperation);
    }
}

