/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.TensorInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DataInputOutputUtils {
    public static int[] readIntArray(DataInput in) throws IOException {
        int len = in.readInt();
        int[] values = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            values[i2] = in.readInt();
        }
        return values;
    }

    public static void writeIntArray(DataOutput out, int[] values) throws IOException {
        out.writeInt(values.length);
        for (int value : values) {
            out.writeInt(value);
        }
    }

    public static float[] readFloatArray(DataInput in) throws IOException {
        int len = in.readInt();
        float[] values = new float[len];
        for (int i2 = 0; i2 < len; ++i2) {
            values[i2] = in.readFloat();
        }
        return values;
    }

    public static void writeFloatArray(DataOutput out, float[] values) throws IOException {
        out.writeInt(values.length);
        for (float value : values) {
            out.writeFloat(value);
        }
    }

    public static List<TensorInfo> readTensorInfoList(DataInput in) throws IOException {
        ArrayList<TensorInfo> tensorInfoList = new ArrayList<TensorInfo>();
        int len = in.readInt();
        for (int i2 = 0; i2 < len; ++i2) {
            tensorInfoList.add(new TensorInfo(in));
        }
        return tensorInfoList;
    }

    public static void writeTensorInfoList(DataOutput out, List<TensorInfo> tensorInfoList) throws IOException {
        out.writeInt(tensorInfoList.size());
        for (TensorInfo tensorInfo : tensorInfoList) {
            tensorInfo.save(out);
        }
    }
}

