/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.component.ComponentIdentity;
import com.android.build.api.variant.impl.VariantPropertiesImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.ProguardFileType;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.PostProcessingOptions;
import com.android.build.gradle.internal.core.VariantDslInfo;
import com.android.build.gradle.internal.dependency.ProvidedClasspath;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.packaging.JarCreatorType;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.scope.ArtifactPublishingUtil;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.VariantPathHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexerTool;
import com.android.builder.errors.IssueReporter;
import com.android.builder.internal.packaging.ApkCreatorType;
import com.android.builder.model.CodeShrinker;
import com.android.builder.model.OptionalCompilationStep;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;

public class VariantScopeImpl
implements VariantScope {
    private static final String PUBLISH_ERROR_MSG = "Publishing to %1$s with no %1$s configuration object. VariantType: %2$s";
    private final ComponentIdentity componentIdentity;
    private final VariantDslInfo variantDslInfo;
    private final VariantPathHelper pathHelper;
    private final ArtifactsImpl artifacts;
    private final VariantDependencies variantDependencies;
    private final PublishingSpecs.VariantSpec variantPublishingSpec;
    private final VariantPropertiesImpl testedVariantProperties;
    private final GlobalScope globalScope;
    private final Map<Abi, File> ndkDebuggableLibraryFolders = Maps.newHashMap();
    private final Supplier<ConfigurableFileCollection> desugarTryWithResourcesRuntimeJar;
    private final PostProcessingOptions postProcessingOptions;

    public VariantScopeImpl(ComponentIdentity componentIdentity, VariantDslInfo variantDslInfo, VariantDependencies variantDependencies, VariantPathHelper pathHelper, ArtifactsImpl artifacts2, GlobalScope globalScope, VariantPropertiesImpl testedVariantProperties) {
        this.componentIdentity = componentIdentity;
        this.variantDslInfo = variantDslInfo;
        this.variantDependencies = variantDependencies;
        this.pathHelper = pathHelper;
        this.artifacts = artifacts2;
        this.globalScope = globalScope;
        this.variantPublishingSpec = PublishingSpecs.getVariantSpec(variantDslInfo.getVariantType());
        this.testedVariantProperties = testedVariantProperties;
        if (globalScope.isActive(OptionalCompilationStep.INSTANT_DEV)) {
            throw new RuntimeException("InstantRun mode is not supported");
        }
        Project project2 = globalScope.getProject();
        this.desugarTryWithResourcesRuntimeJar = Suppliers.memoize(() -> project2.files(new Object[]{FileUtils.join((File)pathHelper.getIntermediatesDir(), (String[])new String[]{"processing-tools", "runtime-deps", variantDslInfo.getDirName(), "desugar_try_with_resources.jar"})}));
        this.postProcessingOptions = variantDslInfo.createPostProcessingOptions(project2.getLayout().getBuildDirectory());
        this.configureNdk();
    }

    private void configureNdk() {
        File objFolder = new File(this.pathHelper.getIntermediatesDir(), "ndk/" + this.variantDslInfo.getDirName() + "/obj");
        for (Abi abi : Abi.values()) {
            this.addNdkDebuggableLibraryFolders(abi, new File(objFolder, "local/" + abi.getTag()));
        }
    }

    @Override
    public PublishingSpecs.VariantSpec getPublishingSpec() {
        return this.variantPublishingSpec;
    }

    @Override
    public void publishIntermediateArtifact(Provider<?> artifact, AndroidArtifacts.ArtifactType artifactType, Collection<AndroidArtifacts.PublishedConfigType> configTypes) {
        Preconditions.checkState((!configTypes.isEmpty() ? 1 : 0) != 0);
        for (AndroidArtifacts.PublishedConfigType configType : AndroidArtifacts.PublishedConfigType.values()) {
            if (!configTypes.contains((Object)configType)) continue;
            Configuration config2 = this.variantDependencies.getElements(configType);
            Preconditions.checkNotNull((Object)config2, (Object)String.format(PUBLISH_ERROR_MSG, new Object[]{configType, this.variantDslInfo.getVariantType()}));
            if (configType.isPublicationConfig()) {
                String classifier = null;
                if (configType.isClassifierRequired()) {
                    classifier = this.componentIdentity.getName();
                }
                ArtifactPublishingUtil.publishArtifactToDefaultVariant(config2, artifact, artifactType, classifier);
                continue;
            }
            ArtifactPublishingUtil.publishArtifactToConfiguration(config2, artifact, artifactType);
        }
    }

    @Override
    public boolean useResourceShrinker() {
        VariantType variantType = this.variantDslInfo.getVariantType();
        if (variantType.isForTesting() || !this.postProcessingOptions.resourcesShrinkingEnabled()) {
            return false;
        }
        if (variantType.isDynamicFeature() || this.globalScope.hasDynamicFeatures()) {
            this.globalScope.getDslServices().getIssueReporter().reportError(IssueReporter.Type.GENERIC, "Resource shrinker cannot be used for multi-apk applications");
            return false;
        }
        if (variantType.isAar()) {
            this.globalScope.getDslServices().getIssueReporter().reportError(IssueReporter.Type.GENERIC, "Resource shrinker cannot be used for libraries.");
            return false;
        }
        if (this.getCodeShrinker() == null) {
            this.globalScope.getDslServices().getIssueReporter().reportError(IssueReporter.Type.GENERIC, "Removing unused resources requires unused code shrinking to be turned on. See http://d.android.com/r/tools/shrink-resources.html for more information.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isPrecompileDependenciesResourcesEnabled() {
        return this.globalScope.getProjectOptions().get(BooleanOption.PRECOMPILE_DEPENDENCIES_RESOURCES) && !this.useResourceShrinker();
    }

    @Override
    public boolean isCrunchPngs() {
        Boolean buildTypeOverride = this.variantDslInfo.isCrunchPngs();
        if (buildTypeOverride != null) {
            return buildTypeOverride;
        }
        Boolean globalOverride = this.globalScope.getExtension().getAaptOptions().getCruncherEnabledOverride();
        if (globalOverride != null) {
            return globalOverride;
        }
        return this.variantDslInfo.isCrunchPngsDefault();
    }

    @Override
    public boolean consumesFeatureJars() {
        return this.variantDslInfo.getVariantType().isBaseModule() && this.variantDslInfo.isMinifyEnabled() && this.globalScope.hasDynamicFeatures();
    }

    @Override
    public boolean getNeedsJavaResStreams() {
        return this.variantDslInfo.getVariantType().isAar() && !this.globalScope.getExtension().getTransforms().isEmpty();
    }

    @Override
    public boolean getNeedsMergedJavaResStream() {
        return this.variantDslInfo.getVariantType().isAar() || !this.globalScope.getExtension().getTransforms().isEmpty() || this.getCodeShrinker() != null;
    }

    @Override
    public boolean getNeedsMainDexListForBundle() {
        return this.variantDslInfo.getVariantType().isBaseModule() && this.globalScope.hasDynamicFeatures() && this.variantDslInfo.getDexingType().getNeedsMainDexList();
    }

    @Override
    public CodeShrinker getCodeShrinker() {
        boolean isTestComponent = this.variantDslInfo.getVariantType().isTestComponent();
        if (isTestComponent && this.testedVariantProperties != null && this.testedVariantProperties.getVariantType().isAar()) {
            return null;
        }
        CodeShrinker codeShrinker = this.postProcessingOptions.getCodeShrinker();
        if (codeShrinker == null) {
            return null;
        }
        Boolean enableR8 = this.globalScope.getProjectOptions().get(OptionalBooleanOption.ENABLE_R8);
        if (this.variantDslInfo.getVariantType().isAar() && !this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_R8_LIBRARIES)) {
            enableR8 = false;
        }
        if (enableR8 == null) {
            return codeShrinker;
        }
        if (enableR8.booleanValue()) {
            return CodeShrinker.R8;
        }
        return CodeShrinker.PROGUARD;
    }

    @Override
    public List<File> getProguardFiles() {
        List<File> result = this.getExplicitProguardFiles();
        if (result.isEmpty()) {
            return this.postProcessingOptions.getDefaultProguardFiles();
        }
        return result;
    }

    @Override
    public List<File> getExplicitProguardFiles() {
        return this.gatherProguardFiles(ProguardFileType.EXPLICIT);
    }

    @Override
    public List<File> getTestProguardFiles() {
        return this.gatherProguardFiles(ProguardFileType.TEST);
    }

    @Override
    public List<File> getConsumerProguardFiles() {
        return this.gatherProguardFiles(ProguardFileType.CONSUMER);
    }

    @Override
    public List<File> getConsumerProguardFilesForFeatures() {
        boolean includeProguardFiles = this.variantDslInfo.getVariantType().isDynamicFeature();
        List<File> consumerProguardFiles = this.getConsumerProguardFiles();
        if (includeProguardFiles) {
            consumerProguardFiles.addAll(this.getExplicitProguardFiles());
        }
        return ImmutableList.copyOf(consumerProguardFiles);
    }

    private List<File> gatherProguardFiles(ProguardFileType type) {
        List<File> result = this.variantDslInfo.gatherProguardFiles(type);
        result.addAll(this.postProcessingOptions.getProguardFiles(type));
        return result;
    }

    @Override
    public PostprocessingFeatures getPostprocessingFeatures() {
        return this.postProcessingOptions.getPostprocessingFeatures();
    }

    @Override
    public boolean isTestOnly() {
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        Boolean isTestOnlyOverride = projectOptions.get(OptionalBooleanOption.IDE_TEST_ONLY);
        if (isTestOnlyOverride != null) {
            return isTestOnlyOverride;
        }
        return !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI)) || !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY)) || projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API) != null || this.isPreviewTargetPlatform() || this.variantDslInfo.getMinSdkVersion().getCodename() != null || this.variantDslInfo.getTargetSdkVersion().getCodename() != null;
    }

    private boolean isPreviewTargetPlatform() {
        AndroidVersion version = AndroidTargetHash.getVersionFromHash((String)this.globalScope.getExtension().getCompileSdkVersion());
        return version != null && version.isPreview();
    }

    @Override
    public boolean isCoreLibraryDesugaringEnabled() {
        boolean langDesugarEnabled;
        BaseExtension extension = this.globalScope.getExtension();
        boolean libDesugarEnabled = extension.getCompileOptions().getCoreLibraryDesugaringEnabled() != null && extension.getCompileOptions().getCoreLibraryDesugaringEnabled() != false;
        boolean multidexEnabled = this.variantDslInfo.isMultiDexEnabled();
        VariantScope.Java8LangSupport langSupportType = this.getJava8LangSupportType();
        boolean bl = langDesugarEnabled = langSupportType == VariantScope.Java8LangSupport.D8 || langSupportType == VariantScope.Java8LangSupport.R8;
        if (libDesugarEnabled && !langDesugarEnabled) {
            this.globalScope.getDslServices().getIssueReporter().reportError(IssueReporter.Type.GENERIC, "In order to use core library desugaring, please enable java 8 language desugaring with D8 or R8.");
        }
        if (libDesugarEnabled && !multidexEnabled) {
            this.globalScope.getDslServices().getIssueReporter().reportError(IssueReporter.Type.GENERIC, "In order to use core library desugaring, please enable multidex.");
        }
        return libDesugarEnabled;
    }

    @Override
    public boolean getNeedsShrinkDesugarLibrary() {
        if (!this.isCoreLibraryDesugaringEnabled()) {
            return false;
        }
        return this.getJava8LangSupportType() != VariantScope.Java8LangSupport.D8 || !this.variantDslInfo.isDebuggable();
    }

    @Override
    public void addNdkDebuggableLibraryFolders(Abi abi, File searchPath) {
        this.ndkDebuggableLibraryFolders.put(abi, searchPath);
    }

    @Override
    public FileCollection getLocalPackagedJars() {
        return this.getLocalFileDependencies(file -> file.getName().toLowerCase(Locale.US).endsWith(".jar"));
    }

    @Override
    public FileCollection getLocalFileDependencies(Predicate<File> filePredicate) {
        Configuration configuration2 = this.variantDependencies.getRuntimeClasspath();
        Callable<Collection> dependencies = () -> (ImmutableList)configuration2.getAllDependencies().stream().filter(it -> it instanceof SelfResolvingDependency).filter(it -> !(it instanceof ProjectDependency)).map(it -> (SelfResolvingDependency)it).collect(ImmutableList.toImmutableList());
        return this.globalScope.getProject().files(new Object[]{() -> ((Collection)dependencies.call()).stream().flatMap(it -> it.resolve().stream()).filter(filePredicate).collect(Collectors.toList())}).builtBy(new Object[]{dependencies});
    }

    @Override
    public FileCollection getProvidedOnlyClasspath() {
        ArtifactCollection compile = this.variantDependencies.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES_JAR);
        ArtifactCollection runtime = this.variantDependencies.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES_JAR);
        return ProvidedClasspath.getProvidedClasspath(compile, runtime);
    }

    @Override
    public Provider<RegularFile> getRJarForUnitTests() {
        VariantType variantType = this.variantDslInfo.getVariantType();
        Preconditions.checkNotNull((Object)this.testedVariantProperties, (Object)("Variant type does not have a tested variant: " + variantType));
        Preconditions.checkState((variantType == VariantTypeImpl.UNIT_TEST ? 1 : 0) != 0, (Object)("Expected unit test type but found: " + variantType));
        if (this.testedVariantProperties.getVariantType().isAar()) {
            return this.artifacts.get(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE);
        }
        Preconditions.checkState((boolean)this.testedVariantProperties.getVariantType().isApk(), (Object)("Expected APK type but found: " + this.testedVariantProperties.getVariantType()));
        return this.testedVariantProperties.getArtifacts().get(InternalArtifactType.COMPILE_AND_RUNTIME_NOT_NAMESPACED_R_CLASS_JAR.INSTANCE);
    }

    @Override
    public VariantScope.Java8LangSupport getJava8LangSupportType() {
        if (!this.globalScope.getExtension().getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
            return VariantScope.Java8LangSupport.UNUSED;
        }
        if (this.globalScope.getProject().getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            return VariantScope.Java8LangSupport.RETROLAMBDA;
        }
        CodeShrinker shrinker = this.getCodeShrinker();
        if (shrinker == CodeShrinker.R8) {
            if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_R8_DESUGARING)) {
                return VariantScope.Java8LangSupport.R8;
            }
        } else if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8_DESUGARING) && this.isValidJava8Flag(BooleanOption.ENABLE_D8_DESUGARING, BooleanOption.ENABLE_D8)) {
            return VariantScope.Java8LangSupport.D8;
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_DESUGAR)) {
            return VariantScope.Java8LangSupport.DESUGAR;
        }
        BooleanOption missingFlag = shrinker == CodeShrinker.R8 ? BooleanOption.ENABLE_R8_DESUGARING : BooleanOption.ENABLE_D8_DESUGARING;
        this.globalScope.getDslServices().getIssueReporter().reportError(IssueReporter.Type.GENERIC, String.format("Please add '%s=true' to your gradle.properties file to enable Java 8 language support.", missingFlag.name()), this.variantDslInfo.getComponentIdentity().getName());
        return VariantScope.Java8LangSupport.INVALID;
    }

    private boolean isValidJava8Flag(BooleanOption flag, BooleanOption ... dependsOn2) {
        ArrayList invalid = null;
        for (BooleanOption requiredFlag : dependsOn2) {
            if (this.globalScope.getProjectOptions().get(requiredFlag)) continue;
            if (invalid == null) {
                invalid = Lists.newArrayList();
            }
            invalid.add("'" + requiredFlag.getPropertyName() + "= false'");
        }
        if (invalid == null) {
            return true;
        }
        String template = "Java 8 language support, as requested by '%s= true' in your gradle.properties file, is not supported when %s.";
        String msg = String.format(template, flag.getPropertyName(), String.join((CharSequence)",", invalid));
        this.globalScope.getDslServices().getIssueReporter().reportError(IssueReporter.Type.GENERIC, msg, this.variantDslInfo.getComponentIdentity().getName());
        return false;
    }

    @Override
    public ConfigurableFileCollection getTryWithResourceRuntimeSupportJar() {
        return this.desugarTryWithResourcesRuntimeJar.get();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.componentIdentity.getName()).toString();
    }

    @Override
    public DexerTool getDexer() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8)) {
            return DexerTool.D8;
        }
        return DexerTool.DX;
    }

    @Override
    public DexMergerTool getDexMerger() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8)) {
            return DexMergerTool.D8;
        }
        return DexMergerTool.DX;
    }

    @Override
    public FileCollection getBootClasspath() {
        return this.globalScope.getProject().files(new Object[]{this.globalScope.getBootClasspath()});
    }

    @Override
    public JarCreatorType getJarCreatorType() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.USE_NEW_JAR_CREATOR)) {
            return JarCreatorType.JAR_FLINGER;
        }
        return JarCreatorType.JAR_MERGER;
    }

    @Override
    public ApkCreatorType getApkCreatorType() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.USE_NEW_APK_CREATOR)) {
            return ApkCreatorType.APK_FLINGER;
        }
        return ApkCreatorType.APK_Z_FILE_CREATOR;
    }
}

