/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.api.component.analytics

import com.android.build.api.variant.LibraryVariant
import com.android.build.api.variant.LibraryVariantProperties
import com.google.wireless.android.sdk.stats.GradleBuildVariant
import javax.inject.Inject

/**
 * Shim object for [LibraryVariant] that records all mutating accesses to the analytics.
 */
open class AnalyticsEnabledLibraryVariant<PropertiesT: LibraryVariantProperties> @Inject constructor(
    delegate: LibraryVariant<PropertiesT>,
    stats: GradleBuildVariant.Builder
) : AnalyticsEnabledVariant<PropertiesT>(delegate, stats),
    LibraryVariant<PropertiesT>