/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.build.gradle.internal.variant

import com.android.build.api.component.ComponentProperties
import com.android.build.api.component.analytics.AnalyticsEnabledVariant
import com.android.build.api.component.impl.ComponentImpl
import com.android.build.api.component.impl.ComponentPropertiesImpl
import com.android.build.api.variant.VariantProperties
import com.google.wireless.android.sdk.stats.GradleBuildVariant

class ComponentInfo<
        ComponentT : ComponentImpl<out ComponentProperties>,
        ComponentPropertiesT : ComponentPropertiesImpl>(
    val variant: ComponentT,
    val properties: ComponentPropertiesT,
    val stats: GradleBuildVariant.Builder,
    val userVisibleVariant: AnalyticsEnabledVariant<in VariantProperties>?
)
