/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.io.IAbstractFile;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.sdklib.FileOpFileWrapper;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000212B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"J$\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0010J \u0010)\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u0010H\u0002J\u0014\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100+H\u0002J\u0014\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100\"J\u000e\u0010/\u001a\u0002002\u0006\u0010'\u001a\u00020\u0010R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\r\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00063"}, d2={"Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService$Parameters;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/provider/ProviderFactory;)V", "avdManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "getAvdManager", "()Lcom/android/sdklib/internal/avd/AvdManager;", "avdManager$delegate", "Lkotlin/Lazy;", "defaultEmulatorPropertiesMap", "", "", "deviceManager", "Lcom/android/sdklib/devices/DeviceManager;", "getDeviceManager", "()Lcom/android/sdklib/devices/DeviceManager;", "deviceManager$delegate", "logger", "Lcom/android/utils/ILogger;", "sdkDirectory", "Ljava/io/File;", "getSdkDirectory", "()Ljava/io/File;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "getSdkHandler", "()Lcom/android/sdklib/repository/AndroidSdkHandler;", "sdkHandler$delegate", "allAvds", "", "avdProvider", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "imageHash", "deviceName", "hardwareProfile", "createOrRetrieveAvd", "defaultHardwareConfig", "", "deleteAvds", "", "avds", "deviceSnapshotCreated", "", "Parameters", "RegistrationAction", "gradle-core"})
public abstract class AvdComponentsBuildService
implements BuildService<Parameters> {
    private final Lazy sdkHandler$delegate;
    private final ILogger logger;
    private final Lazy avdManager$delegate;
    private final Lazy deviceManager$delegate;
    private final Map<String, String> defaultEmulatorPropertiesMap;
    private final ObjectFactory objectFactory;
    private final ProviderFactory providerFactory;

    private final File getSdkDirectory() {
        Object object = ((SdkComponentsBuildService)((Parameters)this.getParameters()).getSdkService().get()).getSdkDirectoryProvider().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.sdkService.ge\u2026dkDirectoryProvider.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"parameters.sdkService.ge\u2026toryProvider.get().asFile");
        return file;
    }

    private final AndroidSdkHandler getSdkHandler() {
        Lazy lazy = this.sdkHandler$delegate;
        AvdComponentsBuildService avdComponentsBuildService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (AndroidSdkHandler)lazy.getValue();
    }

    private final AvdManager getAvdManager() {
        Lazy lazy = this.avdManager$delegate;
        AvdComponentsBuildService avdComponentsBuildService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (AvdManager)lazy.getValue();
    }

    private final DeviceManager getDeviceManager() {
        Lazy lazy = this.deviceManager$delegate;
        AvdComponentsBuildService avdComponentsBuildService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DeviceManager)lazy.getValue();
    }

    private final File createOrRetrieveAvd(String imageHash, String deviceName, String hardwareProfile) {
        Object v4;
        ISystemImage systemImage;
        block7: {
            Provider<Directory> imageProvider;
            AvdInfo info2 = this.getAvdManager().getAvd(deviceName, false);
            if (info2 != null) {
                if (info2.getConfigFile().exists()) {
                    this.logger.info("Device: " + deviceName + " already exists. AVD creation skipped.", new Object[0]);
                    File file = info2.getConfigFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"info.configFile");
                    return file;
                }
                this.getAvdManager().reloadAvds(this.logger);
            }
            if (!(imageProvider = ((SdkComponentsBuildService)((Parameters)this.getParameters()).getSdkService().get()).sdkImageDirectoryProvider(imageHash)).isPresent()) {
                throw (Throwable)new RuntimeException("Failed to find system image for hash: " + imageHash);
            }
            Object object = imageProvider.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"imageProvider.get()");
            File imageLocation = ((Directory)object).getAsFile();
            systemImage = this.getSdkHandler().getSystemImageManager((ProgressIndicator)new LoggerProgressIndicatorWrapper((ILogger)new StdLogger(StdLogger.Level.VERBOSE))).getImageAt(imageLocation);
            if (systemImage == null) {
                throw (Throwable)new RuntimeException("System image does not exist at " + imageLocation);
            }
            Collection collection = this.getDeviceManager().getDevices(DeviceManager.ALL_DEVICES);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"deviceManager.getDevices\u2026eviceManager.ALL_DEVICES)");
            Iterable iterable = collection;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                Device it = (Device)t;
                boolean bl3 = false;
                Device device = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)device, (String)"it");
                if (!Intrinsics.areEqual((Object)device.getDisplayName(), (Object)hardwareProfile)) continue;
                v4 = t;
                break block7;
            }
            v4 = null;
        }
        Device device = v4;
        if (device == null) {
            throw (Throwable)new RuntimeException("Failed to find hardware profile for name: " + hardwareProfile);
        }
        Device device2 = device;
        Map<String, String> hardwareConfig = this.defaultHardwareConfig();
        Map map2 = DeviceManager.getHardwareProperties((Device)device2);
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"DeviceManager.getHardwareProperties(device)");
        hardwareConfig.putAll(map2);
        EmulatedProperties.restrictDefaultRamSize(hardwareConfig);
        File deviceFolder = AvdInfo.getDefaultAvdFolder((AvdManager)this.getAvdManager(), (String)deviceName, (FileOp)this.getSdkHandler().getFileOp(), (boolean)false);
        AvdInfo newInfo = this.getAvdManager().createAvd(deviceFolder, deviceName, systemImage, null, null, null, hardwareConfig, device2.getBootProps(), device2.hasPlayStore(), false, false, this.logger);
        Object object = newInfo;
        if (object == null || (object = object.getConfigFile()) == null) {
            String string = "AVD could not be created.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allAvds() {
        void $this$mapTo$iv$iv;
        this.getAvdManager().reloadAvds(this.logger);
        AvdInfo[] avdInfoArray = this.getAvdManager().getAllAvds();
        Intrinsics.checkExpressionValueIsNotNull((Object)avdInfoArray, (String)"avdManager.allAvds");
        AvdInfo[] $this$map$iv = avdInfoArray;
        boolean $i$f$map = false;
        AvdInfo[] avdInfoArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = var6_6[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            String string = v1.getName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public final void deleteAvds(@NotNull List<String> avds) {
        Intrinsics.checkParameterIsNotNull(avds, (String)"avds");
        this.getAvdManager().reloadAvds(this.logger);
        for (String avdName : avds) {
            AvdInfo avdInfo = this.getAvdManager().getAvd(avdName, false);
            if (avdInfo != null) {
                this.getAvdManager().deleteAvd(avdInfo, this.logger);
                continue;
            }
            this.logger.warning("Failed to delete avd: " + avdName + '.', new Object[0]);
        }
    }

    private final Map<String, String> defaultHardwareConfig() {
        Provider<Directory> emulatorProvider = ((SdkComponentsBuildService)((Parameters)this.getParameters()).getSdkService().get()).getEmulatorDirectoryProvider();
        if (!emulatorProvider.isPresent()) {
            String string = "AVD Emulator package is not downloaded. Failed to retrieve hardware defaults for virtual device.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object object = emulatorProvider.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"emulatorProvider.get()");
        File emulatorLib = ((Directory)object).getAsFile();
        File libDirectory = new File(emulatorLib, "lib");
        File hardwareDefs = new File(libDirectory, "hardware-properties.ini");
        Map hwMap = HardwareProperties.parseHardwareDefinitions((IAbstractFile)((IAbstractFile)new FileOpFileWrapper(hardwareDefs, this.getSdkHandler().getFileOp(), false)), (ILogger)this.logger);
        Map hwConfigMap = MapsKt.toMutableMap(this.defaultEmulatorPropertiesMap);
        Iterable $this$forEach$iv = hwMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HardwareProperties.HardwareProperty it = (HardwareProperties.HardwareProperty)element$iv;
            boolean bl = false;
            HardwareProperties.HardwareProperty hardwareProperty = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)hardwareProperty, (String)"it");
            String string = hardwareProperty.getDefault();
            CharSequence charSequence = string;
            boolean bl2 = false;
            boolean bl3 = false;
            if (charSequence == null || charSequence.length() == 0) continue;
            String string2 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.name");
            hwConfigMap.put(string2, string);
        }
        return hwConfigMap;
    }

    @NotNull
    public final Provider<Directory> avdProvider(@NotNull String imageHash, @NotNull String deviceName, @NotNull String hardwareProfile) {
        Intrinsics.checkParameterIsNotNull((Object)imageHash, (String)"imageHash");
        Intrinsics.checkParameterIsNotNull((Object)deviceName, (String)"deviceName");
        Intrinsics.checkParameterIsNotNull((Object)hardwareProfile, (String)"hardwareProfile");
        DirectoryProperty directoryProperty = this.objectFactory.directoryProperty().fileProvider(this.providerFactory.provider((Callable)new Callable<File>(this, imageHash, deviceName, hardwareProfile){
            final /* synthetic */ AvdComponentsBuildService this$0;
            final /* synthetic */ String $imageHash;
            final /* synthetic */ String $deviceName;
            final /* synthetic */ String $hardwareProfile;

            public final File call() {
                return AvdComponentsBuildService.access$createOrRetrieveAvd(this.this$0, this.$imageHash, this.$deviceName, this.$hardwareProfile);
            }
            {
                this.this$0 = avdComponentsBuildService;
                this.$imageHash = string;
                this.$deviceName = string2;
                this.$hardwareProfile = string3;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty, (String)"objectFactory.directoryP\u2026rdwareProfile)\n        })");
        return (Provider)directoryProperty;
    }

    public final boolean deviceSnapshotCreated(@NotNull String deviceName) {
        Intrinsics.checkParameterIsNotNull((Object)deviceName, (String)"deviceName");
        AvdInfo avdInfo = this.getAvdManager().getAvd(deviceName, false);
        if (avdInfo == null) {
            return false;
        }
        AvdInfo device = avdInfo;
        File snapshotPath = new File(device.getDataFolderPath(), "snapshots/default_boot/snapshot.pb");
        return snapshotPath.exists();
    }

    @Inject
    public AvdComponentsBuildService(@NotNull ObjectFactory objectFactory, @NotNull ProviderFactory providerFactory) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)providerFactory, (String)"providerFactory");
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
        this.sdkHandler$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AndroidSdkHandler>(this){
            final /* synthetic */ AvdComponentsBuildService this$0;

            public final AndroidSdkHandler invoke() {
                return AndroidSdkHandler.getInstance((File)AvdComponentsBuildService.access$getSdkDirectory$p(this.this$0));
            }
            {
                this.this$0 = avdComponentsBuildService;
                super(0);
            }
        }));
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(AvdComponentsBuildService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"LoggerWrapper.getLogger(\u2026BuildService::class.java)");
        this.logger = loggerWrapper;
        this.avdManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AvdManager>(this){
            final /* synthetic */ AvdComponentsBuildService this$0;

            @NotNull
            public final AvdManager invoke() {
                AndroidSdkHandler androidSdkHandler = AvdComponentsBuildService.access$getSdkHandler$p(this.this$0);
                Object object = ((Parameters)this.this$0.getParameters()).getAvdLocation().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.avdLocation.get()");
                AvdManager avdManager2 = AvdManager.getInstance((AndroidSdkHandler)androidSdkHandler, (File)((Directory)object).getAsFile(), (ILogger)AvdComponentsBuildService.access$getLogger$p(this.this$0));
                if (avdManager2 == null) {
                    throw (Throwable)new RuntimeException("Failed to initialize AvdManager");
                }
                return avdManager2;
            }
            {
                this.this$0 = avdComponentsBuildService;
                super(0);
            }
        }));
        this.deviceManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DeviceManager>(this){
            final /* synthetic */ AvdComponentsBuildService this$0;

            public final DeviceManager invoke() {
                return DeviceManager.createInstance((File)AvdComponentsBuildService.access$getSdkDirectory$p(this.this$0), (ILogger)AvdComponentsBuildService.access$getLogger$p(this.this$0));
            }
            {
                this.this$0 = avdComponentsBuildService;
                super(0);
            }
        }));
        this.defaultEmulatorPropertiesMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"hw.camera.back", (Object)AvdCamera.EMULATED.getAsParameter()), TuplesKt.to((Object)"hw.cpu.ncore", (Object)String.valueOf(EmulatedProperties.RECOMMENDED_NUMBER_OF_CORES)), TuplesKt.to((Object)"skin.path", (Object)"_no_skin"), TuplesKt.to((Object)"showDeviceFrame", (Object)"yes"), TuplesKt.to((Object)"hw.camera.front", (Object)AvdCamera.EMULATED.getAsParameter()), TuplesKt.to((Object)"hw.keyboard", (Object)"yes"), TuplesKt.to((Object)"hw.gpu.mode", (Object)GpuMode.AUTO.getGpuSetting()), TuplesKt.to((Object)"hw.initialOrientation", (Object)"Portrait"), TuplesKt.to((Object)"disk.dataPartition.size", (Object)EmulatedProperties.DEFAULT_INTERNAL_STORAGE.toString()), TuplesKt.to((Object)"runtime.network.latency", (Object)"None"), TuplesKt.to((Object)"runtime.network.speed", (Object)"Full"), TuplesKt.to((Object)"sdcard.size", (Object)EmulatedProperties.DEFAULT_SDCARD_SIZE.toString()), TuplesKt.to((Object)"fastboot.forceChosenSnapshotBoot", (Object)"no"), TuplesKt.to((Object)"fastboot.forceColdBoot", (Object)"no"), TuplesKt.to((Object)"fastboot.forceFastBoot", (Object)"yes"), TuplesKt.to((Object)"hw.gpu.enabled", (Object)"yes"), TuplesKt.to((Object)"vm.heapSize", (Object)EmulatedProperties.DEFAULT_HEAP.toString())});
    }

    public static final /* synthetic */ File access$createOrRetrieveAvd(AvdComponentsBuildService $this, String imageHash, String deviceName, String hardwareProfile) {
        return $this.createOrRetrieveAvd(imageHash, deviceName, hardwareProfile);
    }

    public static final /* synthetic */ File access$getSdkDirectory$p(AvdComponentsBuildService $this) {
        return $this.getSdkDirectory();
    }

    public static final /* synthetic */ AndroidSdkHandler access$getSdkHandler$p(AvdComponentsBuildService $this) {
        return $this.getSdkHandler();
    }

    public static final /* synthetic */ ILogger access$getLogger$p(AvdComponentsBuildService $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/AvdComponentsBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "avdLocation", "Lorg/gradle/api/file/DirectoryProperty;", "getAvdLocation", "()Lorg/gradle/api/file/DirectoryProperty;", "sdkService", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "getSdkService", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static interface Parameters
    extends BuildServiceParameters {
        @NotNull
        public Property<SdkComponentsBuildService> getSdkService();

        @NotNull
        public DirectoryProperty getAvdLocation();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/AvdComponentsBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService;", "Lcom/android/build/gradle/internal/AvdComponentsBuildService$Parameters;", "project", "Lorg/gradle/api/Project;", "avdFolderLocation", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "sdkService", "Lcom/android/build/gradle/internal/SdkComponentsBuildService;", "(Lorg/gradle/api/Project;Lorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;)V", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<AvdComponentsBuildService, Parameters> {
        private final Provider<Directory> avdFolderLocation;
        private final Provider<SdkComponentsBuildService> sdkService;

        @Override
        public void configure(@NotNull Parameters parameters) {
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            parameters.getAvdLocation().set(this.avdFolderLocation);
            parameters.getSdkService().set(this.sdkService);
        }

        public RegistrationAction(@NotNull Project project, @NotNull Provider<Directory> avdFolderLocation, @NotNull Provider<SdkComponentsBuildService> sdkService) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(avdFolderLocation, (String)"avdFolderLocation");
            Intrinsics.checkParameterIsNotNull(sdkService, (String)"sdkService");
            super(project, AvdComponentsBuildService.class, null, 4, null);
            this.avdFolderLocation = avdFolderLocation;
            this.sdkService = sdkService;
        }
    }
}

