/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide.dependencies;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollections;
import com.android.build.gradle.internal.ide.dependencies.ArtifactCollectionsInputs;
import com.android.build.gradle.internal.ide.dependencies.MavenCoordinatesCacheBuildService;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.services.BuildServicesKt;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistration;
import org.gradle.api.services.BuildServiceRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u001aJ\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0016\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015*\u00020\u0018\u00a8\u0006\u0019"}, d2={"getAllArtifacts", "", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "componentImpl", "Lcom/android/build/api/component/impl/ComponentImpl;", "consumedConfigType", "Lcom/android/build/gradle/internal/publishing/AndroidArtifacts$ConsumedConfigType;", "dependencyFailureHandler", "Lcom/android/build/gradle/internal/ide/DependencyFailureHandler;", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "collections", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactCollections;", "projectPath", "variantName", "mavenCoordinatesCache", "Lcom/android/build/gradle/internal/ide/dependencies/MavenCoordinatesCacheBuildService;", "inputs", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactCollectionsInputs;", "asMultiMap", "Lcom/google/common/collect/ImmutableMultimap;", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "gradle-core"})
@JvmName(name="ArtifactUtils")
public final class ArtifactUtils {
    @NotNull
    public static final Set<ResolvedArtifact> getAllArtifacts(@NotNull ComponentImpl componentImpl, @NotNull AndroidArtifacts.ConsumedConfigType consumedConfigType, @Nullable DependencyFailureHandler dependencyFailureHandler, @NotNull ImmutableMap<String, String> buildMapping) {
        Intrinsics.checkParameterIsNotNull((Object)componentImpl, (String)"componentImpl");
        Intrinsics.checkParameterIsNotNull((Object)((Object)consumedConfigType), (String)"consumedConfigType");
        Intrinsics.checkParameterIsNotNull(buildMapping, (String)"buildMapping");
        ArtifactCollections collections = new ArtifactCollections(componentImpl, consumedConfigType);
        BuildServiceRegistry buildServiceRegistry$iv = componentImpl.getServices().getBuildServiceRegistry();
        boolean $i$f$getBuildService = false;
        Object object = buildServiceRegistry$iv.getRegistrations().getByName(BuildServicesKt.getBuildServiceName(MavenCoordinatesCacheBuildService.class));
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.services.BuildServiceRegistration<ServiceT, *>");
        }
        Provider provider2 = ((BuildServiceRegistration)object).getService();
        Intrinsics.checkExpressionValueIsNotNull((Object)provider2, (String)"(buildServiceRegistry.re\u2026erviceT, *>).getService()");
        MavenCoordinatesCacheBuildService mavenCoordinatesCache = (MavenCoordinatesCacheBuildService)provider2.get();
        Project project = componentImpl.getGlobalScope().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"componentImpl.globalScope.project");
        String string = project.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"componentImpl.globalScope.project.path");
        String string2 = componentImpl.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"componentImpl.name");
        MavenCoordinatesCacheBuildService mavenCoordinatesCacheBuildService = mavenCoordinatesCache;
        Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinatesCacheBuildService, (String)"mavenCoordinatesCache");
        return ArtifactUtils.getAllArtifacts(collections, dependencyFailureHandler, buildMapping, string, string2, mavenCoordinatesCacheBuildService);
    }

    @NotNull
    public static final Set<ResolvedArtifact> getAllArtifacts(@NotNull ArtifactCollectionsInputs inputs, @NotNull AndroidArtifacts.ConsumedConfigType consumedConfigType, @Nullable DependencyFailureHandler dependencyFailureHandler) {
        ArtifactCollections artifactCollections;
        Intrinsics.checkParameterIsNotNull((Object)inputs, (String)"inputs");
        Intrinsics.checkParameterIsNotNull((Object)((Object)consumedConfigType), (String)"consumedConfigType");
        if (consumedConfigType == AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH) {
            artifactCollections = inputs.getCompileClasspath();
        } else {
            artifactCollections = inputs.getRuntimeClasspath();
            if (artifactCollections == null) {
                Intrinsics.throwNpe();
            }
        }
        ArtifactCollections collections = artifactCollections;
        ImmutableMap<String, String> immutableMap = inputs.getBuildMapping();
        String string = inputs.getProjectPath();
        String string2 = inputs.getVariantName();
        Object object = inputs.getMavenCoordinatesCache$gradle_core().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputs.mavenCoordinatesCache.get()");
        return ArtifactUtils.getAllArtifacts(collections, dependencyFailureHandler, immutableMap, string, string2, (MavenCoordinatesCacheBuildService)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ResolvedArtifact> getAllArtifacts(@NotNull ArtifactCollections collections, @Nullable DependencyFailureHandler dependencyFailureHandler, @NotNull ImmutableMap<String, String> buildMapping, @NotNull String projectPath, @NotNull String variantName, @NotNull MavenCoordinatesCacheBuildService mavenCoordinatesCache) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)collections, (String)"collections");
        Intrinsics.checkParameterIsNotNull(buildMapping, (String)"buildMapping");
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)mavenCoordinatesCache, (String)"mavenCoordinatesCache");
        ArtifactCollection incomingArtifacts = collections.getAll();
        ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> manifests = ArtifactUtils.asMultiMap(collections.getManifests());
        ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> explodedAars = ArtifactUtils.asMultiMap(collections.getExplodedAars());
        ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> projectJars = ArtifactUtils.asMultiMap(collections.getProjectJars());
        if (dependencyFailureHandler != null) {
            Collection failures = incomingArtifacts.getFailures();
            String string = projectPath + "@" + variantName + "/" + collections.getConsumedConfigType().getName();
            Collection collection = failures;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"failures");
            dependencyFailureHandler.addErrors(string, collection);
        }
        ImmutableSet immutableSet = explodedAars.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"explodedAars.keySet()");
        Iterable $this$filterIsInstance$iv = (Iterable)immutableSet;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ProjectComponentIdentifier)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List aarWrappedAsProjects = (List)destination$iv$iv;
        Set resolvedArtifactResults = incomingArtifacts.getArtifacts();
        LinkedHashSet artifacts2 = Sets.newLinkedHashSetWithExpectedSize((int)resolvedArtifactResults.size());
        Iterator iterator = resolvedArtifactResults.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            ResolvedArtifactResult resolvedComponentResult;
            ResolvedArtifactResult resolvedArtifactResult = resolvedComponentResult = (ResolvedArtifactResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"resolvedComponentResult");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"resolvedComponentResult.id");
            ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
            boolean isAarWrappedAsProject = CollectionsKt.contains((Iterable)aarWrappedAsProjects, (Object)componentIdentifier);
            ResolvedArtifact.DependencyType dependencyType = null;
            ImmutableCollection immutableCollection = explodedAars.get((Object)componentIdentifier);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection, (String)"explodedAars[componentIdentifier]");
            Collection extractedAar = (Collection)immutableCollection;
            ImmutableCollection immutableCollection2 = manifests.get((Object)componentIdentifier);
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection2, (String)"manifests[componentIdentifier]");
            Collection manifest = (Collection)immutableCollection2;
            Collection mainArtifacts = null;
            ResolvedVariantResult resolvedVariantResult = resolvedComponentResult.getVariant();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedVariantResult, (String)"resolvedComponentResult.variant");
            String artifactType = (String)resolvedVariantResult.getAttributes().getAttribute(AndroidArtifacts.ARTIFACT_TYPE);
            Object object = artifactType;
            if (Intrinsics.areEqual((Object)object, (Object)AndroidArtifacts.ArtifactType.AAR.getType())) {
                dependencyType = ResolvedArtifact.DependencyType.ANDROID;
                mainArtifacts = CollectionsKt.listOf((Object)resolvedComponentResult);
            } else if (Intrinsics.areEqual((Object)object, (Object)AndroidArtifacts.ArtifactType.JAR.getType())) {
                Collection collection = manifest;
                bl = false;
                if (!collection.isEmpty()) {
                    dependencyType = ResolvedArtifact.DependencyType.ANDROID;
                    mainArtifacts = manifest;
                } else {
                    ImmutableCollection projectJar;
                    dependencyType = ResolvedArtifact.DependencyType.JAVA;
                    ImmutableCollection immutableCollection3 = projectJar = projectJars.get((Object)componentIdentifier);
                    Intrinsics.checkExpressionValueIsNotNull((Object)immutableCollection3, (String)"projectJar");
                    Collection collection2 = (Collection)immutableCollection3;
                    boolean bl2 = false;
                    mainArtifacts = !collection2.isEmpty() ? (Collection)projectJar : (Collection)CollectionsKt.listOf((Object)resolvedComponentResult);
                }
            } else {
                throw (Throwable)new IllegalStateException("Internal error: Artifact type " + artifactType + " not expected, only jar or aar are handled.");
            }
            object = mainArtifacts;
            boolean bl3 = false;
            boolean bl4 = !object.isEmpty();
            bl3 = false;
            bl = false;
            if (!bl4) {
                boolean bl5 = false;
                String string = StringsKt.trimMargin$default((String)("Internal Error: No artifact found for artifactType '" + componentIdentifier + "'\n            | context: " + projectPath + ' ' + variantName + "\n            | manifests = " + manifests + "\n            | explodedAars = " + explodedAars + "\n            | projectJars = " + projectJars + "\n        "), null, (int)1, null);
                throw (Throwable)new IllegalStateException(string.toString());
            }
            for (ResolvedArtifactResult mainArtifact : mainArtifacts) {
                artifacts2.add(new ResolvedArtifact(mainArtifact, (ResolvedArtifactResult)CollectionsKt.firstOrNull((Iterable)extractedAar), dependencyType, isAarWrappedAsProject, buildMapping, mavenCoordinatesCache));
            }
        }
        LinkedHashSet linkedHashSet = artifacts2;
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashSet, (String)"artifacts");
        return linkedHashSet;
    }

    @NotNull
    public static final ImmutableMultimap<ComponentIdentifier, ResolvedArtifactResult> asMultiMap(@NotNull ArtifactCollection $this$asMultiMap) {
        Intrinsics.checkParameterIsNotNull((Object)$this$asMultiMap, (String)"$this$asMultiMap");
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        boolean bl = false;
        boolean bl2 = false;
        ImmutableMultimap.Builder builder2 = builder;
        boolean bl3 = false;
        Iterator iterator = $this$asMultiMap.getArtifacts().iterator();
        while (iterator.hasNext()) {
            ResolvedArtifactResult artifact;
            ResolvedArtifactResult resolvedArtifactResult = artifact = (ResolvedArtifactResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifact");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
            builder2.put((Object)componentArtifactIdentifier.getComponentIdentifier(), (Object)artifact);
        }
        ImmutableMultimap immutableMultimap = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMultimap, (String)"ImmutableMultimap.builde\u2026      }\n        }.build()");
        return immutableMultimap;
    }
}

