/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.ide.dependencies.ArtifactHandler;
import com.android.build.gradle.internal.ide.dependencies.BuildMappingUtils;
import com.android.build.gradle.internal.ide.dependencies.LibraryUtils;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.caching.CreatingCache;
import com.android.tools.lint.model.DefaultLintModelAndroidLibrary;
import com.android.tools.lint.model.DefaultLintModelJavaLibrary;
import com.android.tools.lint.model.DefaultLintModelMavenName;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002#$B]\b\u0002\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\u0002\u0010\u000eJT\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0014JX\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0014J4\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0014J0\u0010 \u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0014J\f\u0010!\u001a\u00020\"*\u00020\tH\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/build/gradle/internal/lint/ExternalLintModelArtifactHandler;", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactHandler;", "Lcom/android/tools/lint/model/LintModelLibrary;", "localJarCache", "Lcom/android/ide/common/caching/CreatingCache;", "Ljava/io/File;", "", "mavenCoordinatesCache", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "Lcom/android/builder/model/MavenCoordinates;", "projectExplodedAarsMap", "", "Lcom/android/build/gradle/internal/lint/ExternalLintModelArtifactHandler$ProjectKey;", "projectJarsMap", "(Lcom/android/ide/common/caching/CreatingCache;Lcom/android/ide/common/caching/CreatingCache;Ljava/util/Map;Ljava/util/Map;)V", "handleAndroidLibrary", "aarFile", "folder", "localJavaLibraries", "isProvided", "", "variantName", "", "coordinatesSupplier", "Lkotlin/Function0;", "addressSupplier", "handleAndroidModule", "projectPath", "buildId", "lintJar", "handleJavaLibrary", "jarFile", "handleJavaModule", "toMavenName", "Lcom/android/tools/lint/model/LintModelMavenName;", "Companion", "ProjectKey", "gradle-core"})
public final class ExternalLintModelArtifactHandler
extends ArtifactHandler<LintModelLibrary> {
    private final CreatingCache<File, List<File>> localJarCache;
    private final Map<ProjectKey, File> projectExplodedAarsMap;
    private final Map<ProjectKey, File> projectJarsMap;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected LintModelLibrary handleAndroidLibrary(@NotNull File aarFile, @NotNull File folder, @NotNull List<? extends File> localJavaLibraries, boolean isProvided, @Nullable String variantName, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkParameterIsNotNull((Object)aarFile, (String)"aarFile");
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull(localJavaLibraries, (String)"localJavaLibraries");
        Intrinsics.checkParameterIsNotNull(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkParameterIsNotNull(addressSupplier, (String)"addressSupplier");
        return (LintModelLibrary)new DefaultLintModelAndroidLibrary(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)FileUtils.join((File)folder, (String[])new String[]{"jars", "classes.jar"})), (Iterable)localJavaLibraries), (String)addressSupplier.invoke(), new File(folder, "AndroidManifest.xml"), folder, new File(folder, "res"), new File(folder, "assets"), new File(folder, "lint.jar"), new File(folder, "public.txt"), new File(folder, "R.txt"), new File(folder, "annotations.zip"), new File(folder, "proguard.txt"), isProvided, this.toMavenName((MavenCoordinates)coordinatesSupplier2.invoke()));
    }

    @Override
    @NotNull
    protected LintModelLibrary handleAndroidModule(@NotNull String projectPath, @NotNull String buildId, @Nullable String variantName, @NotNull File aarFile, @Nullable File lintJar, boolean isProvided, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> addressSupplier) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull((Object)aarFile, (String)"aarFile");
        Intrinsics.checkParameterIsNotNull(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkParameterIsNotNull(addressSupplier, (String)"addressSupplier");
        ProjectKey key = new ProjectKey(buildId, projectPath, variantName);
        File file = this.projectExplodedAarsMap.get(key);
        if (file == null) {
            throw (Throwable)new IllegalStateException("unable to find project exploded aar for " + buildId + ' ' + projectPath);
        }
        File folder = file;
        Collection collection = CollectionsKt.listOf((Object)FileUtils.join((File)folder, (String[])new String[]{"jars", "classes.jar"}));
        List list = (List)this.localJarCache.get((Object)folder);
        if (list != null) {
            iterable = list;
        } else {
            boolean bl = false;
            iterable = CollectionsKt.emptyList();
        }
        return (LintModelLibrary)new DefaultLintModelAndroidLibrary(CollectionsKt.plus((Collection)collection, (Iterable)iterable), (String)addressSupplier.invoke(), new File(folder, "AndroidManifest.xml"), folder, new File(folder, "res"), new File(folder, "assets"), new File(folder, "lint.jar"), new File(folder, "public.txt"), new File(folder, "R.txt"), new File(folder, "annotations.zip"), new File(folder, "proguard.txt"), isProvided, this.toMavenName((MavenCoordinates)coordinatesSupplier2.invoke()));
    }

    @Override
    @NotNull
    protected LintModelLibrary handleJavaLibrary(@NotNull File jarFile, boolean isProvided, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkParameterIsNotNull((Object)jarFile, (String)"jarFile");
        Intrinsics.checkParameterIsNotNull(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkParameterIsNotNull(addressSupplier, (String)"addressSupplier");
        return (LintModelLibrary)new DefaultLintModelJavaLibrary((String)addressSupplier.invoke(), CollectionsKt.listOf((Object)jarFile), this.toMavenName((MavenCoordinates)coordinatesSupplier2.invoke()), isProvided);
    }

    @Override
    @NotNull
    protected LintModelLibrary handleJavaModule(@NotNull String projectPath, @NotNull String buildId, @Nullable String variantName, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull(addressSupplier, (String)"addressSupplier");
        String artifactAddress = (String)addressSupplier.invoke();
        ProjectKey key = new ProjectKey(buildId, projectPath, variantName);
        File file = this.projectJarsMap.get(key);
        if (file == null) {
            String string = "Could not find jar for project " + key;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        File jar = file;
        return (LintModelLibrary)new DefaultLintModelJavaLibrary(artifactAddress, CollectionsKt.listOf((Object)jar), (LintModelMavenName)LintModelMavenName.Companion.getNONE(), false);
    }

    private final LintModelMavenName toMavenName(MavenCoordinates $this$toMavenName) {
        return (LintModelMavenName)new DefaultLintModelMavenName($this$toMavenName.getGroupId(), $this$toMavenName.getArtifactId(), $this$toMavenName.getVersion());
    }

    private ExternalLintModelArtifactHandler(CreatingCache<File, List<File>> localJarCache2, CreatingCache<ResolvedArtifact, MavenCoordinates> mavenCoordinatesCache, Map<ProjectKey, ? extends File> projectExplodedAarsMap, Map<ProjectKey, ? extends File> projectJarsMap) {
        super(localJarCache2, mavenCoordinatesCache);
        this.localJarCache = localJarCache2;
        this.projectExplodedAarsMap = projectExplodedAarsMap;
        this.projectJarsMap = projectJarsMap;
    }

    public /* synthetic */ ExternalLintModelArtifactHandler(CreatingCache localJarCache2, CreatingCache mavenCoordinatesCache, Map projectExplodedAarsMap, Map projectJarsMap, DefaultConstructorMarker $constructor_marker) {
        this((CreatingCache<File, List<File>>)localJarCache2, (CreatingCache<ResolvedArtifact, MavenCoordinates>)mavenCoordinatesCache, projectExplodedAarsMap, projectJarsMap);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/lint/ExternalLintModelArtifactHandler$ProjectKey;", "", "buildId", "", "projectPath", "variantName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBuildId", "()Ljava/lang/String;", "getProjectPath", "getVariantName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "gradle-core"})
    private static final class ProjectKey {
        @NotNull
        private final String buildId;
        @NotNull
        private final String projectPath;
        @Nullable
        private final String variantName;

        @NotNull
        public final String getBuildId() {
            return this.buildId;
        }

        @NotNull
        public final String getProjectPath() {
            return this.projectPath;
        }

        @Nullable
        public final String getVariantName() {
            return this.variantName;
        }

        public ProjectKey(@NotNull String buildId, @NotNull String projectPath, @Nullable String variantName) {
            Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
            Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
            this.buildId = buildId;
            this.projectPath = projectPath;
            this.variantName = variantName;
        }

        @NotNull
        public final String component1() {
            return this.buildId;
        }

        @NotNull
        public final String component2() {
            return this.projectPath;
        }

        @Nullable
        public final String component3() {
            return this.variantName;
        }

        @NotNull
        public final ProjectKey copy(@NotNull String buildId, @NotNull String projectPath, @Nullable String variantName) {
            Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
            Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
            return new ProjectKey(buildId, projectPath, variantName);
        }

        public static /* synthetic */ ProjectKey copy$default(ProjectKey projectKey, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = projectKey.buildId;
            }
            if ((n & 2) != 0) {
                string2 = projectKey.projectPath;
            }
            if ((n & 4) != 0) {
                string3 = projectKey.variantName;
            }
            return projectKey.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ProjectKey(buildId=" + this.buildId + ", projectPath=" + this.projectPath + ", variantName=" + this.variantName + ")";
        }

        public int hashCode() {
            String string = this.buildId;
            String string2 = this.projectPath;
            String string3 = this.variantName;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ProjectKey)) break block3;
                    ProjectKey projectKey = (ProjectKey)object;
                    if (!Intrinsics.areEqual((Object)this.buildId, (Object)projectKey.buildId) || !Intrinsics.areEqual((Object)this.projectPath, (Object)projectKey.projectPath) || !Intrinsics.areEqual((Object)this.variantName, (Object)projectKey.variantName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jh\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00062\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\r2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u0013J0\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00070\u0015*\u00020\r2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u0013H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/lint/ExternalLintModelArtifactHandler$Companion;", "", "()V", "create", "Lcom/android/build/gradle/internal/lint/ExternalLintModelArtifactHandler;", "localJarCache", "Lcom/android/ide/common/caching/CreatingCache;", "Ljava/io/File;", "", "mavenCoordinatesCache", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "Lcom/android/builder/model/MavenCoordinates;", "projectExplodedAars", "Lorg/gradle/api/artifacts/ArtifactCollection;", "testedProjectExplodedAars", "projectJars", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "Lcom/android/build/gradle/internal/ide/dependencies/BuildMapping;", "asProjectKeyedMap", "", "Lcom/android/build/gradle/internal/lint/ExternalLintModelArtifactHandler$ProjectKey;", "gradle-core"})
    public static final class Companion {
        @NotNull
        public final ExternalLintModelArtifactHandler create(@NotNull CreatingCache<File, List<File>> localJarCache2, @NotNull CreatingCache<ResolvedArtifact, MavenCoordinates> mavenCoordinatesCache, @Nullable ArtifactCollection projectExplodedAars, @Nullable ArtifactCollection testedProjectExplodedAars, @NotNull ArtifactCollection projectJars, @NotNull ImmutableMap<String, String> buildMapping) {
            Intrinsics.checkParameterIsNotNull(localJarCache2, (String)"localJarCache");
            Intrinsics.checkParameterIsNotNull(mavenCoordinatesCache, (String)"mavenCoordinatesCache");
            Intrinsics.checkParameterIsNotNull((Object)projectJars, (String)"projectJars");
            Intrinsics.checkParameterIsNotNull(buildMapping, (String)"buildMapping");
            Object object = projectExplodedAars;
            if (object == null || (object = this.asProjectKeyedMap((ArtifactCollection)object, buildMapping)) == null) {
                object = MapsKt.emptyMap();
            }
            Object projectExplodedAarsMap = object;
            ArtifactCollection artifactCollection = testedProjectExplodedAars;
            if (artifactCollection != null) {
                ArtifactCollection artifactCollection2 = artifactCollection;
                boolean bl = false;
                boolean bl2 = false;
                ArtifactCollection it = artifactCollection2;
                boolean bl3 = false;
                projectExplodedAarsMap = MapsKt.plus((Map)projectExplodedAarsMap, Companion.asProjectKeyedMap(it, buildMapping));
            }
            Map map2 = Collections.unmodifiableMap(projectExplodedAarsMap);
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.unmodifiable\u2026p(projectExplodedAarsMap)");
            Map<ProjectKey, File> map3 = Collections.unmodifiableMap(this.asProjectKeyedMap(projectJars, buildMapping));
            Intrinsics.checkExpressionValueIsNotNull(map3, (String)"Collections.unmodifiable\u2026ctKeyedMap(buildMapping))");
            return new ExternalLintModelArtifactHandler(localJarCache2, mavenCoordinatesCache, map2, map3, null);
        }

        private final Map<ProjectKey, File> asProjectKeyedMap(ArtifactCollection $this$asProjectKeyedMap, ImmutableMap<String, String> buildMapping) {
            Set set = $this$asProjectKeyedMap.getArtifacts();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"artifacts");
            return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)((Function1)new Function1<ResolvedArtifactResult, Pair<? extends ProjectKey, ? extends File>>(buildMapping){
                final /* synthetic */ ImmutableMap $buildMapping;

                @NotNull
                public final Pair<ProjectKey, File> invoke(ResolvedArtifactResult artifact) {
                    ResolvedArtifactResult resolvedArtifactResult = artifact;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifact");
                    ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
                    ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
                    if (componentIdentifier == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
                    }
                    ProjectComponentIdentifier id = (ProjectComponentIdentifier)componentIdentifier;
                    String string = BuildMappingUtils.getBuildId(id, (ImmutableMap<String, String>)this.$buildMapping);
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String string2 = id.getProjectPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"id.projectPath");
                    return TuplesKt.to((Object)new ProjectKey(string, string2, LibraryUtils.getVariantName(artifact)), (Object)artifact.getFile());
                }
                {
                    this.$buildMapping = immutableMap;
                    super(1);
                }
            })));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

