/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.api.variant.FilterConfiguration;
import com.android.build.api.variant.impl.BuiltArtifactImpl;
import com.android.build.api.variant.impl.BuiltArtifactsImpl;
import com.android.build.api.variant.impl.BuiltArtifactsLoaderImpl;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.PackageForUnitTest$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.base.Joiner;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u00a2\u0006\u0002\b\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageForUnitTest;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "apkForUnitTest", "Lorg/gradle/api/file/RegularFileProperty;", "getApkForUnitTest", "()Lorg/gradle/api/file/RegularFileProperty;", "mergedAssets", "Lorg/gradle/api/file/DirectoryProperty;", "getMergedAssets", "()Lorg/gradle/api/file/DirectoryProperty;", "resApk", "getResApk", "apkFrom", "Ljava/io/File;", "compiledResourcesZip", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "apkFrom$gradle_core", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class PackageForUnitTest
extends NonIncrementalTask {
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getResApk();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract DirectoryProperty getMergedAssets();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getApkForUnitTest();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doTaskAction() throws IOException {
        Object object = this.getApkForUnitTest().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"apkForUnitTest.get()");
        File apkForUnitTest = ((RegularFile)object).getAsFile();
        FileUtils.copyFile((File)this.apkFrom$gradle_core((Provider<Directory>)((Provider)this.getResApk())), (File)apkForUnitTest);
        URI uri = URI.create("jar:" + apkForUnitTest.toURI());
        Closeable closeable = FileSystems.newFileSystem(uri, MapsKt.emptyMap());
        boolean bl = false;
        Throwable throwable = null;
        try {
            Directory mergedAsset;
            FileSystem apkFs = (FileSystem)closeable;
            boolean bl2 = false;
            Path apkAssetsPath = apkFs.getPath("/assets", new String[0]);
            Directory directory2 = mergedAsset = (Directory)this.getMergedAssets().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)directory2, (String)"mergedAsset");
            Path mergedAssetsPath = directory2.getAsFile().toPath();
            Path path = Files.walkFileTree(mergedAssetsPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(mergedAssetsPath, apkAssetsPath){
                final /* synthetic */ Path $mergedAssetsPath;
                final /* synthetic */ Path $apkAssetsPath;

                @NotNull
                public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes basicFileAttributes) throws IOException {
                    Path destPath;
                    Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                    Intrinsics.checkParameterIsNotNull((Object)basicFileAttributes, (String)"basicFileAttributes");
                    String relativePath = PathUtils.toSystemIndependentPath((Path)this.$mergedAssetsPath.relativize(path));
                    Path path2 = destPath = this.$apkAssetsPath.resolve(relativePath);
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"destPath");
                    Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                    Files.copy(path, destPath, new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
                {
                    this.$mergedAssetsPath = $captured_local_variable$0;
                    this.$apkAssetsPath = $captured_local_variable$1;
                }
            });
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final File apkFrom$gradle_core(@NotNull Provider<Directory> compiledResourcesZip) {
        Intrinsics.checkParameterIsNotNull(compiledResourcesZip, (String)"compiledResourcesZip");
        BuiltArtifactsImpl builtArtifactsImpl = new BuiltArtifactsLoaderImpl().load(compiledResourcesZip);
        if (builtArtifactsImpl == null) {
            throw (Throwable)new RuntimeException("Cannot load resources from " + compiledResourcesZip);
        }
        BuiltArtifactsImpl builtArtifacts = builtArtifactsImpl;
        if (builtArtifacts.getElements().size() == 1) {
            return new File(((BuiltArtifactImpl)CollectionsKt.first((Iterable)builtArtifacts.getElements())).getOutputFile());
        }
        Iterable $this$forEach$iv = builtArtifacts.getElements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuiltArtifactImpl builtArtifact = (BuiltArtifactImpl)element$iv;
            boolean bl = false;
            if (builtArtifact.getFilters().isEmpty()) {
                return new File(builtArtifact.getOutputFile());
            }
            if (builtArtifact.getFilters().size() != 1 || builtArtifact.getFilter(FilterConfiguration.FilterType.ABI) == null) continue;
            return new File(builtArtifact.getOutputFile());
        }
        if (builtArtifacts.getElements().isEmpty()) {
            throw (Throwable)new RuntimeException("No resources build output, please file a bug.");
        }
        StringBuilder sb = new StringBuilder("Found following build outputs : \n");
        Iterable $this$forEach$iv2 = builtArtifacts.getElements();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            BuiltArtifactImpl it = (BuiltArtifactImpl)element$iv;
            boolean bl = false;
            sb.append("BuildOutput: " + Joiner.on((char)',').join((Iterable)it.getFilters()) + '\n');
        }
        sb.append("Cannot find a build output with all resources, please file a bug.");
        throw (Throwable)new RuntimeException(sb.toString());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/PackageForUnitTest$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/PackageForUnitTest;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<PackageForUnitTest, ComponentCreationConfig> {
        @NotNull
        private final String name;
        @NotNull
        private final Class<PackageForUnitTest> type;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public Class<PackageForUnitTest> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<PackageForUnitTest> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)PackageForUnitTest$CreationAction$handleProvider$1.INSTANCE).withName("apk-for-local-test.ap_").on(InternalArtifactType.APK_FOR_LOCAL_TEST.INSTANCE);
        }

        @Override
        public void configure(@NotNull PackageForUnitTest task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            ArtifactsImpl artifacts2 = this.creationConfig.getArtifacts();
            artifacts2.setTaskInputToFinalProduct(InternalArtifactType.PROCESSED_RES.INSTANCE, (Property)task.getResApk());
            artifacts2.setTaskInputToFinalProduct(InternalArtifactType.MERGED_ASSETS.INSTANCE, (Property)task.getMergedAssets());
        }

        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super(creationConfig);
            this.name = this.computeTaskName("package", "ForUnitTest");
            this.type = PackageForUnitTest.class;
        }
    }
}

