/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"cmakeMakefileChecks", "", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "gradle-core"})
public final class CmakeExternalNativeJsonGeneratorUtilsKt {
    public static final void cmakeMakefileChecks(@NotNull CxxVariantModel variant) {
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        File cmakelists = variant.getModule().getMakeFile();
        if (cmakelists.isDirectory()) {
            LoggingEnvironmentKt.errorln("Gradle project cmake.path %s is a folder. It must be CMakeLists.txt", cmakelists);
        } else if (cmakelists.isFile()) {
            String filename = cmakelists.getName();
            if (Intrinsics.areEqual((Object)filename, (Object)"CMakeLists.txt") ^ true) {
                Object[] objectArray = new Object[1];
                String string = filename;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"filename");
                objectArray[0] = string;
                LoggingEnvironmentKt.errorln("Gradle project cmake.path specifies %s but it must be CMakeLists.txt", objectArray);
            }
        } else {
            LoggingEnvironmentKt.errorln("Gradle project cmake.path is %s but that file doesn't exist", cmakelists);
        }
    }
}

