/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.Version;
import com.android.build.gradle.internal.EmulatorComponents;
import com.android.build.gradle.internal.PlatformComponents;
import com.android.build.gradle.internal.PlatformToolsComponents;
import com.android.build.gradle.internal.SdkLocation;
import com.android.build.gradle.internal.SdkLocationSourceSet;
import com.android.build.gradle.internal.SdkLocator;
import com.android.build.gradle.internal.SdkParsingUtilsKt;
import com.android.build.gradle.internal.SdkType;
import com.android.build.gradle.internal.SupportToolsComponents;
import com.android.build.gradle.internal.SystemImageComponents;
import com.android.builder.core.ToolsRevisionUtils;
import com.android.builder.errors.IssueReporter;
import com.android.builder.internal.compiler.RenderScriptProcessor;
import com.android.repository.Revision;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.OptionalLibrary;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 72\u00020\u0001:\u000278B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0016J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016J\b\u0010\u001c\u001a\u0004\u0018\u00010\u0016J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0016J\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\b\u0010 \u001a\u0004\u0018\u00010\u0007J\b\u0010!\u001a\u0004\u0018\u00010\u0016J\b\u0010\"\u001a\u0004\u0018\u00010\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010\u00162\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018J\b\u0010'\u001a\u0004\u0018\u00010\u0016J\b\u0010(\u001a\u0004\u0018\u00010\u0016J\b\u0010)\u001a\u0004\u0018\u00010\u0016J\b\u0010*\u001a\u0004\u0018\u00010\u0016J\u0010\u0010+\u001a\u0004\u0018\u00010\u00162\u0006\u0010,\u001a\u00020\u0005J\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0018J\b\u0010.\u001a\u0004\u0018\u00010/J\n\u00100\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u00101\u001a\u0004\u0018\u00010\u000e2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u0007H\u0002J\u0006\u00104\u001a\u00020\tJ\u0006\u00105\u001a\u000206R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy;", "", "sdkLocationSourceSet", "Lcom/android/build/gradle/internal/SdkLocationSourceSet;", "platformTargetHashSupplier", "", "buildToolRevisionSupplier", "Lcom/android/repository/Revision;", "useAndroidX", "", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "(Lcom/android/build/gradle/internal/SdkLocationSourceSet;Ljava/lang/String;Lcom/android/repository/Revision;ZLcom/android/builder/errors/IssueReporter;)V", "components", "Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "getComponents", "()Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "components$delegate", "Lkotlin/Lazy;", "checkBuildToolsRevision", "revision", "getAdbExecutable", "Ljava/io/File;", "getAdditionalLibraries", "", "Lcom/android/sdklib/OptionalLibrary;", "getAidlExecutable", "getAidlFramework", "getAndroidJar", "getAnnotationsJar", "getBuildToolsInfo", "Lcom/android/sdklib/BuildToolInfo;", "getBuildToolsRevision", "getCoreLambaStubs", "getEmulatorLibFolder", "getFileFromBuildTool", "component", "Lcom/android/sdklib/BuildToolInfo$PathId;", "getOptionalLibraries", "getRenderScriptSupportJar", "getSplitSelectExecutable", "getSupportBlasLibFolder", "getSupportNativeLibFolder", "getSystemImageLibFolder", "imageHash", "getTargetBootClasspath", "getTargetPlatformVersion", "Lcom/android/sdklib/AndroidVersion;", "init", "loadSdkComponents", "targetHash", "buildToolRevision", "loadedSuccessfully", "reset", "", "Companion", "DirectLoadComponents", "gradle-core"})
public final class SdkDirectLoadingStrategy {
    private final Lazy components$delegate;
    private final SdkLocationSourceSet sdkLocationSourceSet;
    private final String platformTargetHashSupplier;
    private final Revision buildToolRevisionSupplier;
    private final boolean useAndroidX;
    private final IssueReporter issueReporter;
    private static final ConcurrentHashMap<Revision, Optional<BuildToolInfo>> buildToolsCache;
    private static final ConcurrentHashMap<String, Optional<PlatformComponents>> platformCache;
    private static final ConcurrentHashMap<String, Optional<SystemImageComponents>> systemImageCache;
    @NotNull
    public static final Companion Companion;

    private final DirectLoadComponents getComponents() {
        Lazy lazy = this.components$delegate;
        SdkDirectLoadingStrategy sdkDirectLoadingStrategy = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DirectLoadComponents)lazy.getValue();
    }

    private final synchronized DirectLoadComponents init() {
        String string = this.platformTargetHashSupplier;
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            boolean bl3 = false;
            String string2 = "Extension not initialized yet, couldn't access compileSdkVersion.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String targetHash = string;
        SdkDirectLoadingStrategy sdkDirectLoadingStrategy = this;
        Revision revision = this.buildToolRevisionSupplier;
        bl2 = false;
        boolean bl4 = false;
        if (revision == null) {
            SdkDirectLoadingStrategy sdkDirectLoadingStrategy2 = sdkDirectLoadingStrategy;
            boolean bl5 = false;
            String string3 = "Extension not initialized yet, couldn't access buildToolsVersion.";
            SdkDirectLoadingStrategy sdkDirectLoadingStrategy3 = sdkDirectLoadingStrategy2;
            String string4 = string3;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        Revision buildToolRevision = sdkDirectLoadingStrategy.checkBuildToolsRevision(revision);
        return this.loadSdkComponents(targetHash, buildToolRevision);
    }

    private final DirectLoadComponents loadSdkComponents(String targetHash, Revision buildToolRevision) {
        boolean bl;
        SdkLocation sdkLocation = SdkLocator.getSdkLocation(this.sdkLocationSourceSet, this.issueReporter);
        if (sdkLocation.getType() == SdkType.MISSING) {
            return null;
        }
        File file = sdkLocation.getDirectory();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        File sdkDirectory2 = file;
        PlatformToolsComponents platformTools = PlatformToolsComponents.Companion.build$gradle_core(sdkDirectory2);
        SupportToolsComponents supportTools = SupportToolsComponents.Companion.build$gradle_core(sdkDirectory2, targetHash);
        ConcurrentMap $this$getOrPut$iv = buildToolsCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(buildToolRevision);
        if (object == null) {
            boolean bl2 = false;
            Optional<BuildToolInfo> optional = Optional.ofNullable(SdkParsingUtilsKt.buildBuildTools(sdkDirectory2, buildToolRevision));
            boolean bl3 = false;
            bl = false;
            Optional<BuildToolInfo> default$iv = optional;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(buildToolRevision, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        BuildToolInfo buildTools = ((Optional)object).orElse(null);
        ConcurrentMap $this$getOrPut$iv2 = platformCache;
        boolean $i$f$getOrPut2 = false;
        Object object2 = $this$getOrPut$iv2.get(targetHash);
        if (object2 == null) {
            boolean bl5 = false;
            Optional<PlatformComponents> optional = Optional.ofNullable(PlatformComponents.Companion.build$gradle_core(sdkDirectory2, targetHash));
            bl = false;
            boolean bl6 = false;
            Optional<PlatformComponents> default$iv = optional;
            boolean bl7 = false;
            object2 = $this$getOrPut$iv2.putIfAbsent(targetHash, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        }
        PlatformComponents platform = ((Optional)object2).orElse(null);
        EmulatorComponents emulator = EmulatorComponents.Companion.build$gradle_core(sdkDirectory2);
        if (platformTools == null || supportTools == null || buildTools == null || platform == null) {
            return null;
        }
        return new DirectLoadComponents(sdkDirectory2, platformTools, supportTools, buildTools, platform, emulator);
    }

    private final Revision checkBuildToolsRevision(Revision revision) {
        if (revision.compareTo(ToolsRevisionUtils.MIN_BUILD_TOOLS_REV) < 0) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "The specified Android SDK Build Tools version (%1$s) is ignored, as it is below the minimum supported version (%2$s) for Android Gradle Plugin %3$s.\nAndroid SDK Build Tools %4$s will be used.\nTo suppress this warning, remove \"buildToolsVersion '%1$s'\" from your build.gradle file, as each version of the Android Gradle Plugin now has a default version of the build tools.";
            Object[] objectArray = new Object[]{revision, ToolsRevisionUtils.MIN_BUILD_TOOLS_REV, Version.ANDROID_GRADLE_PLUGIN_VERSION, ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            IssueReporter.reportWarning$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.BUILD_TOOLS_TOO_LOW, (String)string2, (String)ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION.toString(), null, (int)8, null);
            Revision revision2 = ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION;
            Intrinsics.checkExpressionValueIsNotNull((Object)revision2, (String)"ToolsRevisionUtils.DEFAULT_BUILD_TOOLS_REVISION");
            return revision2;
        }
        return revision;
    }

    public final boolean loadedSuccessfully() {
        return this.getComponents() != null;
    }

    @Nullable
    public final File getAdbExecutable() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatformTools$gradle_core()) != null ? ((PlatformToolsComponents)object).getAdbExecutable$gradle_core() : null;
    }

    @Nullable
    public final File getAnnotationsJar() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getSupportTools$gradle_core()) != null ? ((SupportToolsComponents)object).getAnnotationsJar$gradle_core() : null;
    }

    @Nullable
    public final File getAidlFramework() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getAidlFramework$gradle_core() : null;
    }

    @Nullable
    public final File getAndroidJar() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getAndroidJar$gradle_core() : null;
    }

    @Nullable
    public final List<OptionalLibrary> getAdditionalLibraries() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getAdditionalLibraries$gradle_core() : null;
    }

    @Nullable
    public final List<OptionalLibrary> getOptionalLibraries() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getOptionalLibraries$gradle_core() : null;
    }

    @Nullable
    public final AndroidVersion getTargetPlatformVersion() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getTargetPlatformVersion$gradle_core() : null;
    }

    @Nullable
    public final List<File> getTargetBootClasspath() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getPlatform$gradle_core()) != null ? ((PlatformComponents)object).getTargetBootClasspath$gradle_core() : null;
    }

    @Nullable
    public final BuildToolInfo getBuildToolsInfo() {
        DirectLoadComponents directLoadComponents = this.getComponents();
        return directLoadComponents != null ? directLoadComponents.getBuildToolInfo$gradle_core() : null;
    }

    @Nullable
    public final Revision getBuildToolsRevision() {
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        return buildToolInfo != null ? buildToolInfo.getRevision() : null;
    }

    private final File getFileFromBuildTool(BuildToolInfo.PathId component2) {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            file = new File(it.getPath(component2));
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getAidlExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.AIDL);
    }

    @Nullable
    public final File getCoreLambaStubs() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.CORE_LAMBDA_STUBS);
    }

    @Nullable
    public final File getSplitSelectExecutable() {
        return this.getFileFromBuildTool(BuildToolInfo.PathId.SPLIT_SELECT);
    }

    @Nullable
    public final File getRenderScriptSupportJar() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.location");
            file = RenderScriptProcessor.Companion.getSupportJar(file2, this.useAndroidX);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSupportNativeLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.location");
            file = RenderScriptProcessor.Companion.getSupportNativeLibFolder(file2);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSupportBlasLibFolder() {
        File file;
        BuildToolInfo buildToolInfo = this.getBuildToolsInfo();
        if (buildToolInfo != null) {
            BuildToolInfo buildToolInfo2 = buildToolInfo;
            boolean bl = false;
            boolean bl2 = false;
            BuildToolInfo it = buildToolInfo2;
            boolean bl3 = false;
            File file2 = it.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.location");
            file = RenderScriptProcessor.Companion.getSupportBlasLibFolder(file2);
        } else {
            file = null;
        }
        return file;
    }

    @Nullable
    public final File getSystemImageLibFolder(@NotNull String imageHash) {
        Intrinsics.checkParameterIsNotNull((Object)imageHash, (String)"imageHash");
        ConcurrentMap $this$getOrPut$iv = systemImageCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(imageHash);
        if (object == null) {
            boolean bl = false;
            DirectLoadComponents directLoadComponents = this.getComponents();
            Optional<SystemImageComponents> optional = Optional.ofNullable(SystemImageComponents.Companion.build$gradle_core(directLoadComponents != null ? directLoadComponents.getSdkDirectory$gradle_core() : null, imageHash));
            boolean bl2 = false;
            boolean bl3 = false;
            Optional<SystemImageComponents> default$iv = optional;
            boolean bl4 = false;
            object = $this$getOrPut$iv.putIfAbsent(imageHash, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        SystemImageComponents systemImageComponents = ((Optional)object).orElse(null);
        return systemImageComponents != null ? systemImageComponents.getSystemImageDir$gradle_core() : null;
    }

    @Nullable
    public final File getEmulatorLibFolder() {
        Object object = this.getComponents();
        return object != null && (object = ((DirectLoadComponents)object).getEmulator$gradle_core()) != null ? ((EmulatorComponents)object).getEmulatorDir$gradle_core() : null;
    }

    public final void reset() {
        Companion.clearCaches();
    }

    public SdkDirectLoadingStrategy(@NotNull SdkLocationSourceSet sdkLocationSourceSet, @Nullable String platformTargetHashSupplier, @Nullable Revision buildToolRevisionSupplier, boolean useAndroidX, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkParameterIsNotNull((Object)sdkLocationSourceSet, (String)"sdkLocationSourceSet");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter2, (String)"issueReporter");
        this.sdkLocationSourceSet = sdkLocationSourceSet;
        this.platformTargetHashSupplier = platformTargetHashSupplier;
        this.buildToolRevisionSupplier = buildToolRevisionSupplier;
        this.useAndroidX = useAndroidX;
        this.issueReporter = issueReporter2;
        this.components$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DirectLoadComponents>(this){
            final /* synthetic */ SdkDirectLoadingStrategy this$0;

            @Nullable
            public final DirectLoadComponents invoke() {
                return SdkDirectLoadingStrategy.access$init(this.this$0);
            }
            {
                this.this$0 = sdkDirectLoadingStrategy;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        buildToolsCache = new ConcurrentHashMap();
        platformCache = new ConcurrentHashMap();
        systemImageCache = new ConcurrentHashMap();
    }

    public static final /* synthetic */ DirectLoadComponents access$init(SdkDirectLoadingStrategy $this) {
        return $this.init();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$DirectLoadComponents;", "", "sdkDirectory", "Ljava/io/File;", "platformTools", "Lcom/android/build/gradle/internal/PlatformToolsComponents;", "supportTools", "Lcom/android/build/gradle/internal/SupportToolsComponents;", "buildToolInfo", "Lcom/android/sdklib/BuildToolInfo;", "platform", "Lcom/android/build/gradle/internal/PlatformComponents;", "emulator", "Lcom/android/build/gradle/internal/EmulatorComponents;", "(Ljava/io/File;Lcom/android/build/gradle/internal/PlatformToolsComponents;Lcom/android/build/gradle/internal/SupportToolsComponents;Lcom/android/sdklib/BuildToolInfo;Lcom/android/build/gradle/internal/PlatformComponents;Lcom/android/build/gradle/internal/EmulatorComponents;)V", "getBuildToolInfo$gradle_core", "()Lcom/android/sdklib/BuildToolInfo;", "getEmulator$gradle_core", "()Lcom/android/build/gradle/internal/EmulatorComponents;", "getPlatform$gradle_core", "()Lcom/android/build/gradle/internal/PlatformComponents;", "getPlatformTools$gradle_core", "()Lcom/android/build/gradle/internal/PlatformToolsComponents;", "getSdkDirectory$gradle_core", "()Ljava/io/File;", "getSupportTools$gradle_core", "()Lcom/android/build/gradle/internal/SupportToolsComponents;", "gradle-core"})
    private static final class DirectLoadComponents {
        @NotNull
        private final File sdkDirectory;
        @NotNull
        private final PlatformToolsComponents platformTools;
        @NotNull
        private final SupportToolsComponents supportTools;
        @NotNull
        private final BuildToolInfo buildToolInfo;
        @NotNull
        private final PlatformComponents platform;
        @Nullable
        private final EmulatorComponents emulator;

        @NotNull
        public final File getSdkDirectory$gradle_core() {
            return this.sdkDirectory;
        }

        @NotNull
        public final PlatformToolsComponents getPlatformTools$gradle_core() {
            return this.platformTools;
        }

        @NotNull
        public final SupportToolsComponents getSupportTools$gradle_core() {
            return this.supportTools;
        }

        @NotNull
        public final BuildToolInfo getBuildToolInfo$gradle_core() {
            return this.buildToolInfo;
        }

        @NotNull
        public final PlatformComponents getPlatform$gradle_core() {
            return this.platform;
        }

        @Nullable
        public final EmulatorComponents getEmulator$gradle_core() {
            return this.emulator;
        }

        public DirectLoadComponents(@NotNull File sdkDirectory2, @NotNull PlatformToolsComponents platformTools, @NotNull SupportToolsComponents supportTools, @NotNull BuildToolInfo buildToolInfo, @NotNull PlatformComponents platform, @Nullable EmulatorComponents emulator) {
            Intrinsics.checkParameterIsNotNull((Object)sdkDirectory2, (String)"sdkDirectory");
            Intrinsics.checkParameterIsNotNull((Object)platformTools, (String)"platformTools");
            Intrinsics.checkParameterIsNotNull((Object)supportTools, (String)"supportTools");
            Intrinsics.checkParameterIsNotNull((Object)buildToolInfo, (String)"buildToolInfo");
            Intrinsics.checkParameterIsNotNull((Object)platform, (String)"platform");
            this.sdkDirectory = sdkDirectory2;
            this.platformTools = platformTools;
            this.supportTools = supportTools;
            this.buildToolInfo = buildToolInfo;
            this.platform = platform;
            this.emulator = emulator;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/SdkDirectLoadingStrategy$Companion;", "", "()V", "buildToolsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/android/repository/Revision;", "Ljava/util/Optional;", "Lcom/android/sdklib/BuildToolInfo;", "platformCache", "", "Lcom/android/build/gradle/internal/PlatformComponents;", "systemImageCache", "Lcom/android/build/gradle/internal/SystemImageComponents;", "clearCaches", "", "gradle-core"})
    public static final class Companion {
        @VisibleForTesting
        public final synchronized void clearCaches() {
            buildToolsCache.clear();
            platformCache.clear();
            systemImageCache.clear();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

