/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.process;

import com.android.build.gradle.internal.cxx.process.ChunkBytesToLineOutputStream;
import com.android.build.gradle.internal.cxx.process.DefaultProcessOutput;
import com.android.build.gradle.internal.cxx.process.DefaultProcessOutputHandler;
import com.android.build.gradle.internal.cxx.process.MultiplexingOutputStream;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/cxx/process/DefaultProcessOutputHandler;", "Lcom/android/ide/common/process/ProcessOutputHandler;", "stderrFile", "Ljava/io/File;", "stdoutFile", "logPrefix", "", "logErrorToLifecycle", "", "logOutputToInfo", "(Ljava/io/File;Ljava/io/File;Ljava/lang/String;ZZ)V", "stderr", "Ljava/io/FileOutputStream;", "getStderr", "()Ljava/io/FileOutputStream;", "setStderr", "(Ljava/io/FileOutputStream;)V", "stdout", "getStdout", "setStdout", "createOutput", "Lcom/android/ide/common/process/ProcessOutput;", "handleOutput", "", "processOutput", "gradle-core"})
public final class DefaultProcessOutputHandler
implements ProcessOutputHandler {
    @Nullable
    private FileOutputStream stderr;
    @Nullable
    private FileOutputStream stdout;
    private final File stderrFile;
    private final File stdoutFile;
    private final String logPrefix;
    private final boolean logErrorToLifecycle;
    private final boolean logOutputToInfo;

    @Nullable
    public final FileOutputStream getStderr() {
        return this.stderr;
    }

    public final void setStderr(@Nullable FileOutputStream fileOutputStream) {
        this.stderr = fileOutputStream;
    }

    @Nullable
    public final FileOutputStream getStdout() {
        return this.stdout;
    }

    public final void setStdout(@Nullable FileOutputStream fileOutputStream) {
        this.stdout = fileOutputStream;
    }

    @NotNull
    public ProcessOutput createOutput() {
        FileOutputStream singleStderr = new FileOutputStream(this.stderrFile, true);
        FileOutputStream singleStdout = new FileOutputStream(this.stdoutFile, true);
        List stderrReceivers = CollectionsKt.mutableListOf((Object[])new OutputStream[]{singleStderr});
        List stdoutReceivers = CollectionsKt.mutableListOf((Object[])new OutputStream[]{singleStdout});
        if (this.logErrorToLifecycle) {
            stderrReceivers.add(new ChunkBytesToLineOutputStream(this.logPrefix, createOutput.1.INSTANCE, 0, 4, null));
        }
        if (this.logOutputToInfo) {
            stdoutReceivers.add(new ChunkBytesToLineOutputStream(this.logPrefix, createOutput.2.INSTANCE, 0, 4, null));
        }
        return new DefaultProcessOutput(singleStderr, singleStdout, new MultiplexingOutputStream(stdoutReceivers), new MultiplexingOutputStream(stderrReceivers));
    }

    public void handleOutput(@NotNull ProcessOutput processOutput) {
        Intrinsics.checkParameterIsNotNull((Object)processOutput, (String)"processOutput");
        if (this.stdout != null) {
            throw (Throwable)new RuntimeException("Multiple calls");
        }
        DefaultProcessOutput output2 = (DefaultProcessOutput)processOutput;
        this.stderr = output2.getStderr();
        this.stdout = output2.getStdout();
    }

    public DefaultProcessOutputHandler(@NotNull File stderrFile, @NotNull File stdoutFile, @NotNull String logPrefix, boolean logErrorToLifecycle, boolean logOutputToInfo) {
        Intrinsics.checkParameterIsNotNull((Object)stderrFile, (String)"stderrFile");
        Intrinsics.checkParameterIsNotNull((Object)stdoutFile, (String)"stdoutFile");
        Intrinsics.checkParameterIsNotNull((Object)logPrefix, (String)"logPrefix");
        this.stderrFile = stderrFile;
        this.stdoutFile = stdoutFile;
        this.logPrefix = logPrefix;
        this.logErrorToLifecycle = logErrorToLifecycle;
        this.logOutputToInfo = logOutputToInfo;
    }
}

