/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.settings;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrefixingLoggingEnvironment;
import com.android.build.gradle.internal.cxx.settings.BuildSettingsConfiguration;
import com.android.build.gradle.internal.cxx.settings.EnvironmentVariable;
import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b*\u00020\u0001\u00a8\u0006\t"}, d2={"createBuildSettingsFromFile", "Lcom/android/build/gradle/internal/cxx/settings/BuildSettingsConfiguration;", "jsonFile", "Ljava/io/File;", "createBuildSettingsFromJson", "json", "", "getEnvironmentVariableMap", "", "gradle-core"})
public final class BuildSettingsFactoryKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BuildSettingsConfiguration createBuildSettingsFromJson(@NotNull String json) {
        BuildSettingsConfiguration buildSettingsConfiguration;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        try {
            BuildSettingsConfiguration buildSettingsConfiguration2;
            BuildSettingsConfiguration settings2 = (BuildSettingsConfiguration)new Gson().fromJson(json, BuildSettingsConfiguration.class);
            if (settings2 != null) {
                List list;
                List list2 = settings2.getEnvironmentVariables();
                if (list2 != null && (list2 = CollectionsKt.filterNotNull((Iterable)list2)) != null) {
                    List list3;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = list2;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        EnvironmentVariable it = (EnvironmentVariable)element$iv$iv;
                        boolean bl = false;
                        CharSequence charSequence = it.getName();
                        boolean bl2 = false;
                        boolean bl3 = false;
                        if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = list3 = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List list4 = list;
                buildSettingsConfiguration2 = new BuildSettingsConfiguration(list4);
            } else {
                LoggingEnvironmentKt.errorln("Json is empty", new Object[0]);
                buildSettingsConfiguration2 = new BuildSettingsConfiguration(null, 1, null);
            }
            buildSettingsConfiguration = buildSettingsConfiguration2;
        }
        catch (Throwable e) {
            String string;
            String string2 = e.getMessage();
            if (string2 == null) {
                Throwable throwable = e.getCause();
                string2 = string = throwable != null ? throwable.getMessage() : null;
            }
            if (string2 == null) {
                string = e.getClass().getName();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.message ?: e.cause?.message ?: e.javaClass.name");
            LoggingEnvironmentKt.errorln(string, new Object[0]);
            buildSettingsConfiguration = new BuildSettingsConfiguration(null, 1, null);
        }
        return buildSettingsConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final BuildSettingsConfiguration createBuildSettingsFromFile(@NotNull File jsonFile) {
        Intrinsics.checkParameterIsNotNull((Object)jsonFile, (String)"jsonFile");
        if (jsonFile.exists()) {
            AutoCloseable autoCloseable = new PassThroughPrefixingLoggingEnvironment(jsonFile, null, false, 6, null);
            boolean bl = false;
            Throwable throwable = null;
            try {
                PassThroughPrefixingLoggingEnvironment it = (PassThroughPrefixingLoggingEnvironment)autoCloseable;
                boolean bl2 = false;
                BuildSettingsConfiguration buildSettingsConfiguration = BuildSettingsFactoryKt.createBuildSettingsFromJson(FilesKt.readText$default((File)jsonFile, null, (int)1, null));
                return buildSettingsConfiguration;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return new BuildSettingsConfiguration(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> getEnvironmentVariableMap(@NotNull BuildSettingsConfiguration $this$getEnvironmentVariableMap) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$getEnvironmentVariableMap, (String)"$this$getEnvironmentVariableMap");
        Iterable $this$associateBy$iv = $this$getEnvironmentVariableMap.getEnvironmentVariables();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            EnvironmentVariable it;
            EnvironmentVariable environmentVariable = (EnvironmentVariable)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            it = (EnvironmentVariable)element$iv$iv;
            boolean bl2 = false;
            String string2 = it.getValue();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = string2;
            map2.put(string, string3);
        }
        return destination$iv$iv;
    }
}

