/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001aH\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000e2 \u0010\u000f\u001a\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0011\u0012\u0004\u0012\u00020\n0\u0010H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0005\u001a\n \u0002*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LINE_SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "pattern", "Ljava/util/regex/Pattern;", "pattern2", "checkForData", "", "message", "processDependencyThrowable", "", "throwable", "", "dataExtractor", "Lkotlin/Function1;", "resultConsumer", "Lkotlin/Function2;", "", "gradle-core"})
public final class DependencyFailureHandlerKt {
    private static final Pattern pattern = Pattern.compile(".*any matches for (\\S*) .*", 32);
    private static final Pattern pattern2 = Pattern.compile(".*Could not find (\\S*)\\..*", 32);
    private static final Splitter LINE_SPLITTER = Splitter.on((String)System.lineSeparator());

    private static final void processDependencyThrowable(Throwable throwable, Function1<? super String, String> dataExtractor, Function2<? super String, ? super List<String>, Unit> resultConsumer) {
        boolean bl = false;
        List messages = new ArrayList();
        String firstIndent = " > ";
        String allIndent = "";
        String data = null;
        for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
            String message = cause.getMessage();
            if (message == null) continue;
            ImmutableList lines = ImmutableList.copyOf((Iterable)LINE_SPLITTER.split((CharSequence)message));
            Object object = lines.get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"lines[0]");
            data = (String)dataExtractor.invoke(object);
            if (data != null) break;
            int count = lines.size();
            for (int i2 = 0; i2 < count; ++i2) {
                String line = (String)lines.get(i2);
                CharSequence charSequence = allIndent;
                boolean bl2 = false;
                if (charSequence.length() == 0) {
                    String string = line;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"line");
                    messages.add(string);
                    continue;
                }
                if (i2 == 0) {
                    messages.add(firstIndent + line);
                    continue;
                }
                messages.add(allIndent + line);
            }
            firstIndent = allIndent + firstIndent;
            allIndent = allIndent + "   ";
        }
        resultConsumer.invoke((Object)data, (Object)messages);
    }

    @Nullable
    public static final String checkForData(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Matcher m = pattern.matcher(message);
        if (m.matches()) {
            return m.group(1);
        }
        m = pattern2.matcher(message);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static final /* synthetic */ void access$processDependencyThrowable(Throwable throwable, Function1 dataExtractor, Function2 resultConsumer) {
        DependencyFailureHandlerKt.processDependencyThrowable(throwable, (Function1<? super String, String>)dataExtractor, (Function2<? super String, ? super List<String>, Unit>)resultConsumer);
    }
}

