/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dsl.NdkOptions;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataRunnable;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataTask;
import com.android.build.gradle.internal.tasks.ExtractNativeDebugMetadataWorkAction$WhenMappings;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction$Parameters;", "()V", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getLogger", "()Lcom/android/build/gradle/internal/LoggerWrapper;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "run", "", "Parameters", "gradle-core"})
public abstract class ExtractNativeDebugMetadataWorkAction
extends ProfileAwareWorkAction<Parameters> {
    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    private final LoggerWrapper getLogger() {
        return new LoggerWrapper(Logging.getLogger(ExtractNativeDebugMetadataTask.class));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        void $this$groupByTo$iv$iv;
        Iterable objcopyArgs;
        File outputDir = (File)((Parameters)this.getParameters()).getOutputDir().getAsFile().get();
        FileUtils.cleanOutputDir((File)outputDir);
        boolean bl = false;
        List allRequests = new ArrayList();
        Iterator iterator = FileUtils.getAllFiles((File)((File)((Parameters)this.getParameters()).getInputDir().getAsFile().get())).iterator();
        while (iterator.hasNext()) {
            File inputFile;
            File file = inputFile = (File)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"inputFile");
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inputFile.name");
            if (!StringsKt.endsWith((String)string, (String)".so", (boolean)true)) continue;
            File outputFile = null;
            objcopyArgs = null;
            NdkOptions.DebugSymbolLevel debugSymbolLevel = (NdkOptions.DebugSymbolLevel)((Object)((Parameters)this.getParameters()).getDebugSymbolLevel().get());
            if (debugSymbolLevel == null) throw new NoWhenBranchMatchedException();
            switch (ExtractNativeDebugMetadataWorkAction$WhenMappings.$EnumSwitchMapping$0[debugSymbolLevel.ordinal()]) {
                case 1: {
                    StringBuilder stringBuilder = new StringBuilder();
                    File file2 = inputFile.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"inputFile.parentFile");
                    outputFile = new File(outputDir, stringBuilder.append(file2.getName()).append('/').append(inputFile.getName()).append(".dbg").toString());
                    objcopyArgs = CollectionsKt.listOf((Object)"--only-keep-debug");
                    break;
                }
                case 2: {
                    StringBuilder stringBuilder = new StringBuilder();
                    File file3 = inputFile.getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"inputFile.parentFile");
                    outputFile = new File(outputDir, stringBuilder.append(file3.getName()).append('/').append(inputFile.getName()).append(".sym").toString());
                    objcopyArgs = CollectionsKt.listOf((Object)"--strip-debug");
                    break;
                }
                case 3: {
                    throw (Throwable)new RuntimeException("NativeDebugMetadataMode.NONE not supported in " + this.getClass().getName());
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Map map2 = (Map)((Parameters)this.getParameters()).getObjcopyExecutableMap().get();
            File file4 = inputFile.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"inputFile.parentFile");
            File objcopyExecutable = (File)map2.get((Object)Abi.getByName(file4.getName()));
            if (objcopyExecutable == null) {
                LoggerWrapper loggerWrapper = this.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("Unable to extract native debug metadata from ").append(inputFile.getAbsolutePath()).append(' ').append("because unable to locate the objcopy executable for the ");
                File file5 = inputFile.getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"inputFile.parentFile");
                loggerWrapper.warning(stringBuilder.append(file5.getName()).append(" ABI.").toString(), new Object[0]);
                continue;
            }
            allRequests.add(new ExtractNativeDebugMetadataRunnable.SingleRequest(inputFile, outputFile, objcopyExecutable, (List<String>)objcopyArgs));
        }
        int ord = 0;
        Iterable $this$groupBy$iv = allRequests;
        boolean $i$f$groupBy = false;
        objcopyArgs = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ExtractNativeDebugMetadataRunnable.SingleRequest it = (ExtractNativeDebugMetadataRunnable.SingleRequest)element$iv$iv;
            boolean bl2 = false;
            int n = ord;
            ord = n + 1;
            Object object2 = ((Parameters)this.getParameters()).getMaxWorkerCount().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parameters.maxWorkerCount.get()");
            Integer key$iv$iv = n % ((Number)object2).intValue();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List requests = (List)element$iv;
            boolean bl4 = false;
            Collection collection = requests;
            boolean bl5 = false;
            if (!(!collection.isEmpty())) continue;
            this.getWorkerExecutor().noIsolation().submit(ExtractNativeDebugMetadataRunnable.class, (Action)new Action<ExtractNativeDebugMetadataRunnable.Params>(requests, this){
                final /* synthetic */ List $requests;
                final /* synthetic */ ExtractNativeDebugMetadataWorkAction this$0;
                {
                    this.$requests = list;
                    this.this$0 = extractNativeDebugMetadataWorkAction;
                }

                public final void execute(ExtractNativeDebugMetadataRunnable.Params it) {
                    Parameters parameters = (Parameters)this.this$0.getParameters();
                    Intrinsics.checkExpressionValueIsNotNull((Object)parameters, (String)"parameters");
                    it.initializeFromProfileAwareWorkAction(parameters);
                    it.getRequests().set((Iterable)this.$requests);
                }
            });
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u001e\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/ExtractNativeDebugMetadataWorkAction$Parameters;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "debugSymbolLevel", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/dsl/NdkOptions$DebugSymbolLevel;", "getDebugSymbolLevel", "()Lorg/gradle/api/provider/Property;", "inputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "maxWorkerCount", "", "getMaxWorkerCount", "objcopyExecutableMap", "Lorg/gradle/api/provider/MapProperty;", "Lcom/android/build/gradle/internal/core/Abi;", "Ljava/io/File;", "getObjcopyExecutableMap", "()Lorg/gradle/api/provider/MapProperty;", "outputDir", "getOutputDir", "gradle-core"})
    public static abstract class Parameters
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract DirectoryProperty getInputDir();

        @NotNull
        public abstract DirectoryProperty getOutputDir();

        @NotNull
        public abstract MapProperty<Abi, File> getObjcopyExecutableMap();

        @NotNull
        public abstract Property<NdkOptions.DebugSymbolLevel> getDebugSymbolLevel();

        @NotNull
        public abstract Property<Integer> getMaxWorkerCount();
    }
}

