/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.GenerateLibraryProguardRulesTask;
import com.android.build.gradle.internal.tasks.GenerateLibraryProguardRulesTaskKt$WhenMappings;
import com.android.builder.files.SerializableChange;
import com.android.ide.common.resources.FileStatus;
import com.android.ide.common.symbols.SymbolUtils;
import com.android.ide.common.xml.ManifestData;
import com.android.resources.ResourceFolderType;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\f"}, d2={"canResourcesBeProcessedIncrementally", "", "resourceChanges", "Lcom/android/builder/files/SerializableChange;", "isLayoutFile", "file", "Ljava/io/File;", "runFullTask", "", "params", "Lcom/android/build/gradle/internal/tasks/GenerateLibraryProguardRulesTask$GenerateProguardRulesWorkAction$Params;", "runIncrementalTask", "gradle-core"})
public final class GenerateLibraryProguardRulesTaskKt {
    public static final boolean canResourcesBeProcessedIncrementally(@NotNull SerializableChange resourceChanges) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)resourceChanges, (String)"resourceChanges");
        switch (GenerateLibraryProguardRulesTaskKt$WhenMappings.$EnumSwitchMapping$0[resourceChanges.getFileStatus().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                if (!GenerateLibraryProguardRulesTaskKt.isLayoutFile(resourceChanges.getFile())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (!GenerateLibraryProguardRulesTaskKt.isLayoutFile(resourceChanges.getFile())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final void runFullTask(@NotNull GenerateLibraryProguardRulesTask.GenerateProguardRulesWorkAction.Params params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        Object object = params.getProguardOutputFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"params.proguardOutputFile.get()");
        Path path = ((RegularFile)object).getAsFile().toPath();
        Object object2 = params.getManifestFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"params.manifestFile.get()");
        File file = ((RegularFile)object2).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"params.manifestFile.get().asFile");
        ManifestData manifestData2 = SymbolUtils.parseManifest((File)file);
        Object object3 = params.getInputResourcesDir().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"params.inputResourcesDir.get()");
        Files.write(path, (Iterable<? extends CharSequence>)SymbolUtils.generateMinifyKeepRules((ManifestData)manifestData2, (File)((Directory)object3).getAsFile()), new OpenOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static final void runIncrementalTask(@NotNull GenerateLibraryProguardRulesTask.GenerateProguardRulesWorkAction.Params params) {
        void $this$mapTo$iv$iv;
        SerializableChange it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        Object object = params.getProguardOutputFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"params.proguardOutputFile.get()");
        if (!((RegularFile)object).getAsFile().exists()) {
            Logger logger = Logging.getLogger(GenerateLibraryProguardRulesTask.class);
            StringBuilder stringBuilder = new StringBuilder().append("Cannot find file: ");
            Object object2 = params.getProguardOutputFile().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"params.proguardOutputFile.get()");
            File file = ((RegularFile)object2).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"params.proguardOutputFile.get().asFile");
            logger.warn(stringBuilder.append(file.getPath()).toString());
            GenerateLibraryProguardRulesTaskKt.runFullTask(params);
            return;
        }
        Object object3 = params.getChangedResources().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"params.changedResources.get()");
        Iterable $this$filter$iv = (Iterable)object3;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SerializableChange)element$iv$iv;
            boolean bl = false;
            if (!(GenerateLibraryProguardRulesTaskKt.isLayoutFile(it.getFile()) && it.getFileStatus() == FileStatus.NEW)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SerializableChange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = it.getFile();
            collection.add(file);
        }
        List addedLayoutFiles = (List)destination$iv$iv;
        if (CollectionsKt.none((Iterable)addedLayoutFiles)) {
            return;
        }
        Object object4 = params.getProguardOutputFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"params.proguardOutputFile.get()");
        File file = ((RegularFile)object4).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"params.proguardOutputFile.get().asFile");
        SortedSet currentKeepRules = SymbolUtils.parseMinifiedKeepRules((File)file);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Iterable $this$forEach$iv = addedLayoutFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File addedLayoutFile = (File)element$iv;
            boolean bl = false;
            DocumentBuilder documentBuilder2 = documentBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)documentBuilder2, (String)"documentBuilder");
            SymbolUtils.generateKeepRulesFromLayoutXmlFile((File)addedLayoutFile, (DocumentBuilder)documentBuilder2, (SortedSet)currentKeepRules);
        }
        String string = "# Generated by the gradle plugin\n" + CollectionsKt.joinToString$default((Iterable)currentKeepRules, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] contentsToWrite = byArray;
        Object object5 = params.getProguardOutputFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"params.proguardOutputFile.get()");
        Files.write(((RegularFile)object5).getAsFile().toPath(), contentsToWrite, new OpenOption[0]);
    }

    private static final boolean isLayoutFile(File file) {
        File file2 = file.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file.parentFile");
        return ResourceFolderType.getFolderType((String)file2.getName()) == ResourceFolderType.LAYOUT;
    }
}

