/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.signing.SigningConfigVersions;
import com.android.build.gradle.internal.tasks.SigningConfigUtils;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigUtils;", "", "()V", "Companion", "gradle-core"})
public final class SigningConfigUtils {
    private static final Lazy gson$delegate;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        gson$delegate = LazyKt.lazy((Function0)Companion.gson.2.INSTANCE);
    }

    @JvmStatic
    @NotNull
    public static final SigningConfigVersions loadSigningConfigVersions(@NotNull File input) {
        return Companion.loadSigningConfigVersions(input);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\nJ\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000eR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/android/build/gradle/internal/tasks/SigningConfigUtils$Companion;", "", "()V", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "Lkotlin/Lazy;", "loadSigningConfigData", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "input", "Ljava/io/File;", "loadSigningConfigVersions", "Lcom/android/build/gradle/internal/signing/SigningConfigVersions;", "saveSigningConfigData", "", "outputFile", "signingConfigData", "saveSigningConfigVersions", "signingConfigVersions", "gradle-core"})
    public static final class Companion {
        public final void saveSigningConfigData(@NotNull File outputFile, @Nullable SigningConfigData signingConfigData) {
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            outputFile.createNewFile();
            if (SdkConstants.CURRENT_PLATFORM != 2) {
                HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
                perms.add(PosixFilePermission.OWNER_READ);
                perms.add(PosixFilePermission.OWNER_WRITE);
                Files.setPosixFilePermissions(outputFile.toPath(), (Set<PosixFilePermission>)perms);
            } else {
                AclFileAttributeView view = Files.getFileAttributeView(outputFile.toPath(), AclFileAttributeView.class, new LinkOption[0]);
                AclEntry.Builder builder = AclEntry.newBuilder().setType(AclEntryType.ALLOW);
                AclFileAttributeView aclFileAttributeView = view;
                Intrinsics.checkExpressionValueIsNotNull((Object)aclFileAttributeView, (String)"view");
                AclEntry entry = builder.setPrincipal(aclFileAttributeView.getOwner()).setPermissions(AclEntryPermission.READ_ACL, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.READ_DATA, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.WRITE_ACL, AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_OWNER, AclEntryPermission.SYNCHRONIZE, AclEntryPermission.DELETE).build();
                view.setAcl(CollectionsKt.listOf((Object)entry));
            }
            FileUtils.write((File)outputFile, (CharSequence)this.getGson().toJson((Object)signingConfigData), (Charset)StandardCharsets.UTF_8);
        }

        public final void saveSigningConfigVersions(@NotNull File outputFile, @NotNull SigningConfigVersions signingConfigVersions) {
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            Intrinsics.checkParameterIsNotNull((Object)signingConfigVersions, (String)"signingConfigVersions");
            FileUtils.write((File)outputFile, (CharSequence)this.getGson().toJson((Object)signingConfigVersions), (Charset)StandardCharsets.UTF_8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final SigningConfigData loadSigningConfigData(@NotNull File input) {
            SigningConfigData signingConfigData;
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Object object = input;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            int n = 8192;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileInputStream((File)object3);
            bl3 = false;
            object2 = new InputStreamReader((InputStream)object3, charset2);
            bl2 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl5 = false;
                signingConfigData = (SigningConfigData)Companion.getGson().fromJson((Reader)reader, SigningConfigData.class);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return signingConfigData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final SigningConfigVersions loadSigningConfigVersions(@NotNull File input) {
            SigningConfigVersions signingConfigVersions;
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Object object = input;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            int n = 8192;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            Object object3 = object2;
            boolean bl3 = false;
            object3 = new FileInputStream((File)object3);
            bl3 = false;
            object2 = new InputStreamReader((InputStream)object3, charset2);
            bl2 = false;
            object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl5 = false;
                SigningConfigVersions signingConfigVersions2 = (SigningConfigVersions)Companion.getGson().fromJson((Reader)reader, SigningConfigVersions.class);
                signingConfigVersions = signingConfigVersions2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)signingConfigVersions, (String)"input.bufferedReader(Sta\u2026class.java)\n            }");
            return signingConfigVersions;
        }

        private final Gson getGson() {
            Lazy lazy = gson$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Gson)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

