/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.res.shrinker.LoggerAndFileDebugReporter;
import com.android.build.gradle.internal.res.shrinker.ResourceShrinkerImpl;
import com.android.build.gradle.internal.res.shrinker.ShrinkerDebugReporter;
import com.android.build.gradle.internal.res.shrinker.gatherer.ProtoResourceTableGatherer;
import com.android.build.gradle.internal.res.shrinker.graph.ProtoResourcesGraphBuilder;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ObfuscationMappingsRecorder;
import com.android.build.gradle.internal.res.shrinker.obfuscation.ProguardMappingsRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.DexUsageRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ProtoAndroidManifestUsageRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ResourceUsageRecorder;
import com.android.build.gradle.internal.res.shrinker.usages.ToolsAttributeUsageRecorder;
import com.android.build.gradle.internal.transforms.ResourceShrinkerParams;
import com.android.build.gradle.internal.transforms.ShrinkAppBundleResourcesTask;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\b\"\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR#\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR#\u0010\u000e\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000f\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkAppBundleResourcesAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/transforms/ResourceShrinkerParams;", "()V", "originalBundleFile", "Ljava/io/File;", "kotlin.jvm.PlatformType", "getOriginalBundleFile", "()Ljava/io/File;", "originalBundleFile$delegate", "Lkotlin/Lazy;", "reportFile", "getReportFile", "reportFile$delegate", "shrunkBundleFile", "getShrunkBundleFile", "shrunkBundleFile$delegate", "execute", "", "Companion", "gradle-core"})
abstract class ShrinkAppBundleResourcesAction
implements WorkAction<ResourceShrinkerParams> {
    private final Lazy originalBundleFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ ShrinkAppBundleResourcesAction this$0;

        public final File invoke() {
            Object object = ((ResourceShrinkerParams)this.this$0.getParameters()).getOriginalBundle().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.originalBundle.get()");
            return ((RegularFile)object).getAsFile();
        }
        {
            this.this$0 = shrinkAppBundleResourcesAction;
            super(0);
        }
    }));
    private final Lazy shrunkBundleFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ ShrinkAppBundleResourcesAction this$0;

        public final File invoke() {
            Object object = ((ResourceShrinkerParams)this.this$0.getParameters()).getShrunkBundle().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.shrunkBundle.get()");
            return ((RegularFile)object).getAsFile();
        }
        {
            this.this$0 = shrinkAppBundleResourcesAction;
            super(0);
        }
    }));
    private final Lazy reportFile$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
        final /* synthetic */ ShrinkAppBundleResourcesAction this$0;

        public final File invoke() {
            Object object = ((ResourceShrinkerParams)this.this$0.getParameters()).getReport().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.report.get()");
            return ((RegularFile)object).getAsFile();
        }
        {
            this.this$0 = shrinkAppBundleResourcesAction;
            super(0);
        }
    }));
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() {
        Logger logger = Logging.getLogger(ShrinkAppBundleResourcesTask.class);
        Map allModules = (Map)((ResourceShrinkerParams)this.getParameters()).getModules().get();
        Closeable closeable = FileUtils.createZipFilesystem((Path)this.getOriginalBundleFile().toPath());
        boolean bl = false;
        Throwable throwable = null;
        try {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            ProguardMappingsRecorder proguardMappingsRecorder;
            Object object;
            Collection collection;
            Object object2;
            void $this$mapTo$iv$iv22;
            FileSystem fs = (FileSystem)closeable;
            boolean bl2 = false;
            Path proguardMappings = fs.getPath("BUNDLE-METADATA", "com.android.tools.build.obfuscation", "proguard.map");
            Map map2 = allModules;
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"allModules");
            Map $this$map$iv = map2;
            boolean $i$f$map22 = false;
            Map map3 = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            void var14_23 = $this$mapTo$iv$iv22;
            boolean bl3 = false;
            for (Map.Entry item$iv$iv : var14_23.entrySet()) {
                void it;
                object2 = item$iv$iv;
                collection = destination$iv$iv22;
                boolean bl4 = false;
                Path path = fs.getPath((String)it.getKey(), "resources.pb");
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"fs.getPath(it.key, \"resources.pb\")");
                object = new ProtoResourceTableGatherer(path);
                collection.add(object);
            }
            List resourcesGatherers = (List)destination$iv$iv22;
            Path $i$f$map22 = proguardMappings;
            boolean $this$mapTo$iv$iv22 = false;
            boolean destination$iv$iv22 = false;
            Object it = $i$f$map22;
            boolean bl5 = false;
            Path path = Files.isRegularFile((Path)it, new LinkOption[0]) ? $i$f$map22 : null;
            if (path != null) {
                $i$f$map22 = path;
                $this$mapTo$iv$iv22 = false;
                destination$iv$iv22 = false;
                it = $i$f$map22;
                boolean bl6 = false;
                proguardMappingsRecorder = new ProguardMappingsRecorder((Path)it);
            } else {
                proguardMappingsRecorder = null;
            }
            ProguardMappingsRecorder obfuscationMappingsRecorder = proguardMappingsRecorder;
            Map $this$flatMap$iv = allModules;
            boolean $i$f$flatMap = false;
            it = $this$flatMap$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv;
            boolean bl7 = false;
            object2 = iterator.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it2 = element$iv$iv = (Map.Entry)object2.next();
                boolean bl8 = false;
                Path dexPath = fs.getPath((String)it2.getKey(), "dex");
                Path rawResourcesPath = fs.getPath((String)it2.getKey(), "res", "raw");
                Path manifest = fs.getPath((String)it2.getKey(), "manifest", "AndroidManifest.xml");
                Object[] objectArray = new ResourceUsageRecorder[3];
                Path path2 = dexPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"dexPath");
                ResourceUsageRecorder resourceUsageRecorder = new DexUsageRecorder(path2);
                boolean bl9 = false;
                boolean bl10 = false;
                DexUsageRecorder dexUsageRecorder = resourceUsageRecorder;
                int n = 0;
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = objectArray;
                boolean bl11 = false;
                boolean bl12 = Files.isDirectory(dexPath, new LinkOption[0]);
                objectArray2[n] = bl12 ? resourceUsageRecorder : null;
                Path path3 = fs.getPath((String)it2.getKey(), "res", "raw");
                Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"fs.getPath(it.key, \"res\", \"raw\")");
                resourceUsageRecorder = new ToolsAttributeUsageRecorder(path3);
                bl9 = false;
                bl10 = false;
                ResourceUsageRecorder it3 = resourceUsageRecorder;
                n = 1;
                objectArray2 = objectArray3;
                boolean bl13 = false;
                bl12 = Files.isDirectory(rawResourcesPath, new LinkOption[0]);
                objectArray2[n] = bl12 ? resourceUsageRecorder : null;
                Path path4 = manifest;
                Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"manifest");
                objectArray3[2] = new ProtoAndroidManifestUsageRecorder(path4);
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray3);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List usageRecorders = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
            Map $this$map$iv2 = allModules;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            void var17_34 = $this$mapTo$iv$iv;
            boolean bl14 = false;
            Iterator iterator2 = var17_34.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it4;
                Map.Entry item$iv$iv;
                Map.Entry bl8 = item$iv$iv = iterator2.next();
                collection = destination$iv$iv3;
                boolean bl15 = false;
                Path path5 = fs.getPath((String)it4.getKey(), "res");
                Intrinsics.checkExpressionValueIsNotNull((Object)path5, (String)"fs.getPath(it.key, \"res\")");
                Path path6 = fs.getPath((String)it4.getKey(), "resources.pb");
                Intrinsics.checkExpressionValueIsNotNull((Object)path6, (String)"fs.getPath(it.key, \"resources.pb\")");
                object = new ProtoResourcesGraphBuilder(path5, path6);
                collection.add(object);
            }
            List graphBuilders = (List)destination$iv$iv3;
            ObfuscationMappingsRecorder obfuscationMappingsRecorder2 = obfuscationMappingsRecorder;
            Logger logger2 = logger;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
            ShrinkerDebugReporter shrinkerDebugReporter = new LoggerAndFileDebugReporter(logger2, this.getReportFile());
            Object object3 = ((ResourceShrinkerParams)this.getParameters()).getUsePreciseShrinking().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"parameters.usePreciseShrinking.get()");
            AutoCloseable autoCloseable = new ResourceShrinkerImpl(resourcesGatherers, obfuscationMappingsRecorder2, usageRecorders, graphBuilders, shrinkerDebugReporter, true, (Boolean)object3);
            boolean bl16 = false;
            Throwable throwable2 = null;
            try {
                ResourceShrinkerImpl shrinker = (ResourceShrinkerImpl)autoCloseable;
                boolean bl17 = false;
                shrinker.analyze();
                File file = this.getOriginalBundleFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"originalBundleFile");
                File file2 = this.getShrunkBundleFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"shrunkBundleFile");
                shrinker.rewriteResourcesInBundleFormat(file, file2, allModules);
                if (shrinker.getUnusedResourceCount() > 0) {
                    long before = this.getOriginalBundleFile().length();
                    long after = this.getShrunkBundleFile().length();
                    int percent = (int)((before - after) * (long)100 / before);
                    String stat = "Removed unused resources: Binary bundle size reduced from " + ShrinkAppBundleResourcesAction.Companion.toKbString(before) + "KB to " + ShrinkAppBundleResourcesAction.Companion.toKbString(after) + "KB. Removed " + percent + '%';
                    logger.info(stat);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final File getOriginalBundleFile() {
        Lazy lazy = this.originalBundleFile$delegate;
        ShrinkAppBundleResourcesAction shrinkAppBundleResourcesAction = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    private final File getShrunkBundleFile() {
        Lazy lazy = this.shrunkBundleFile$delegate;
        ShrinkAppBundleResourcesAction shrinkAppBundleResourcesAction = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    private final File getReportFile() {
        Lazy lazy = this.reportFile$delegate;
        ShrinkAppBundleResourcesAction shrinkAppBundleResourcesAction = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    @Inject
    public ShrinkAppBundleResourcesAction() {
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/transforms/ShrinkAppBundleResourcesAction$Companion;", "", "()V", "toKbString", "", "size", "", "gradle-core"})
    public static final class Companion {
        private final String toKbString(long size) {
            return String.valueOf((int)size / 1024);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

