/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/tasks/DependenciesAnalyzer;", "", "()V", "level", "", "primitives", "", "", "findAllDependencies", "", "bytecode", "Ljava/io/InputStream;", "findPublicDependencies", "visitClass", "", "", "DependenciesClassVisitor", "gradle-core"})
public final class DependenciesAnalyzer {
    private final int level;
    private final Set<String> primitives = SetsKt.setOf((Object[])new String[]{"void", "boolean", "byte", "char", "short", "int", "long", "float", "double"});

    @NotNull
    public final List<String> findAllDependencies(@NotNull InputStream bytecode) {
        Intrinsics.checkParameterIsNotNull((Object)bytecode, (String)"bytecode");
        return CollectionsKt.toList((Iterable)this.visitClass(bytecode).keySet());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> findPublicDependencies(@NotNull InputStream bytecode) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)bytecode, (String)"bytecode");
        Map<String, Boolean> $this$filter$iv = this.visitClass(bytecode);
        boolean $i$f$filter = false;
        Map<String, Boolean> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!((Boolean)it.getValue()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
    }

    private final Map<String, Boolean> visitClass(InputStream bytecode) {
        ClassReader classReader = new ClassReader(bytecode);
        DependenciesClassVisitor classVisitor = new DependenciesClassVisitor(classReader);
        classReader.accept((ClassVisitor)classVisitor, 6);
        return classVisitor.getClasses();
    }

    public DependenciesAnalyzer() {
        this.level = 327680;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001:\u00045678B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0017H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002JM\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\u00072\b\u0010!\u001a\u0004\u0018\u00010\u00072\u0010\u0010\"\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$J\u001a\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\bH\u0016J8\u0010)\u001a\u00020*2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010'\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\u00072\b\u0010+\u001a\u0004\u0018\u00010,H\u0016JE\u0010-\u001a\u00020.2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010\u00072\b\u0010'\u001a\u0004\u0018\u00010\u00072\b\u0010 \u001a\u0004\u0018\u00010\u00072\u0010\u0010/\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010#H\u0016\u00a2\u0006\u0002\u00100J,\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u00132\b\u00103\u001a\u0004\u0018\u0001042\b\u0010'\u001a\u0004\u0018\u00010\u00072\u0006\u0010(\u001a\u00020\bH\u0016R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00069"}, d2={"Lcom/android/build/gradle/tasks/DependenciesAnalyzer$DependenciesClassVisitor;", "Lorg/objectweb/asm/ClassVisitor;", "reader", "Lorg/objectweb/asm/ClassReader;", "(Lcom/android/build/gradle/tasks/DependenciesAnalyzer;Lorg/objectweb/asm/ClassReader;)V", "classes", "", "", "", "getClasses", "()Ljava/util/Map;", "setClasses", "(Ljava/util/Map;)V", "getReader", "()Lorg/objectweb/asm/ClassReader;", "addSignature", "", "sign", "access", "", "addType", "type", "addTypeName", "Lorg/objectweb/asm/Type;", "addTypeSignature", "collectClassDependencies", "getTypeFromPackageName", "packageName", "isPrimitiveType", "visit", "version", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitAnnotation", "Lorg/objectweb/asm/AnnotationVisitor;", "desc", "visible", "visitField", "Lorg/objectweb/asm/FieldVisitor;", "value", "", "visitMethod", "Lorg/objectweb/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/objectweb/asm/MethodVisitor;", "visitTypeAnnotation", "typeRef", "typePath", "Lorg/objectweb/asm/TypePath;", "AnnotationDependenciesVisitor", "DependencySignatureVisitor", "FieldDependenciesVisitor", "MethodDependenciesVisitor", "gradle-core"})
    public final class DependenciesClassVisitor
    extends ClassVisitor {
        @NotNull
        private Map<String, Boolean> classes;
        @NotNull
        private final ClassReader reader;

        @NotNull
        public final Map<String, Boolean> getClasses() {
            return this.classes;
        }

        public final void setClasses(@NotNull Map<String, Boolean> map2) {
            Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
            this.classes = map2;
        }

        public void visit(int version, int access, @Nullable String name2, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
            if (superName != null) {
                String type = this.getTypeFromPackageName(superName);
                this.addType(type, access);
            }
            if (interfaces != null) {
                String[] $this$forEach$iv = interfaces;
                boolean $i$f$forEach = false;
                String[] stringArray = $this$forEach$iv;
                int n = stringArray.length;
                for (int j = 0; j < n; ++j) {
                    String element$iv;
                    String it = element$iv = stringArray[j];
                    boolean bl = false;
                    String interfaceType = this.getTypeFromPackageName(it);
                    this.addType(interfaceType, access);
                }
            }
            if (signature != null) {
                this.addSignature(signature, access);
            }
        }

        @NotNull
        public FieldVisitor visitField(int access, @Nullable String name2, @Nullable String desc, @Nullable String signature, @Nullable Object value) {
            if (desc != null) {
                Type type = Type.getType((String)desc);
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getType(desc)");
                this.addTypeName(type, access);
            }
            if (signature != null) {
                this.addTypeSignature(signature, access);
            }
            if (value != null && value instanceof Type) {
                String string = ((Type)value).getClassName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.className");
                this.addType(string, access);
            }
            return new FieldDependenciesVisitor();
        }

        @NotNull
        public MethodVisitor visitMethod(int access, @Nullable String name2, @Nullable String desc, @Nullable String signature, @Nullable String[] exceptions) {
            Type type;
            Type methodType;
            Type type2 = methodType = Type.getMethodType((String)desc);
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"methodType");
            Type type3 = type = type2.getReturnType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type");
            this.addTypeName(type3, access);
            Type[] typeArray = methodType.getArgumentTypes();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeArray, (String)"methodType.argumentTypes");
            Type[] $this$forEach$iv = typeArray;
            boolean $i$f$forEach = false;
            Type[] typeArray2 = $this$forEach$iv;
            int n = typeArray2.length;
            for (int j = 0; j < n; ++j) {
                Type element$iv;
                Type it = element$iv = typeArray2[j];
                boolean bl = false;
                Type type4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"it");
                this.addTypeName(type4, access);
            }
            if (signature != null) {
                this.addSignature(signature, access);
            }
            return new MethodDependenciesVisitor();
        }

        @NotNull
        public AnnotationVisitor visitAnnotation(@Nullable String desc, boolean visible) {
            Type type = Type.getType((String)desc);
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getType(desc)");
            String string = type.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Type.getType(desc).className");
            this.addType(string);
            return new AnnotationDependenciesVisitor();
        }

        @NotNull
        public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @Nullable String desc, boolean visible) {
            Type type = Type.getType((String)desc);
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getType(desc)");
            String string = type.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Type.getType(desc).className");
            this.addType(string);
            return new AnnotationDependenciesVisitor();
        }

        /*
         * WARNING - void declaration
         */
        private final void collectClassDependencies() {
            char[] charBuffer = new char[this.reader.getMaxStringLength()];
            int n = 1;
            int n2 = this.reader.getItemCount();
            while (n < n2) {
                void i2;
                int itemOffset = this.reader.getItem((int)i2);
                if (itemOffset > 0 && this.reader.readByte(itemOffset - 1) == 7) {
                    Type type;
                    String classDescriptor = this.reader.readUTF8(itemOffset, charBuffer);
                    Type type2 = type = Type.getObjectType((String)classDescriptor);
                    Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"type");
                    this.addTypeName(type2);
                }
                ++i2;
            }
        }

        private final String getTypeFromPackageName(String packageName2) {
            Type type = Type.getObjectType((String)packageName2);
            Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getObjectType(packageName)");
            String string = type.getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Type.getObjectType(packageName).className");
            return string;
        }

        private final void addType(String type) {
            this.addType(type, 2);
        }

        /*
         * Unable to fully structure code
         */
        private final void addType(String type, int access) {
            if (this.isPrimitiveType(type)) {
                return;
            }
            className = StringsKt.replace$default((String)type, (String)".", (String)"/", (boolean)false, (int)4, null) + ".class";
            if (Modifier.isPublic(access)) ** GOTO lbl-1000
            v0 = this.classes.get(className);
            if (v0 != null ? v0 : false) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            this.classes.put(className, v1);
        }

        private final void addTypeName(Type type, int access) {
            Type elementType = type;
            while (elementType.getSort() == 9) {
                Intrinsics.checkExpressionValueIsNotNull((Object)elementType.getElementType(), (String)"elementType.elementType");
            }
            if (elementType.getSort() == 10) {
                String string = elementType.getClassName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"elementType.className");
                this.addType(string, access);
            }
        }

        private final void addTypeName(Type type) {
            this.addTypeName(type, 2);
        }

        private final boolean isPrimitiveType(String type) {
            return DependenciesAnalyzer.this.primitives.contains(type);
        }

        private final void addSignature(String sign, int access) {
            new SignatureReader(sign).accept((SignatureVisitor)new DependencySignatureVisitor(access));
        }

        private final void addTypeSignature(String sign, int access) {
            new SignatureReader(sign).acceptType((SignatureVisitor)new DependencySignatureVisitor(access));
        }

        @NotNull
        public final ClassReader getReader() {
            return this.reader;
        }

        public DependenciesClassVisitor(ClassReader reader) {
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            super(DependenciesAnalyzer.this.level);
            this.reader = reader;
            boolean bl = false;
            this.classes = new LinkedHashMap();
            this.collectClassDependencies();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J,\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/tasks/DependenciesAnalyzer$DependenciesClassVisitor$FieldDependenciesVisitor;", "Lorg/objectweb/asm/FieldVisitor;", "(Lcom/android/build/gradle/tasks/DependenciesAnalyzer$DependenciesClassVisitor;)V", "visitAnnotation", "Lorg/objectweb/asm/AnnotationVisitor;", "desc", "", "visible", "", "visitTypeAnnotation", "typeRef", "", "typePath", "Lorg/objectweb/asm/TypePath;", "gradle-core"})
        public final class FieldDependenciesVisitor
        extends FieldVisitor {
            @NotNull
            public AnnotationVisitor visitAnnotation(@Nullable String desc, boolean visible) {
                Type type = Type.getType((String)desc);
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getType(desc)");
                String string = type.getClassName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Type.getType(desc).className");
                DependenciesClassVisitor.this.addType(string);
                return new AnnotationDependenciesVisitor();
            }

            @NotNull
            public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @Nullable String desc, boolean visible) {
                Type type = Type.getType((String)desc);
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getType(desc)");
                String string = type.getClassName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Type.getType(desc).className");
                DependenciesClassVisitor.this.addType(string);
                return new AnnotationDependenciesVisitor();
            }

            public FieldDependenciesVisitor() {
                super(DependenciesAnalyzer.this.level);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016JB\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00112\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J,\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/tasks/DependenciesAnalyzer$DependenciesClassVisitor$MethodDependenciesVisitor;", "Lorg/objectweb/asm/MethodVisitor;", "(Lcom/android/build/gradle/tasks/DependenciesAnalyzer$DependenciesClassVisitor;)V", "visitAnnotation", "Lorg/objectweb/asm/AnnotationVisitor;", "desc", "", "visible", "", "visitLocalVariable", "", "name", "signature", "start", "Lorg/objectweb/asm/Label;", "end", "index", "", "visitParameterAnnotation", "parameter", "visitTypeAnnotation", "typeRef", "typePath", "Lorg/objectweb/asm/TypePath;", "gradle-core"})
        public final class MethodDependenciesVisitor
        extends MethodVisitor {
            public void visitLocalVariable(@Nullable String name2, @Nullable String desc, @Nullable String signature, @Nullable Label start, @Nullable Label end, int index) {
                if (desc != null) {
                    Type type = Type.getType((String)desc);
                    Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getType(desc)");
                    DependenciesClassVisitor.this.addTypeName(type);
                }
                super.visitLocalVariable(name2, desc, signature, start, end, index);
            }

            @NotNull
            public AnnotationVisitor visitAnnotation(@Nullable String desc, boolean visible) {
                if (desc != null) {
                    Type type = Type.getType((String)desc);
                    Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getType(desc)");
                    DependenciesClassVisitor.this.addTypeName(type);
                }
                return new AnnotationDependenciesVisitor();
            }

            @NotNull
            public AnnotationVisitor visitParameterAnnotation(int parameter, @Nullable String desc, boolean visible) {
                Type type = Type.getType((String)desc);
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getType(desc)");
                DependenciesClassVisitor.this.addTypeName(type);
                return new AnnotationDependenciesVisitor();
            }

            @NotNull
            public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @Nullable String desc, boolean visible) {
                Type type = Type.getType((String)desc);
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getType(desc)");
                DependenciesClassVisitor.this.addTypeName(type);
                return new AnnotationDependenciesVisitor();
            }

            public MethodDependenciesVisitor() {
                super(DependenciesAnalyzer.this.level);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\t\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u000b\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/tasks/DependenciesAnalyzer$DependenciesClassVisitor$AnnotationDependenciesVisitor;", "Lorg/objectweb/asm/AnnotationVisitor;", "(Lcom/android/build/gradle/tasks/DependenciesAnalyzer$DependenciesClassVisitor;)V", "visit", "", "name", "", "value", "", "visitAnnotation", "desc", "visitArray", "gradle-core"})
        public final class AnnotationDependenciesVisitor
        extends AnnotationVisitor {
            public void visit(@Nullable String name2, @Nullable Object value) {
                if (value instanceof Type) {
                    String string = ((Type)value).getClassName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.className");
                    DependenciesClassVisitor.this.addType(string);
                }
            }

            @NotNull
            public AnnotationVisitor visitArray(@Nullable String name2) {
                return this;
            }

            @NotNull
            public AnnotationVisitor visitAnnotation(@Nullable String name2, @Nullable String desc) {
                Type type = Type.getType((String)desc);
                Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"Type.getType(desc)");
                String string = type.getClassName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Type.getType(desc).className");
                DependenciesClassVisitor.this.addType(string);
                return this;
            }

            public AnnotationDependenciesVisitor() {
                super(DependenciesAnalyzer.this.level);
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0001H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\r\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/tasks/DependenciesAnalyzer$DependenciesClassVisitor$DependencySignatureVisitor;", "Lorg/objectweb/asm/signature/SignatureVisitor;", "access", "", "(Lcom/android/build/gradle/tasks/DependenciesAnalyzer$DependenciesClassVisitor;I)V", "getAccess", "()I", "visitArrayType", "visitClassType", "", "name", "", "visitInnerClassType", "visitTypeVariable", "gradle-core"})
        public final class DependencySignatureVisitor
        extends SignatureVisitor {
            private final int access;

            public void visitTypeVariable(@Nullable String name2) {
                if (name2 != null) {
                    DependenciesClassVisitor.this.addType(name2, this.access);
                }
            }

            @NotNull
            public SignatureVisitor visitArrayType() {
                return this;
            }

            public void visitClassType(@Nullable String name2) {
                if (name2 != null) {
                    DependenciesClassVisitor.this.addType(name2, this.access);
                }
            }

            public void visitInnerClassType(@Nullable String name2) {
                if (name2 != null) {
                    DependenciesClassVisitor.this.addType(name2, this.access);
                }
            }

            public final int getAccess() {
                return this.access;
            }

            public DependencySignatureVisitor(int access) {
                super(DependenciesAnalyzer.this.level);
                this.access = access;
            }
        }
    }
}

