/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.tasks.LintBaseTask;
import com.android.utils.StringHelper;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public abstract class LintPerVariantTask
extends LintBaseTask
implements VariantAwareTask {
    private LintBaseTask.VariantInputs variantInputs;
    private ConfigurableFileCollection allInputs;
    private boolean fatalOnly;
    private String variantName;

    @Override
    @Internal
    public String getVariantName() {
        return this.variantName;
    }

    @Override
    public void setVariantName(String variantName) {
        this.variantName = variantName;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    public FileCollection getAllInputs() {
        return this.allInputs;
    }

    @Override
    protected void doTaskAction() {
        this.runLint(new LintPerVariantTaskDescriptor());
    }

    public static class VitalCreationAction
    extends LintBaseTask.BaseCreationAction<LintPerVariantTask> {
        private final ComponentImpl component;
        private final List<? extends VariantImpl> allComponentsWithLint;

        public VitalCreationAction(ComponentImpl component2, List<? extends VariantImpl> allComponentsWithLint) {
            super(component2.getGlobalScope());
            this.component = component2;
            this.allComponentsWithLint = allComponentsWithLint;
        }

        @Override
        public String getName() {
            return this.component.computeTaskName("lintVital");
        }

        @Override
        public Class<LintPerVariantTask> getType() {
            return LintPerVariantTask.class;
        }

        @Override
        public void configure(LintPerVariantTask task) {
            super.configure(task);
            task.setVariantName(this.component.getName());
            task.allInputs = this.globalScope.getProject().files(new Object[0]);
            task.variantInputs = new LintBaseTask.VariantInputs(this.component);
            task.allInputs.from(new Object[]{task.variantInputs.getAllInputs()});
            for (ComponentImpl componentImpl : this.allComponentsWithLint) {
                LintBaseTask.addModelArtifactsToInputs(task.allInputs, componentImpl);
            }
            task.fatalOnly = true;
            task.setDescription("Runs lint on just the fatal issues in the " + task.getVariantName() + " build.");
        }
    }

    public static class CreationAction
    extends LintBaseTask.BaseCreationAction<LintPerVariantTask> {
        private final VariantImpl variant;
        private final List<? extends VariantImpl> allVariants;

        public CreationAction(VariantImpl variant, List<? extends VariantImpl> allVariants) {
            super(variant.getGlobalScope());
            this.variant = variant;
            this.allVariants = allVariants;
        }

        @Override
        public String getName() {
            return this.variant.computeTaskName("lint");
        }

        @Override
        public Class<LintPerVariantTask> getType() {
            return LintPerVariantTask.class;
        }

        @Override
        public void configure(LintPerVariantTask lint) {
            super.configure(lint);
            lint.setVariantName(this.variant.getName());
            lint.allInputs = this.globalScope.getProject().files(new Object[0]);
            lint.variantInputs = new LintBaseTask.VariantInputs(this.variant);
            lint.allInputs.from(new Object[]{lint.variantInputs.getAllInputs()});
            for (VariantImpl variantImpl : this.allVariants) {
                LintBaseTask.addModelArtifactsToInputs(lint.allInputs, variantImpl);
            }
            lint.setDescription(StringHelper.appendCapitalized((String)"Runs lint on the ", (String)lint.getVariantName(), (String)" build."));
        }
    }

    private class LintPerVariantTaskDescriptor
    extends LintBaseTask.LintBaseTaskDescriptor {
        private LintPerVariantTaskDescriptor() {
            super(LintPerVariantTask.this);
        }

        public String getVariantName() {
            return LintPerVariantTask.this.getVariantName();
        }

        public LintBaseTask.VariantInputs getVariantInputs(String variantName) {
            assert (variantName.equals(this.getVariantName()));
            return LintPerVariantTask.this.variantInputs;
        }

        public Set<String> getVariantNames() {
            return Collections.singleton(LintPerVariantTask.this.variantName);
        }

        public boolean isFatalOnly() {
            return LintPerVariantTask.this.fatalOnly;
        }
    }
}

