/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.external.gnumake.NativeBuildConfigValueBuilder;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CreateCxxVariantModelKt;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.process.ProcessOutputJunctionKt;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016JC\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00052\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0006R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/tasks/NdkBuildExternalNativeJsonGenerator;", "Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "abis", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;Ljava/util/List;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "applicationMk", "Ljava/io/File;", "getApplicationMk", "()Ljava/io/File;", "makeFile", "getMakeFile", "ndkBuild", "", "getNdkBuild", "()Ljava/lang/String;", "executeProcess", "", "ops", "Lorg/gradle/process/ExecOperations;", "abi", "getBaseArgs", "removeJobsFlag", "", "useShortCommand", "forceCleanBuild", "dryRun", "(Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;ZLjava/lang/Boolean;ZZ)Ljava/util/List;", "getBuildCommand", "getProcessBuilder", "Lcom/android/ide/common/process/ProcessInfoBuilder;", "parseDryRunOutput", "gradle-core"})
public final class NdkBuildExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    @Override
    @NotNull
    public ProcessInfoBuilder getProcessBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.getNdkBuild()).addArgs(this.getBaseArgs(abi, false, false, true, true));
        return builder;
    }

    @Override
    public void executeProcess(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abi) {
        Intrinsics.checkParameterIsNotNull((Object)ops2, (String)"ops");
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        ProcessOutputJunctionKt.createProcessOutputJunction(CxxAbiModelKt.getMetadataGenerationCommandFile(abi), CxxAbiModelKt.getMetadataGenerationStdoutFile(abi), CxxAbiModelKt.getMetadataGenerationStderrFile(abi), this.getProcessBuilder(abi), "").logStderrToLifecycle().execute((Function1<? super Action<? super BaseExecSpec>, ? extends ExecResult>)((Function1)new Function1<Action<? super ExecSpec>, ExecResult>(ops2){

            public final ExecResult invoke(Action<? super ExecSpec> p1) {
                return ((ExecOperations)this.receiver).exec(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ExecOperations.class);
            }

            public final String getName() {
                return "exec";
            }

            public final String getSignature() {
                return "exec(Lorg/gradle/api/Action;)Lorg/gradle/process/ExecResult;";
            }
        }));
        this.parseDryRunOutput(abi);
    }

    public final void parseDryRunOutput(@NotNull CxxAbiModel abi) {
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        LoggingEnvironmentKt.infoln("parse and convert ndk-build output to build configuration JSON", new Object[0]);
        String buildOutput = FilesKt.readText$default((File)CxxAbiModelKt.getMetadataGenerationStdoutFile(abi), null, (int)1, null);
        NativeBuildConfigValueBuilder builder = new NativeBuildConfigValueBuilder(this.getMakeFile(), this.getVariant().getModule().getModuleRootFolder()).setCommands(this.getBuildCommand(abi, false), CollectionsKt.plus((Collection)this.getBuildCommand(abi, true), (Iterable)CollectionsKt.listOf((Object)"clean")), this.getVariant().getVariantName(), buildOutput);
        if (this.getVariant().getModule().getProject().isV2NativeModelEnabled()) {
            builder.setSkipProcessingCompilerFlags(true);
            builder.setCompileCommandsJsonBinFile(CxxAbiModelKt.getCompileCommandsJsonBinFile(abi));
        }
        NativeBuildConfigValue buildConfig = builder.build();
        File file = this.getApplicationMk();
        if (file != null) {
            File file2 = file;
            boolean bl = false;
            boolean bl2 = false;
            File it = file2;
            boolean bl3 = false;
            Object[] objectArray = new Object[1];
            String string = it.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.absolutePath");
            objectArray[0] = string;
            LoggingEnvironmentKt.infoln("found application make file %s", objectArray);
            Collection<File> collection = buildConfig.buildFiles;
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            collection.add(it);
        }
        String actualResult = new GsonBuilder().registerTypeAdapter((Type)((Object)File.class), (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson((Object)buildConfig);
        Path path = CxxAbiModelKt.getJsonFile(abi).toPath();
        String string = actualResult;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"actualResult");
        String string2 = string;
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charsets.UTF_8");
        Charset charset2 = charset;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Files.write(path, byArray, new OpenOption[0]);
    }

    private final String getNdkBuild() {
        String string;
        String tool = "ndk-build";
        if (ExternalNativeJsonGenerator.Companion.isWindows()) {
            tool = tool + ".cmd";
        }
        File toolFile = new File(this.getVariant().getModule().getNdkFolder().getPath(), tool);
        try {
            String string2 = toolFile.getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"toolFile.canonicalPath");
            string = string2;
        }
        catch (IOException e) {
            LoggingEnvironmentKt.warnln("Attempted to get ndkFolder canonical path and failed: %s\nFalling back to absolute path.", e);
            String string3 = toolFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"toolFile.absolutePath");
            string = string3;
        }
        return string;
    }

    private final File getApplicationMk() {
        File file = new File(this.getMakeFile().getParent(), "Application.mk");
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        return it.exists() ? file : null;
    }

    private final File getMakeFile() {
        return this.getVariant().getModule().getMakeFile().isDirectory() ? new File(this.getVariant().getModule().getMakeFile(), "Android.mk") : this.getVariant().getModule().getMakeFile();
    }

    private final List<String> getBaseArgs(CxxAbiModel abi, boolean removeJobsFlag, Boolean useShortCommand, boolean forceCleanBuild, boolean dryRun) {
        boolean bl;
        Object[] objectArray;
        Object object;
        boolean bl2;
        Object object2;
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"Lists.newArrayList()");
        List result2 = arrayList;
        result2.add("NDK_PROJECT_PATH=null");
        result2.add("APP_BUILD_SCRIPT=" + this.getMakeFile());
        File file = this.getApplicationMk();
        if (file != null) {
            object2 = file;
            bl2 = false;
            boolean bl3 = false;
            File it = object2;
            boolean bl4 = false;
            result2.add("NDK_APPLICATION_MK=" + it.getAbsolutePath());
        }
        object2 = CreateCxxVariantModelKt.getPrefabPackageDirectoryList(abi.getVariant());
        bl2 = false;
        if (!object2.isEmpty()) {
            if (abi.getVariant().getModule().getNdkVersion().getMajor() < 21) {
                LoggingEnvironmentKt.warnln("Prefab packages cannot be automatically imported until NDK r21.", new Object[0]);
            }
            result2.add("NDK_GRADLE_INJECTED_IMPORT_PATH=" + abi.getPrefabFolder().toString());
        }
        result2.add("APP_ABI=" + abi.getAbi().getTag());
        result2.add("NDK_ALL_ABIS=" + abi.getAbi().getTag());
        if (this.getVariant().isDebuggableEnabled()) {
            result2.add("NDK_DEBUG=1");
        } else {
            result2.add("NDK_DEBUG=0");
        }
        result2.add("APP_PLATFORM=android-" + abi.getAbiPlatformVersion());
        String ndkOut = new File(this.getVariant().getObjFolder().getPath()).getParent();
        if (SdkConstants.CURRENT_PLATFORM == 2) {
            String string = ndkOut;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ndkOut");
            ndkOut = StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
        result2.add("NDK_OUT=" + ndkOut);
        result2.add("NDK_LIBS_OUT=" + this.getVariant().getSoFolder().getPath());
        for (String flag : this.getVariant().getCFlagsList()) {
            object = StringCompanionObject.INSTANCE;
            String string = "APP_CFLAGS+=%s";
            objectArray = new Object[]{flag};
            bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            result2.add(string2);
        }
        for (String flag : this.getVariant().getCppFlagsList()) {
            object = StringCompanionObject.INSTANCE;
            String string = "APP_CPPFLAGS+=%s";
            objectArray = new Object[]{flag};
            bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            result2.add(string3);
        }
        boolean skipNextArgument = false;
        for (String argument : this.getVariant().getBuildSystemArgumentList()) {
            if (removeJobsFlag && Intrinsics.areEqual((Object)argument, (Object)"-j")) {
                skipNextArgument = true;
                continue;
            }
            if (removeJobsFlag && Intrinsics.areEqual((Object)argument, (Object)"--jobs")) {
                skipNextArgument = true;
                continue;
            }
            if (skipNextArgument) {
                skipNextArgument = false;
                continue;
            }
            if (removeJobsFlag && (StringsKt.startsWith$default((String)argument, (String)"-j", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)argument, (String)"--jobs=", (boolean)false, (int)2, null))) continue;
            result2.add(argument);
        }
        if (useShortCommand != null) {
            result2.add("APP_SHORT_COMMANDS=" + useShortCommand);
            result2.add("LOCAL_SHORT_COMMANDS=" + useShortCommand);
        }
        if (forceCleanBuild) {
            result2.add("-B");
        }
        if (dryRun) {
            result2.add("-n");
        }
        return result2;
    }

    static /* synthetic */ List getBaseArgs$default(NdkBuildExternalNativeJsonGenerator ndkBuildExternalNativeJsonGenerator, CxxAbiModel cxxAbiModel, boolean bl, Boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = null;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        return ndkBuildExternalNativeJsonGenerator.getBaseArgs(cxxAbiModel, bl, bl2, bl3, bl4);
    }

    private final List<String> getBuildCommand(CxxAbiModel abi, boolean removeJobsFlag) {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.getNdkBuild()), (Iterable)NdkBuildExternalNativeJsonGenerator.getBaseArgs$default(this, abi, removeJobsFlag, null, false, false, 28, null));
    }

    public NdkBuildExternalNativeJsonGenerator(@NotNull CxxVariantModel variant, @NotNull List<CxxAbiModel> abis, @NotNull GradleBuildVariant.Builder variantBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(abis, (String)"abis");
        Intrinsics.checkParameterIsNotNull((Object)variantBuilder, (String)"variantBuilder");
        super(variant, abis, variantBuilder);
        variantBuilder.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.NDK_BUILD);
        if (this.getVariant().getModule().getMakeFile().isDirectory()) {
            LoggingEnvironmentKt.errorln("Gradle project ndkBuild.path %s is a folder. Only files (like Android.mk) are allowed.", this.getVariant().getModule().getMakeFile());
        } else if (!this.getVariant().getModule().getMakeFile().exists()) {
            LoggingEnvironmentKt.errorln("Gradle project ndkBuild.path is %s but that file doesn't exist", this.getVariant().getModule().getMakeFile());
        }
    }
}

