/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.component.impl.TestComponentBuilderImpl;
import com.android.build.api.component.impl.TestComponentImpl;
import com.android.build.api.dsl.PrefabPackagingOptions;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.variant.impl.LibraryVariantBuilderImpl;
import com.android.build.api.variant.impl.LibraryVariantImpl;
import com.android.build.api.variant.impl.VariantImpl;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.internal.InternalScope;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.cxx.gradle.generator.CxxConfigurationModel;
import com.android.build.gradle.internal.dependency.ConfigurationVariantMapping;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.pipeline.OriginalStream;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.GenerateApiPublicTxtTask;
import com.android.build.gradle.internal.res.GenerateEmptyResourceFilesTask;
import com.android.build.gradle.internal.scope.BuildFeatureValues;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AarMetadataTask;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesDir;
import com.android.build.gradle.internal.tasks.BundleLibraryClassesJar;
import com.android.build.gradle.internal.tasks.BundleLibraryJavaRes;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.ExportConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.LibraryAarJarsTask;
import com.android.build.gradle.internal.tasks.LibraryJniLibsTask;
import com.android.build.gradle.internal.tasks.MergeConsumerProguardFilesTask;
import com.android.build.gradle.internal.tasks.MergeGeneratedProguardFilesCreationAction;
import com.android.build.gradle.internal.tasks.PackageRenderscriptTask;
import com.android.build.gradle.internal.tasks.PrefabModuleTaskData;
import com.android.build.gradle.internal.tasks.PrefabPackageTask;
import com.android.build.gradle.internal.tasks.StripDebugSymbolsTask;
import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import com.android.build.gradle.internal.tasks.factory.TaskProviderCallback;
import com.android.build.gradle.internal.variant.ComponentInfo;
import com.android.build.gradle.internal.variant.VariantHelper;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.BundleAar;
import com.android.build.gradle.tasks.CompileLibraryResourcesTask;
import com.android.build.gradle.tasks.ExtractAnnotations;
import com.android.build.gradle.tasks.ExtractDeepLinksTask;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.ProcessLibraryManifest;
import com.android.build.gradle.tasks.VerifyLibraryResourcesTask;
import com.android.build.gradle.tasks.ZipMergingTask;
import com.android.builder.errors.IssueReporter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;

public class LibraryTaskManager
extends TaskManager<LibraryVariantBuilderImpl, LibraryVariantImpl> {
    public LibraryTaskManager(List<ComponentInfo<LibraryVariantBuilderImpl, LibraryVariantImpl>> variants, List<ComponentInfo<TestComponentBuilderImpl, TestComponentImpl>> testComponents, boolean hasFlavors, GlobalScope globalScope, BaseExtension extension) {
        super(variants, testComponents, hasFlavors, globalScope, extension);
    }

    @Override
    protected void doCreateTasksForVariant(@NotNull ComponentInfo<LibraryVariantBuilderImpl, LibraryVariantImpl> variantInfo, @NotNull List<? extends ComponentInfo<LibraryVariantBuilderImpl, LibraryVariantImpl>> allVariants) {
        LibraryVariantImpl libraryVariant = variantInfo.getVariant();
        BuildFeatureValues buildFeatures = libraryVariant.getBuildFeatures();
        this.createAnchorTasks(libraryVariant);
        this.taskFactory.register(new ExtractDeepLinksTask.CreationAction(libraryVariant));
        this.createDependencyStreams(libraryVariant);
        if (buildFeatures.getAndroidResources()) {
            this.createGenerateResValuesTask(libraryVariant);
        } else {
            if (this.globalScope.getExtension().getAaptOptions().getNamespaced()) {
                this.getLogger().error("Disabling resource processing in resource namespace aware modules is not supported currently.");
            }
            this.taskFactory.register(new GenerateEmptyResourceFilesTask.CreateAction(libraryVariant));
        }
        this.taskFactory.register(new CheckManifest.CreationAction(libraryVariant));
        this.taskFactory.register(new ProcessLibraryManifest.CreationAction(libraryVariant));
        this.createRenderscriptTask(libraryVariant);
        if (buildFeatures.getAndroidResources()) {
            this.createMergeResourcesTasks(libraryVariant);
            this.createCompileLibraryResourcesTask(libraryVariant);
        }
        this.createShaderTask(libraryVariant);
        this.createMergeAssetsTask(libraryVariant);
        this.createLibraryAssetsTask(libraryVariant);
        this.createBuildConfigTask(libraryVariant);
        if (buildFeatures.getAndroidResources()) {
            this.createProcessResTask(libraryVariant, null, TaskManager.MergeType.PACKAGE, this.globalScope.getProjectBaseName());
            if (!libraryVariant.getDebuggable() && !this.globalScope.getExtension().getAaptOptions().getNamespaced()) {
                this.createVerifyLibraryResTask(libraryVariant);
            }
            this.registerLibraryRClassTransformStream(libraryVariant);
        }
        this.createProcessJavaResTask(libraryVariant);
        this.createAidlTask(libraryVariant);
        this.createDataBindingTasksIfNecessary(libraryVariant);
        this.createMlkitTask(libraryVariant);
        TaskProvider<JavaCompile> javacTask = this.createJavacTask(libraryVariant);
        this.addJavacClassesStream(libraryVariant);
        TaskManager.setJavaCompilerTask(javacTask, libraryVariant);
        this.taskFactory.register(new MergeGeneratedProguardFilesCreationAction(libraryVariant));
        this.createExternalNativeBuildTasks(libraryVariant);
        this.createMergeJniLibFoldersTasks(libraryVariant);
        this.taskFactory.register(new StripDebugSymbolsTask.CreationAction(libraryVariant));
        this.taskFactory.register(new PackageRenderscriptTask.CreationAction(libraryVariant));
        this.taskFactory.register(new MergeConsumerProguardFilesTask.CreationAction(libraryVariant));
        this.taskFactory.register(new ExportConsumerProguardFilesTask.CreationAction(libraryVariant));
        this.createPrefabTasks(libraryVariant);
        if (libraryVariant.getServices().getProjectOptions().get(BooleanOption.ENABLE_EXTRACT_ANNOTATIONS)) {
            this.taskFactory.register(new ExtractAnnotations.CreationAction(libraryVariant));
        }
        boolean instrumented = libraryVariant.getVariantDslInfo().isTestCoverageEnabled();
        TransformManager transformManager = libraryVariant.getTransformManager();
        if (instrumented) {
            this.createJacocoTask(libraryVariant);
        }
        this.maybeCreateTransformClassesWithAsmTask(libraryVariant, instrumented);
        List<Transform> customTransforms = this.extension.getTransforms();
        List<List<Object>> customTransformsDependencies = this.extension.getTransformsDependencies();
        IssueReporter issueReporter2 = libraryVariant.getServices().getIssueReporter();
        int count = customTransforms.size();
        for (int i2 = 0; i2 < count; ++i2) {
            Transform transform2 = customTransforms.get(i2);
            Sets.SetView difference = Sets.difference((Set)transform2.getScopes(), TransformManager.PROJECT_ONLY);
            if (!difference.isEmpty()) {
                String scopes2 = difference.toString();
                issueReporter2.reportError(IssueReporter.Type.GENERIC, String.format("Transforms with scopes '%s' cannot be applied to library projects.", scopes2));
            }
            List<Object> deps = customTransformsDependencies.get(i2);
            transformManager.addTransform(this.taskFactory, libraryVariant, transform2, null, task -> {
                if (!deps.isEmpty()) {
                    task.dependsOn(new Object[]{deps});
                }
            }, taskProvider -> {
                if (transform2.getScopes().isEmpty()) {
                    TaskFactoryUtils.dependsOn(libraryVariant.getTaskContainer().getAssembleTask(), taskProvider);
                }
            });
        }
        this.taskFactory.register(new BundleLibraryClassesJar.CreationAction(libraryVariant, AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS));
        this.taskFactory.register(new BundleLibraryClassesDir.CreationAction(libraryVariant));
        this.taskFactory.register(new BundleLibraryJavaRes.CreationAction(libraryVariant));
        this.taskFactory.register(new ZipMergingTask.CreationAction(libraryVariant));
        this.taskFactory.register(new LibraryJniLibsTask.ProjectOnlyCreationAction(libraryVariant, InternalArtifactType.LIBRARY_JNI.INSTANCE));
        this.createMergeJavaResTask(libraryVariant);
        this.maybeCreateJavaCodeShrinkerTask(libraryVariant);
        this.taskFactory.register(new LibraryAarJarsTask.CreationAction(libraryVariant));
        this.taskFactory.register(new LibraryJniLibsTask.ProjectAndLocalJarsCreationAction(libraryVariant, InternalArtifactType.LIBRARY_AND_LOCAL_JARS_JNI.INSTANCE));
        this.taskFactory.register(new AarMetadataTask.CreationAction(libraryVariant));
        this.createLintTasks(libraryVariant, allVariants);
        this.createBundleTask(libraryVariant);
    }

    private void registerLibraryRClassTransformStream(VariantImpl variant) {
        if (!variant.getBuildFeatures().getAndroidResources()) {
            return;
        }
        ConfigurableFileCollection compileRClass = this.project.files(new Object[]{variant.getArtifacts().get(InternalArtifactType.COMPILE_R_CLASS_JAR.INSTANCE)});
        variant.getTransformManager().addStream(OriginalStream.builder("compile-only-r-class").addContentTypes(TransformManager.CONTENT_CLASS).addScope((QualifiedContent.ScopeType)QualifiedContent.Scope.PROVIDED_ONLY).setFileCollection((FileCollection)compileRClass).build());
    }

    private void createBundleTask(VariantImpl variant) {
        TaskProvider<BundleAar> bundle = this.taskFactory.register(new BundleAar.CreationAction(variant));
        variant.getTaskContainer().getAssembleTask().configure(task -> task.dependsOn(new Object[]{variant.getArtifacts().get(ArtifactType.AAR.INSTANCE)}));
        VariantDependencies variantDependencies = variant.getVariantDependencies();
        AdhocComponentWithVariants component2 = this.globalScope.getComponentFactory().adhoc(variant.getName());
        Configuration apiPub = variantDependencies.getElements(AndroidArtifacts.PublishedConfigType.API_PUBLICATION);
        Configuration runtimePub = variantDependencies.getElements(AndroidArtifacts.PublishedConfigType.RUNTIME_PUBLICATION);
        component2.addVariantsFromConfiguration(apiPub, (Action)new ConfigurationVariantMapping("compile", false));
        component2.addVariantsFromConfiguration(runtimePub, (Action)new ConfigurationVariantMapping("runtime", false));
        this.project.getComponents().add((Object)component2);
        AdhocComponentWithVariants allVariants = (AdhocComponentWithVariants)this.project.getComponents().findByName("all");
        if (allVariants == null) {
            allVariants = this.globalScope.getComponentFactory().adhoc("all");
            this.project.getComponents().add((Object)allVariants);
        }
        Configuration allApiPub = variantDependencies.getElements(AndroidArtifacts.PublishedConfigType.ALL_API_PUBLICATION);
        allVariants.addVariantsFromConfiguration(allApiPub, (Action)new ConfigurationVariantMapping("compile", true));
        Configuration allRuntimePub = variantDependencies.getElements(AndroidArtifacts.PublishedConfigType.ALL_RUNTIME_PUBLICATION);
        allVariants.addVariantsFromConfiguration(allRuntimePub, (Action)new ConfigurationVariantMapping("runtime", true));
        if (this.extension.getDefaultPublishConfig().equals(variant.getName())) {
            VariantHelper.setupArchivesConfig(this.project, variantDependencies.getRuntimeClasspath());
            this.project.getArtifacts().add("default", bundle);
        }
    }

    @Override
    protected void createDependencyStreams(ComponentCreationConfig creationConfig) {
        super.createDependencyStreams(creationConfig);
        creationConfig.getTransformManager().addStream(OriginalStream.builder("local-deps-classes").addContentTypes(TransformManager.CONTENT_CLASS).addScope(InternalScope.LOCAL_DEPS).setFileCollection(creationConfig.getVariantScope().getLocalPackagedJars()).build());
    }

    private void createMergeResourcesTasks(VariantImpl variant) {
        ImmutableSet flags = variant.getGlobalScope().getExtension().getAaptOptions().getNamespaced() ? Sets.immutableEnumSet((Enum)MergeResources.Flag.REMOVE_RESOURCE_NAMESPACES, (Enum[])new MergeResources.Flag[]{MergeResources.Flag.PROCESS_VECTOR_DRAWABLES}) : Sets.immutableEnumSet((Enum)MergeResources.Flag.PROCESS_VECTOR_DRAWABLES, (Enum[])new MergeResources.Flag[0]);
        MergeResourceCallback callback = new MergeResourceCallback(variant);
        this.basicCreateMergeResourcesTask(variant, TaskManager.MergeType.PACKAGE, variant.getPaths().getIntermediateDir((Artifact<Directory>)InternalArtifactType.PACKAGED_RES.INSTANCE), false, false, false, (ImmutableSet<MergeResources.Flag>)flags, callback);
        this.createMergeResourcesTask(variant, false, (ImmutableSet<MergeResources.Flag>)ImmutableSet.of());
        this.taskFactory.register(new GenerateApiPublicTxtTask.CreationAction(variant));
    }

    private void createCompileLibraryResourcesTask(VariantImpl variant) {
        if (variant.isPrecompileDependenciesResourcesEnabled()) {
            this.taskFactory.register(new CompileLibraryResourcesTask.CreationAction(variant));
        }
    }

    @Override
    protected void postJavacCreation(ComponentCreationConfig creationConfig) {
        ConfigurableFileCollection files2 = creationConfig.getServices().fileCollection(creationConfig.getArtifacts().get(InternalArtifactType.JAVAC.INSTANCE), creationConfig.getVariantData().getAllPreJavacGeneratedBytecode(), creationConfig.getVariantData().getAllPostJavacGeneratedBytecode());
        creationConfig.getArtifacts().appendToAllClasses((FileCollection)files2);
        this.taskFactory.register(new BundleLibraryClassesJar.CreationAction(creationConfig, AndroidArtifacts.PublishedConfigType.API_ELEMENTS));
    }

    public void createLibraryAssetsTask(VariantImpl variant) {
        this.taskFactory.register(new MergeSourceSetFolders.LibraryAssetCreationAction(variant));
    }

    public void createPrefabTasks(LibraryVariantImpl libraryVariant) {
        if (!libraryVariant.getBuildFeatures().getPrefabPublishing()) {
            return;
        }
        CxxConfigurationModel configurationModel = libraryVariant.getTaskContainer().getCxxConfigurationModel();
        if (configurationModel == null) {
            return;
        }
        LibraryExtension extension = (LibraryExtension)this.globalScope.getExtension();
        ArrayList modules = Lists.newArrayList();
        for (PrefabPackagingOptions options : extension.getPrefab()) {
            File headers = null;
            if (options.getHeaders() != null) {
                headers = this.project.getLayout().getProjectDirectory().dir(options.getHeaders()).getAsFile();
            }
            modules.add(new PrefabModuleTaskData(options.getName(), headers, options.getLibraryName()));
        }
        if (!modules.isEmpty()) {
            TaskProvider<PrefabPackageTask> packageTask = this.taskFactory.register(new PrefabPackageTask.CreationAction(modules, (SdkComponentsBuildService)libraryVariant.getGlobalScope().getSdkComponents().get(), libraryVariant.getTaskContainer().getCxxConfigurationModel(), libraryVariant));
            ((PrefabPackageTask)packageTask.get()).dependsOn(new Object[]{libraryVariant.getTaskContainer().getExternalNativeBuildTask()});
        }
    }

    @Override
    protected Set<QualifiedContent.ScopeType> getJavaResMergingScopes(ComponentCreationConfig creationConfig, QualifiedContent.ContentType contentType) {
        Preconditions.checkArgument((contentType == QualifiedContent.DefaultContentType.RESOURCES ? 1 : 0) != 0, (Object)"contentType must be RESOURCES");
        if (creationConfig.getVariantType().isTestComponent()) {
            return TransformManager.SCOPE_FULL_PROJECT_WITH_LOCAL_JARS;
        }
        return TransformManager.SCOPE_FULL_LIBRARY_WITH_LOCAL_JARS;
    }

    @Override
    protected boolean isLibrary() {
        return true;
    }

    public void createVerifyLibraryResTask(VariantImpl variant) {
        TaskProvider<VerifyLibraryResourcesTask> verifyLibraryResources = this.taskFactory.register(new VerifyLibraryResourcesTask.CreationAction(variant));
        variant.getTaskContainer().getAssembleTask().configure(task -> task.dependsOn(new Object[]{variant.getArtifacts().get(InternalArtifactType.VERIFIED_LIBRARY_RESOURCES.INSTANCE)}));
    }

    @Override
    protected void configureGlobalLintTask() {
        super.configureGlobalLintTask();
        for (LibraryVariantImpl variant : this.variantPropertiesList) {
            variant.getArtifacts().copy(InternalArtifactType.LINT_PUBLISH_JAR.INSTANCE, this.globalScope.getGlobalArtifacts());
        }
    }

    private static class MergeResourceCallback
    implements TaskProviderCallback<MergeResources> {
        private final VariantImpl variant;

        private MergeResourceCallback(VariantImpl variant) {
            this.variant = variant;
        }

        @Override
        public void handleProvider(TaskProvider<MergeResources> taskProvider) {
            this.variant.getArtifacts().setInitialProvider(taskProvider, MergeResources::getPublicFile).withName("public.txt").on(InternalArtifactType.PUBLIC_RES.INSTANCE);
        }
    }
}

