/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.dependency.RenamedConfigurationAction;
import com.android.build.gradle.internal.dsl.AndroidSourceSetFactory;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.scope.DelayedActionsExecutor;
import com.android.build.gradle.internal.services.DslServices;
import com.android.builder.errors.IssueReporter;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u0005H\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001a\u0010!\u001a\u00020\u00182\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130#J%\u0010!\u001a\u00020\u00182\u001d\u0010\"\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0004\u0012\u00020\u00180$\u00a2\u0006\u0002\b%J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0002J \u0010(\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u000fH\u0002J\u0006\u0010*\u001a\u00020\u0018J\u001a\u0010+\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010 \u001a\u00020\u0005H\u0007J\u000e\u0010,\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006-"}, d2={"Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "", "project", "Lorg/gradle/api/Project;", "publishPackage", "", "dslServices", "Lcom/android/build/gradle/internal/services/DslServices;", "buildArtifactActions", "Lcom/android/build/gradle/internal/scope/DelayedActionsExecutor;", "(Lorg/gradle/api/Project;ZLcom/android/build/gradle/internal/services/DslServices;Lcom/android/build/gradle/internal/scope/DelayedActionsExecutor;)V", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "configuredSourceSets", "", "", "logger", "Lorg/gradle/api/logging/Logger;", "sourceSetsContainer", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "getSourceSetsContainer", "()Lorg/gradle/api/NamedDomainObjectContainer;", "checkForUnconfiguredSourceSets", "", "createConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "name", "description", "canBeResolved", "createConfigurationsForSourceSet", "sourceSet", "isTestComponent", "executeAction", "action", "Lorg/gradle/api/Action;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "getConfigDesc", "sourceSetName", "getDeprecatedConfigDesc", "replacement", "runBuildableArtifactsActions", "setUpSourceSet", "setUpTestSourceSet", "gradle-core"})
public final class SourceSetManager {
    @NotNull
    private final NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer;
    private final ConfigurationContainer configurations;
    private final Logger logger;
    private final Set<String> configuredSourceSets;
    private final boolean publishPackage;
    private final DslServices dslServices;
    private final DelayedActionsExecutor buildArtifactActions;

    @NotNull
    public final NamedDomainObjectContainer<AndroidSourceSet> getSourceSetsContainer() {
        return this.sourceSetsContainer;
    }

    @NotNull
    public final AndroidSourceSet setUpTestSourceSet(@NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return this.setUpSourceSet(name2, true);
    }

    @JvmOverloads
    @NotNull
    public final AndroidSourceSet setUpSourceSet(@NotNull String name2, boolean isTestComponent) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        AndroidSourceSet sourceSet = (AndroidSourceSet)this.sourceSetsContainer.maybeCreate(name2);
        if (!this.configuredSourceSets.contains(name2)) {
            AndroidSourceSet androidSourceSet = sourceSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
            this.createConfigurationsForSourceSet(androidSourceSet, isTestComponent);
            this.configuredSourceSets.add(name2);
        }
        AndroidSourceSet androidSourceSet = sourceSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
        return androidSourceSet;
    }

    public static /* synthetic */ AndroidSourceSet setUpSourceSet$default(SourceSetManager sourceSetManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sourceSetManager.setUpSourceSet(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final AndroidSourceSet setUpSourceSet(@NotNull String name2) {
        return SourceSetManager.setUpSourceSet$default(this, name2, false, 2, null);
    }

    private final void createConfigurationsForSourceSet(AndroidSourceSet sourceSet, boolean isTestComponent) {
        String apiName = sourceSet.getApiConfigurationName();
        String implementationName = sourceSet.getImplementationConfigurationName();
        String runtimeOnlyName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyName = sourceSet.getCompileOnlyConfigurationName();
        String compileName = sourceSet.getCompileConfigurationName();
        Configuration compile = this.createConfiguration(compileName, this.getDeprecatedConfigDesc("Compile", sourceSet.getName(), implementationName), Intrinsics.areEqual((Object)"compile", (Object)compileName) || Intrinsics.areEqual((Object)"testCompile", (Object)compileName));
        compile.getDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(isTestComponent ? implementationName : implementationName + "' and '" + apiName, compileName, this.dslServices.getDeprecationReporter(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        String packageConfigDescription = null;
        packageConfigDescription = this.publishPackage ? this.getDeprecatedConfigDesc("Publish", sourceSet.getName(), runtimeOnlyName) : this.getDeprecatedConfigDesc("Apk", sourceSet.getName(), runtimeOnlyName);
        String apkName = sourceSet.getPackageConfigurationName();
        Configuration apk = SourceSetManager.createConfiguration$default(this, apkName, packageConfigDescription, false, 4, null);
        apk.getDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(runtimeOnlyName, apkName, this.dslServices.getDeprecationReporter(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        String providedName = sourceSet.getProvidedConfigurationName();
        Configuration provided = SourceSetManager.createConfiguration$default(this, providedName, this.getDeprecatedConfigDesc("Provided", sourceSet.getName(), compileOnlyName), false, 4, null);
        provided.getDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(compileOnlyName, providedName, this.dslServices.getDeprecationReporter(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        Configuration api = SourceSetManager.createConfiguration$default(this, apiName, this.getConfigDesc("API", sourceSet.getName()), false, 4, null);
        api.extendsFrom(new Configuration[]{compile});
        if (isTestComponent) {
            api.getDependencies().whenObjectAdded((Action)new RenamedConfigurationAction(implementationName, apiName, this.dslServices.getDeprecationReporter(), DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        }
        Configuration implementation = SourceSetManager.createConfiguration$default(this, implementationName, this.getConfigDesc("Implementation only", sourceSet.getName()), false, 4, null);
        implementation.extendsFrom(new Configuration[]{api});
        Configuration runtimeOnly = SourceSetManager.createConfiguration$default(this, runtimeOnlyName, this.getConfigDesc("Runtime only", sourceSet.getName()), false, 4, null);
        runtimeOnly.extendsFrom(new Configuration[]{apk});
        Configuration compileOnly = SourceSetManager.createConfiguration$default(this, compileOnlyName, this.getConfigDesc("Compile only", sourceSet.getName()), false, 4, null);
        compileOnly.extendsFrom(new Configuration[]{provided});
        Configuration wearConfig = SourceSetManager.createConfiguration$default(this, sourceSet.getWearAppConfigurationName(), "Link to a wear app to embed for object '" + sourceSet.getName() + "'.", false, 4, null);
        SourceSetManager.createConfiguration$default(this, sourceSet.getAnnotationProcessorConfigurationName(), "Classpath for the annotation processor for '" + sourceSet.getName() + "'.", false, 4, null);
    }

    private final Configuration createConfiguration(String name2, String description, boolean canBeResolved) {
        Configuration configuration2;
        this.logger.debug("Creating configuration {}", (Object)name2);
        Configuration configuration3 = configuration2 = (Configuration)this.configurations.maybeCreate(name2);
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
        configuration3.setVisible(false);
        configuration2.setDescription(description);
        configuration2.setCanBeConsumed(false);
        configuration2.setCanBeResolved(canBeResolved);
        return configuration2;
    }

    static /* synthetic */ Configuration createConfiguration$default(SourceSetManager sourceSetManager, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return sourceSetManager.createConfiguration(string, string2, bl);
    }

    private final String getConfigDesc(String name2, String sourceSetName) {
        return name2 + " dependencies for '" + sourceSetName + "' sources.";
    }

    private final String getDeprecatedConfigDesc(String name2, String sourceSetName, String replacement) {
        return name2 + " dependencies for '" + sourceSetName + "' sources " + "(deprecated: use '" + replacement + "' instead).";
    }

    public final void checkForUnconfiguredSourceSets() {
        Iterable $this$forEach$iv = (Iterable)this.sourceSetsContainer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidSourceSet sourceSet = (AndroidSourceSet)element$iv;
            boolean bl = false;
            if (this.configuredSourceSets.contains(sourceSet.getName())) continue;
            String message = "The SourceSet '" + sourceSet.getName() + "' is not recognized " + "by the Android Gradle Plugin. Perhaps you misspelled something?";
            IssueReporter.reportError$default((IssueReporter)this.dslServices.getIssueReporter(), (IssueReporter.Type)IssueReporter.Type.GENERIC, (String)message, null, null, (int)12, null);
        }
    }

    public final void executeAction(@NotNull Action<NamedDomainObjectContainer<AndroidSourceSet>> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        action.execute(this.sourceSetsContainer);
    }

    public final void executeAction(@NotNull Function1<? super NamedDomainObjectContainer<AndroidSourceSet>, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        action.invoke(this.sourceSetsContainer);
    }

    public final void runBuildableArtifactsActions() {
        this.buildArtifactActions.runAll();
    }

    public SourceSetManager(@NotNull Project project, boolean publishPackage, @NotNull DslServices dslServices, @NotNull DelayedActionsExecutor buildArtifactActions) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dslServices, (String)"dslServices");
        Intrinsics.checkParameterIsNotNull((Object)buildArtifactActions, (String)"buildArtifactActions");
        this.publishPackage = publishPackage;
        this.dslServices = dslServices;
        this.buildArtifactActions = buildArtifactActions;
        NamedDomainObjectContainer namedDomainObjectContainer = project.container(AndroidSourceSet.class, (NamedDomainObjectFactory)new AndroidSourceSetFactory(project, this.publishPackage, this.dslServices));
        Intrinsics.checkExpressionValueIsNotNull((Object)namedDomainObjectContainer, (String)"project.container(\n     \u2026ishPackage, dslServices))");
        this.sourceSetsContainer = namedDomainObjectContainer;
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.configurations");
        this.configurations = configurationContainer;
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(this.javaClass)");
        this.logger = logger;
        boolean bl = false;
        this.configuredSourceSets = new LinkedHashSet();
    }
}

