/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.ide.DependencyFailureHandler;
import com.android.build.gradle.internal.lint.CustomLintCheckUtils;
import com.android.builder.errors.IssueReporter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"getLocalCustomLintChecks", "Lorg/gradle/api/file/FileCollection;", "lintChecks", "Lorg/gradle/api/artifacts/Configuration;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "lenientMode", "", "getLocalCustomLintChecksForModel", "Lcom/google/common/collect/ImmutableList;", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "gradle-core"})
@JvmName(name="CustomLintCheckUtils")
public final class CustomLintCheckUtils {
    @NotNull
    public static final ImmutableList<File> getLocalCustomLintChecksForModel(@NotNull Project project, @NotNull IssueReporter issueReporter2) {
        Configuration lintChecks;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter2, (String)"issueReporter");
        Configuration configuration2 = lintChecks = project.getConfigurations().getByName("lintChecks");
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"lintChecks");
        ArtifactCollection artifactCollection = CustomLintCheckUtils.getLocalCustomLintChecks(configuration2, true);
        Collection failures = artifactCollection.getFailures();
        if (!failures.isEmpty()) {
            DependencyFailureHandler failureHandler = new DependencyFailureHandler();
            String string = project.getPath() + "/" + lintChecks.getName();
            Collection collection = failures;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"failures");
            failureHandler.addErrors(string, collection);
            failureHandler.registerIssues(issueReporter2);
        }
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"artifactCollection.artifactFiles");
        ImmutableList immutableList = ImmutableList.copyOf((Collection)fileCollection2.getFiles());
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"ImmutableList.copyOf(art\u2026tion.artifactFiles.files)");
        return immutableList;
    }

    @NotNull
    public static final FileCollection getLocalCustomLintChecks(@NotNull Configuration lintChecks) {
        Intrinsics.checkParameterIsNotNull((Object)lintChecks, (String)"lintChecks");
        FileCollection fileCollection2 = CustomLintCheckUtils.getLocalCustomLintChecks(lintChecks, false).getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"getLocalCustomLintChecks\u2026de = false).artifactFiles");
        return fileCollection2;
    }

    @NotNull
    public static final ArtifactCollection getLocalCustomLintChecks(@NotNull Configuration lintChecks, boolean lenientMode) {
        Intrinsics.checkParameterIsNotNull((Object)lintChecks, (String)"lintChecks");
        ArtifactView artifactView = lintChecks.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(lenientMode){
            final /* synthetic */ boolean $lenientMode;

            public final void execute(@NotNull ArtifactView.ViewConfiguration config2) {
                Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
                config2.attributes((Action)getLocalCustomLintChecks.1.INSTANCE);
                config2.lenient(this.$lenientMode);
            }
            {
                this.$lenientMode = bl;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"lintChecks.incoming.arti\u2026enient(lenientMode)\n    }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"lintChecks.incoming.arti\u2026ientMode)\n    }.artifacts");
        return artifactCollection;
    }
}

