/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTask$CreationAction$handleProvider$1;
import com.android.build.gradle.internal.tasks.AssetPackPreBundleTaskRunnable;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "assetsFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getAssetsFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "manifestFiles", "Lorg/gradle/api/file/DirectoryProperty;", "getManifestFiles", "()Lorg/gradle/api/file/DirectoryProperty;", "outputDir", "getOutputDir", "doTaskAction", "", "CreationAction", "gradle-core"})
public abstract class AssetPackPreBundleTask
extends NonIncrementalTask {
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @NotNull
    public abstract DirectoryProperty getManifestFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ConfigurableFileCollection getAssetsFiles();

    @Override
    protected void doTaskAction() {
        FileTree fileTree = this.getManifestFiles().getAsFileTree();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"manifestFiles.asFileTree");
        for (File manifestFile : fileTree.getFiles()) {
            File file = manifestFile.getParentFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"manifestFile.parentFile");
            String assetPackName = file.getName();
            Directory packDir = (Directory)this.getOutputDir().dir(assetPackName).get();
            this.getWorkerExecutor().noIsolation().submit(AssetPackPreBundleTaskRunnable.class, (Action)new Action<AssetPackPreBundleTaskRunnable.Params>(this, packDir, assetPackName, manifestFile){
                final /* synthetic */ AssetPackPreBundleTask this$0;
                final /* synthetic */ Directory $packDir;
                final /* synthetic */ String $assetPackName;
                final /* synthetic */ File $manifestFile;

                public final void execute(AssetPackPreBundleTaskRunnable.Params it) {
                    it.initializeFromAndroidVariantTask(this.this$0);
                    it.getPackDir().set((Object)this.$packDir);
                    it.getPackFile().set((Object)this.$packDir.file(this.$assetPackName + ".zip"));
                    Property<String> property = it.getAssetsFilesPath();
                    FileCollection fileCollection2 = this.this$0.getAssetsFiles().filter((Spec)new Spec<File>(this){
                        final /* synthetic */ doTaskAction.1 this$0;

                        public final boolean isSatisfiedBy(File assetPack) {
                            File file = assetPack;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"assetPack");
                            String string = file.getAbsolutePath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"assetPack.absolutePath");
                            return StringsKt.contains$default((CharSequence)string, (CharSequence)(this.this$0.$assetPackName + File.separator + "src" + File.separator + "main" + File.separator + "assets"), (boolean)false, (int)2, null);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"assetsFiles.filter { ass\u2026      )\n                }");
                    property.set((Object)fileCollection2.getAsPath());
                    it.getManifestFile().set(this.$manifestFile);
                }
                {
                    this.this$0 = assetPackPreBundleTask;
                    this.$packDir = directory2;
                    this.$assetPackName = string;
                    this.$manifestFile = file;
                }
            });
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AssetPackPreBundleTask;", "Lcom/android/build/gradle/internal/component/VariantCreationConfig;", "creationConfig", "assetFileCollection", "Lorg/gradle/api/file/FileCollection;", "(Lcom/android/build/gradle/internal/component/VariantCreationConfig;Lorg/gradle/api/file/FileCollection;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<AssetPackPreBundleTask, VariantCreationConfig> {
        @NotNull
        private final Class<AssetPackPreBundleTask> type;
        @NotNull
        private final String name;
        private final FileCollection assetFileCollection;

        @Override
        @NotNull
        public Class<AssetPackPreBundleTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AssetPackPreBundleTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, (Function1)AssetPackPreBundleTask$CreationAction$handleProvider$1.INSTANCE).on(InternalArtifactType.ASSET_PACK_BUNDLE.INSTANCE);
        }

        @Override
        public void configure(@NotNull AssetPackPreBundleTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setTaskInputToFinalProduct(InternalArtifactType.LINKED_RES_FOR_ASSET_PACK.INSTANCE, (Property)task.getManifestFiles());
            task.getAssetsFiles().from(new Object[]{this.assetFileCollection});
        }

        public CreationAction(@NotNull VariantCreationConfig creationConfig, @NotNull FileCollection assetFileCollection) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            Intrinsics.checkParameterIsNotNull((Object)assetFileCollection, (String)"assetFileCollection");
            super((ComponentCreationConfig)creationConfig);
            this.assetFileCollection = assetFileCollection;
            this.type = AssetPackPreBundleTask.class;
            this.name = this.computeTaskName("assetPack", "PreBundleTask");
        }
    }
}

