/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.component.VariantCreationConfig;
import com.android.build.gradle.internal.coverage.JacocoConfigurations;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.FileInfo;
import com.android.build.gradle.internal.tasks.JarsClasspathInputsWithIdentity;
import com.android.build.gradle.internal.tasks.JarsIdentityMapping;
import com.android.build.gradle.internal.tasks.NewIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.tasks.IncrementalChangesUtils;
import com.android.builder.dexing.DexerTool;
import com.android.builder.files.SerializableChange;
import com.android.builder.files.SerializableFileChanges;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;

@CacheableTask
public abstract class JacocoTask
extends NewIncrementalTask {
    private static final Pattern CLASS_PATTERN = Pattern.compile(".*\\.class$");
    private static final Pattern KOTLIN_MODULE_PATTERN = Pattern.compile("^META-INF/.*\\.kotlin_module$");

    @Classpath
    public abstract ConfigurableFileCollection getJacocoAntTaskConfiguration();

    @Nested
    public abstract JarsClasspathInputsWithIdentity getJarsWithIdentity();

    @Incremental
    @Classpath
    public abstract ConfigurableFileCollection getClassesDir();

    @Input
    public abstract Property<Boolean> getForceOutOfProcess();

    @OutputDirectory
    public abstract DirectoryProperty getOutputForDirs();

    @OutputDirectory
    public abstract DirectoryProperty getOutputForJars();

    public static String getJacocoVersion(ComponentCreationConfig creationConfig) {
        if (creationConfig.getVariantScope().getDexer() == DexerTool.DX) {
            return "0.7.4.201502262128";
        }
        return creationConfig.getGlobalScope().getExtension().getJacoco().getVersion();
    }

    @Override
    public void doTaskAction(InputChanges inputChanges) {
        this.processDirectories(inputChanges);
        this.processJars(inputChanges);
    }

    private void processDirectories(InputChanges inputChanges) {
        SerializableFileChanges changes = IncrementalChangesUtils.toSerializable(inputChanges.getFileChanges((FileCollection)this.getClassesDir()));
        HashSet<Object> filesToProcess = new HashSet<Object>(changes.getAddedFiles());
        for (SerializableChange removedFile : changes.getRemovedFiles()) {
            this.removeFile(removedFile);
        }
        for (Object modifiedFile : changes.getModifiedFiles()) {
            this.removeFile((SerializableChange)modifiedFile);
            filesToProcess.add(modifiedFile);
        }
        EnumMap<Action, List> toProcess = new EnumMap<Action, List>(Action.class);
        for (SerializableChange serializableChange : filesToProcess) {
            Action action = JacocoTask.calculateAction(serializableChange.getNormalizedPath());
            if (action == Action.IGNORE) continue;
            List byAction = toProcess.getOrDefault((Object)action, new ArrayList());
            byAction.add(serializableChange);
            toProcess.put(action, byAction);
        }
        WorkQueue workQueue = this.getWorkQueue();
        workQueue.submit(InstrumentDirAction.class, params -> {
            params.getChangesToProcess().set(toProcess);
            params.getOutput().set(this.getOutputForDirs().getAsFile());
        });
    }

    private void processJars(InputChanges inputChanges) {
        JarsIdentityMapping mappingState = this.getJarsWithIdentity().getMappingState(inputChanges);
        if (mappingState.getReprocessAll()) {
            try {
                FileUtils.deleteDirectoryContents((File)((Directory)this.getOutputForJars().get()).getAsFile());
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        for (Map.Entry<File, FileInfo> fileToInfo : mappingState.getJarsInfo().entrySet()) {
            FileInfo fileInfo = fileToInfo.getValue();
            if (!fileInfo.getHasChanged()) continue;
            File instrumentedJar = JacocoTask.getCorrespondingInstrumentedJar(((Directory)this.getOutputForJars().get()).getAsFile(), Objects.requireNonNull(fileInfo.getIdentity()));
            try {
                FileUtils.deleteIfExists((File)instrumentedJar);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            WorkQueue workQueue = this.getWorkQueue();
            File outputJarsFolder = (File)this.getOutputForJars().getAsFile().get();
            workQueue.submit(InstrumentJarAction.class, params -> {
                params.getRoot().set(fileToInfo.getKey());
                params.getOutput().set((Object)instrumentedJar);
            });
        }
    }

    private void removeFile(SerializableChange fileToRemove) {
        Action action = JacocoTask.calculateAction(fileToRemove.getNormalizedPath());
        if (action == Action.IGNORE) {
            return;
        }
        Path outputPath = ((Directory)this.getOutputForDirs().get()).getAsFile().toPath().resolve(fileToRemove.getNormalizedPath());
        try {
            PathUtils.deleteRecursivelyIfExists((Path)outputPath);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private WorkQueue getWorkQueue() {
        if (((Boolean)this.getForceOutOfProcess().get()).booleanValue()) {
            return this.getWorkerExecutor().processIsolation(spec -> spec.getClasspath().from(new Object[]{this.getJacocoAntTaskConfiguration()}));
        }
        return this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getJacocoAntTaskConfiguration()}));
    }

    private static Action calculateAction(String inputRelativePath) {
        for (Pattern pattern : Action.COPY.getPatterns()) {
            if (!pattern.matcher(inputRelativePath).matches()) continue;
            return Action.COPY;
        }
        for (Pattern pattern : Action.INSTRUMENT.getPatterns()) {
            if (!pattern.matcher(inputRelativePath).matches()) continue;
            return Action.INSTRUMENT;
        }
        return Action.IGNORE;
    }

    private static File getCorrespondingInstrumentedJar(File outputFolder, String identity) {
        return new File(outputFolder, identity + ".jar");
    }

    static /* synthetic */ Pattern access$000() {
        return KOTLIN_MODULE_PATTERN;
    }

    static /* synthetic */ Pattern access$100() {
        return CLASS_PATTERN;
    }

    public static class CreationAction
    extends VariantTaskCreationAction<JacocoTask, VariantCreationConfig> {
        public CreationAction(VariantCreationConfig creationConfig) {
            super(creationConfig);
        }

        @Override
        public String getName() {
            return this.computeTaskName("jacoco");
        }

        @Override
        public Class<JacocoTask> getType() {
            return JacocoTask.class;
        }

        @Override
        public void handleProvider(TaskProvider<JacocoTask> taskProvider) {
            super.handleProvider(taskProvider);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, JacocoTask::getOutputForDirs).withName("out").on(InternalArtifactType.JACOCO_INSTRUMENTED_CLASSES.INSTANCE);
            ((VariantCreationConfig)this.creationConfig).getArtifacts().setInitialProvider(taskProvider, JacocoTask::getOutputForJars).withName("out").on(InternalArtifactType.JACOCO_INSTRUMENTED_JARS.INSTANCE);
        }

        @Override
        public void configure(JacocoTask task) {
            super.configure(task);
            task.getJarsWithIdentity().getInputJars().from(new Object[]{((VariantCreationConfig)this.creationConfig).getArtifacts().getAllClasses().filter((Spec)new FilterJarsOnly())});
            task.getClassesDir().from(new Object[]{((VariantCreationConfig)this.creationConfig).getArtifacts().getAllClasses().filter((Spec)new FilterNonJarsOnly())});
            task.getJacocoAntTaskConfiguration().from(new Object[]{JacocoConfigurations.getJacocoAntTaskConfiguration(task.getProject(), JacocoTask.getJacocoVersion(this.creationConfig))});
            task.getForceOutOfProcess().set((Object)((VariantCreationConfig)this.creationConfig).getServices().getProjectOptions().get(BooleanOption.FORCE_JACOCO_OUT_OF_PROCESS));
        }

        static class FilterNonJarsOnly
        implements Spec<File> {
            FilterNonJarsOnly() {
            }

            public boolean isSatisfiedBy(File file) {
                return !file.getName().endsWith(".jar");
            }
        }

        static class FilterJarsOnly
        implements Spec<File> {
            FilterJarsOnly() {
            }

            public boolean isSatisfiedBy(File file) {
                return file.getName().endsWith(".jar");
            }
        }
    }

    public static abstract class InstrumentJarAction
    implements WorkAction<Parameters> {
        private static final LoggerWrapper logger = LoggerWrapper.getLogger(InstrumentJarAction.class);

        public void execute() {
            File inputJar = (File)((Parameters)this.getParameters()).getRoot().get();
            logger.info("Instrumenting jar: " + inputJar.getAbsolutePath(), new Object[0]);
            File instrumentedJar = (File)((Parameters)this.getParameters()).getOutput().get();
            Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
            try (ZipOutputStream outputZip = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(instrumentedJar)));
                 ZipFile zipFile = new ZipFile(inputJar);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    Action entryAction = JacocoTask.calculateAction(entryName);
                    if (entryAction == Action.IGNORE) continue;
                    InputStream classInputStream = zipFile.getInputStream(entry);
                    byte[] data = entryAction == Action.INSTRUMENT ? instrumenter.instrument(classInputStream, entryName) : ByteStreams.toByteArray((InputStream)classInputStream);
                    ZipEntry nextEntry = new ZipEntry(entryName);
                    nextEntry.setTime(-1L);
                    outputZip.putNextEntry(nextEntry);
                    outputZip.write(data);
                    outputZip.closeEntry();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to instrument file with Jacoco: " + inputJar, e);
            }
        }

        public static abstract class Parameters
        implements WorkParameters {
            public abstract Property<File> getRoot();

            public abstract Property<File> getOutput();
        }
    }

    public static abstract class InstrumentDirAction
    implements WorkAction<Parameters> {
        private static final LoggerWrapper logger = LoggerWrapper.getLogger(InstrumentDirAction.class);

        public void execute() {
            Map inputs = (Map)((Parameters)this.getParameters()).getChangesToProcess().get();
            File outputDir = (File)((Parameters)this.getParameters()).getOutput().get();
            Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
            for (SerializableChange toInstrument : (List)inputs.getOrDefault((Object)Action.INSTRUMENT, ImmutableList.of())) {
                logger.info("Instrumenting file: " + toInstrument.getFile().getAbsolutePath(), new Object[0]);
                try {
                    InputStream inputStream = Files.asByteSource((File)toInstrument.getFile()).openBufferedStream();
                    Throwable throwable = null;
                    try {
                        byte[] instrumented = instrumenter.instrument(inputStream, toInstrument.toString());
                        File outputFile = new File(outputDir, toInstrument.getNormalizedPath());
                        Files.createParentDirs((File)outputFile);
                        Files.write((byte[])instrumented, (File)outputFile);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to instrument file with Jacoco: " + toInstrument.getFile(), e);
                }
            }
            for (SerializableChange toCopy : (List)inputs.getOrDefault((Object)Action.COPY, ImmutableList.of())) {
                File outputFile = new File(outputDir, toCopy.getNormalizedPath());
                try {
                    Files.createParentDirs((File)outputFile);
                    Files.copy((File)toCopy.getFile(), (File)outputFile);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to copy file: " + toCopy.getFile(), e);
                }
            }
        }

        public static abstract class Parameters
        implements WorkParameters {
            public abstract MapProperty<Action, List<SerializableChange>> getChangesToProcess();

            public abstract Property<File> getOutput();
        }
    }

    static enum Action {
        COPY(JacocoTask.access$000()),
        IGNORE(new Pattern[0]),
        INSTRUMENT(JacocoTask.access$100());

        private final ImmutableList<Pattern> patterns;

        private Action(Pattern ... patterns) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (Pattern pattern : patterns) {
                Preconditions.checkNotNull((Object)pattern);
                builder.add((Object)pattern);
            }
            this.patterns = builder.build();
        }

        ImmutableList<Pattern> getPatterns() {
            return this.patterns;
        }
    }
}

