/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.external.cmake.server.BuildFiles;
import com.android.build.gradle.external.cmake.server.CmakeInputsResult;
import com.android.build.gradle.external.cmake.server.CodeModel;
import com.android.build.gradle.external.cmake.server.ComputeResult;
import com.android.build.gradle.external.cmake.server.Configuration;
import com.android.build.gradle.external.cmake.server.ConfigureCommandResult;
import com.android.build.gradle.external.cmake.server.FileGroup;
import com.android.build.gradle.external.cmake.server.HandshakeRequest;
import com.android.build.gradle.external.cmake.server.HandshakeResult;
import com.android.build.gradle.external.cmake.server.IncludePath;
import com.android.build.gradle.external.cmake.server.Project;
import com.android.build.gradle.external.cmake.server.ProtocolVersion;
import com.android.build.gradle.external.cmake.server.Server;
import com.android.build.gradle.external.cmake.server.ServerFactory;
import com.android.build.gradle.external.cmake.server.ServerUtils;
import com.android.build.gradle.external.cmake.server.Target;
import com.android.build.gradle.external.cmake.server.receiver.InteractiveMessage;
import com.android.build.gradle.external.cmake.server.receiver.MessageReceiver;
import com.android.build.gradle.external.cmake.server.receiver.ServerReceiver;
import com.android.build.gradle.internal.cxx.cmake.LinkLibrariesParserKt;
import com.android.build.gradle.internal.cxx.cmake.MakeCmakeMessagePathsAbsoluteKt;
import com.android.build.gradle.internal.cxx.configure.CmakeCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.CmakeSourceFileNamingKt;
import com.android.build.gradle.internal.cxx.configure.CommandLineArgument;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.CompilationDatabaseIndexingVisitorKt;
import com.android.build.gradle.internal.cxx.json.CompilationDatabaseToolchain;
import com.android.build.gradle.internal.cxx.json.CompilationDatabaseToolchainVisitorKt;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValue;
import com.android.build.gradle.internal.cxx.json.NativeHeaderFileValue;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValue;
import com.android.build.gradle.internal.cxx.json.NativeSourceFileValue;
import com.android.build.gradle.internal.cxx.json.NativeToolchainValue;
import com.android.build.gradle.internal.cxx.json.StringTable;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.PassThroughPrintWriterLoggingEnvironment;
import com.android.build.gradle.internal.cxx.model.CxxAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxCmakeAbiModel;
import com.android.build.gradle.internal.cxx.model.CxxCmakeAbiModelKt;
import com.android.build.gradle.internal.cxx.model.CxxCmakeModuleModel;
import com.android.build.gradle.internal.cxx.model.CxxVariantModel;
import com.android.build.gradle.internal.cxx.settings.CxxAbiModelCMakeSettingsRewriterKt;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGeneratorUtilsKt;
import com.android.build.gradle.tasks.CmakeServerExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.repository.Revision;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedInts;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import com.google.wireless.android.sdk.stats.GradleNativeAndroidModule;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.gradle.process.ExecOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J(\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0003J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u0006H\u0016R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006/"}, d2={"Lcom/android/build/gradle/tasks/CmakeServerExternalNativeJsonGenerator;", "Lcom/android/build/gradle/tasks/ExternalNativeJsonGenerator;", "variant", "Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;", "abis", "", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "variantBuilder", "Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;", "(Lcom/android/build/gradle/internal/cxx/model/CxxVariantModel;Ljava/util/List;Lcom/google/wireless/android/sdk/stats/GradleBuildVariant$Builder;)V", "cmake", "Lcom/android/build/gradle/internal/cxx/model/CxxCmakeModuleModel;", "getCmake", "()Lcom/android/build/gradle/internal/cxx/model/CxxCmakeModuleModel;", "doHandshake", "", "generator", "", "sourceDirectory", "Ljava/io/File;", "buildDirectory", "cmakeServer", "Lcom/android/build/gradle/external/cmake/server/Server;", "executeProcess", "ops", "Lorg/gradle/process/ExecOperations;", "abi", "executeProcessAndGetOutput", "generateAndroidGradleBuild", "config", "getBuildFiles", "getHandshakeRequest", "Lcom/android/build/gradle/external/cmake/server/HandshakeRequest;", "cmakeServerProtocolVersion", "Lcom/android/build/gradle/external/cmake/server/ProtocolVersion;", "getNativeBuildConfigValue", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValue;", "getNativeLibraryValue", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValue;", "workingDirectory", "target", "Lcom/android/build/gradle/external/cmake/server/Target;", "strings", "Lcom/android/build/gradle/internal/cxx/json/StringTable;", "getProcessBuilder", "Lcom/android/ide/common/process/ProcessInfoBuilder;", "Companion", "gradle-core"})
public final class CmakeServerExternalNativeJsonGenerator
extends ExternalNativeJsonGenerator {
    private static final String CMAKE_SERVER_LOG_PREFIX = "CMAKE SERVER: ";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final CxxCmakeModuleModel getCmake() {
        CxxCmakeModuleModel cxxCmakeModuleModel = this.getVariant().getModule().getCmake();
        if (cxxCmakeModuleModel == null) {
            Intrinsics.throwNpe();
        }
        return cxxCmakeModuleModel;
    }

    @Override
    public void executeProcess(@NotNull ExecOperations ops2, @NotNull CxxAbiModel abi) {
        Intrinsics.checkParameterIsNotNull((Object)ops2, (String)"ops");
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        this.executeProcessAndGetOutput(abi);
    }

    @Override
    @NotNull
    public ProcessInfoBuilder getProcessBuilder(@NotNull CxxAbiModel abi) {
        Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        File file = this.getCmake().getCmakeExe();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        builder.setExecutable(file);
        boolean bl = false;
        List arguments = new ArrayList();
        arguments.addAll((Collection)CxxAbiModelCMakeSettingsRewriterKt.getFinalCmakeCommandLineArguments(abi));
        builder.addArgs(CmakeCommandLineKt.convertCmakeCommandLineArgumentsToStringList(arguments));
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeProcessAndGetOutput(CxxAbiModel abi) {
        File cmakeServerLogFile;
        CxxCmakeAbiModel cxxCmakeAbiModel = abi.getCmake();
        if (cxxCmakeAbiModel == null) {
            Intrinsics.throwNpe();
        }
        File file = cmakeServerLogFile = cxxCmakeAbiModel.getCmakeServerLogFile().getAbsoluteFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"cmakeServerLogFile");
        file.getParentFile().mkdirs();
        AutoCloseable autoCloseable = new PassThroughPrintWriterLoggingEnvironment(new PrintWriter(cmakeServerLogFile, "UTF-8"), CMAKE_SERVER_LOG_PREFIX);
        boolean bl = false;
        Throwable throwable = null;
        try {
            File cmakeBinFolder;
            Server cmakeServer;
            PassThroughPrintWriterLoggingEnvironment it = (PassThroughPrintWriterLoggingEnvironment)autoCloseable;
            boolean bl2 = false;
            ServerReceiver serverReceiver2 = new ServerReceiver().setMessageReceiver(new MessageReceiver(this, abi){
                final /* synthetic */ CmakeServerExternalNativeJsonGenerator this$0;
                final /* synthetic */ CxxAbiModel $abi$inlined;
                {
                    this.this$0 = cmakeServerExternalNativeJsonGenerator;
                    this.$abi$inlined = cxxAbiModel;
                }

                public final void receive(@NotNull InteractiveMessage message) {
                    Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                    File file = this.this$0.getVariant().getModule().getMakeFile().getParentFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"variant.module.makeFile.parentFile");
                    com.android.build.gradle.tasks.CmakeServerExternalNativeJsonGenerator$Companion.access$logInteractiveMessage(CmakeServerExternalNativeJsonGenerator.Companion, message, file);
                }
            }).setDiagnosticReceiver(executeProcessAndGetOutput.1.serverReceiver.2.INSTANCE);
            File file2 = this.getCmake().getCmakeExe();
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
            if ((cmakeServer = ServerFactory.create(cmakeBinFolder = file2.getParentFile(), serverReceiver2)) == null) {
                Revision revision = CmakeUtils.getVersion(cmakeBinFolder);
                Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"CmakeUtils.getVersion(cmakeBinFolder)");
                Revision actual = revision;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Actual CMake version '%s.%s.%s' did not satisfy requested minimum or default CMake minimum version '%s'. Possibly cmake.dir doesn't match android.externalNativeBuild.cmake.version.";
                Object[] objectArray = new Object[]{actual.getMajor(), actual.getMinor(), actual.getMicro(), this.getCmake().getMinimumCmakeVersion()};
                boolean bl3 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                throw (Throwable)new RuntimeException(string2);
            }
            if (!cmakeServer.connect()) {
                StringBuilder stringBuilder = new StringBuilder().append("Unable to connect to Cmake server located at: ");
                File file3 = cmakeBinFolder;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"cmakeBinFolder");
                throw (Throwable)new RuntimeException(stringBuilder.append(file3.getAbsolutePath()).toString());
            }
            try {
                List<CommandLineArgument> arguments = CxxAbiModelCMakeSettingsRewriterKt.getFinalCmakeCommandLineArguments(abi);
                List<String> cacheArgumentsList = CmakeCommandLineKt.convertCmakeCommandLineArgumentsToStringList(CmakeCommandLineKt.onlyKeepServerArguments(arguments));
                ConfigureCommandResult configureCommandResult = null;
                String string = CmakeCommandLineKt.getGenerator(arguments);
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                File file4 = this.getVariant().getModule().getMakeFile().getParentFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"variant.module.makeFile.parentFile");
                String string3 = CmakeCommandLineKt.getBuildRootFolder(arguments);
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                this.doHandshake(string, file4, new File(string3), cmakeServer);
                Collection $this$toTypedArray$iv = cacheArgumentsList;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] argsArray = stringArray;
                ConfigureCommandResult configureCommandResult2 = cmakeServer.configure(Arrays.copyOf(argsArray, argsArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)configureCommandResult2, (String)"cmakeServer.configure(*argsArray)");
                configureCommandResult = configureCommandResult2;
                if (!ServerUtils.isConfigureResultValid(configureCommandResult.configureResult)) {
                    $this$toTypedArray$iv = StringCompanionObject.INSTANCE;
                    String string4 = "Error configuring CMake server (%s).\r\n%s";
                    Object[] objectArray = new Object[]{cmakeServer.getCmakePath(), configureCommandResult.interactiveMessages};
                    boolean bl4 = false;
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
                    throw (Throwable)new ProcessException(string5);
                }
                ComputeResult computeResult = CmakeServerExternalNativeJsonGenerator.Companion.doCompute(cmakeServer);
                if (!ServerUtils.isComputedResultValid(computeResult)) {
                    throw (Throwable)new ProcessException(StringsKt.trimIndent((String)("\n                    Error computing CMake server result.\n                    " + configureCommandResult.interactiveMessages + "\n                    ")));
                }
                this.generateAndroidGradleBuild(abi, cmakeServer);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                cmakeServer.disconnect();
            }
            return;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void doHandshake(String generator, File sourceDirectory, File buildDirectory, Server cmakeServer) throws IOException {
        List<ProtocolVersion> supportedProtocolVersions = cmakeServer.getSupportedVersion();
        if (supportedProtocolVersions == null || supportedProtocolVersions.isEmpty()) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Gradle does not support the Cmake server version. %s";
            Object[] objectArray = new Object[]{CmakeServerExternalNativeJsonGenerator.Companion.getCmakeInfoString(cmakeServer)};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new RuntimeException(string2);
        }
        ProtocolVersion protocolVersion = supportedProtocolVersions.get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)protocolVersion, (String)"supportedProtocolVersions[0]");
        HandshakeResult handshakeResult = cmakeServer.handshake(this.getHandshakeRequest(generator, sourceDirectory, buildDirectory, protocolVersion));
        Intrinsics.checkExpressionValueIsNotNull((Object)handshakeResult, (String)"cmakeServer.handshake(\n \u2026]\n            )\n        )");
        HandshakeResult handshakeResult2 = handshakeResult;
        if (!ServerUtils.isHandshakeResultValid(handshakeResult2)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Invalid handshake result from Cmake server: \n%s\n%s";
            Object[] objectArray = new Object[]{CmakeUtils.getObjectToString(handshakeResult2), CmakeServerExternalNativeJsonGenerator.Companion.getCmakeInfoString(cmakeServer)};
            boolean bl = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new RuntimeException(string3);
        }
    }

    private final HandshakeRequest getHandshakeRequest(String generator, File sourceDirectory, File buildDirectory, ProtocolVersion cmakeServerProtocolVersion) {
        if (!sourceDirectory.isDirectory()) {
            LoggingEnvironmentKt.errorln("Not a directory: %s", sourceDirectory);
        }
        HandshakeRequest handshakeRequest = new HandshakeRequest();
        handshakeRequest.cookie = "gradle-cmake-cookie";
        handshakeRequest.generator = generator;
        handshakeRequest.protocolVersion = cmakeServerProtocolVersion;
        handshakeRequest.buildDirectory = CmakeServerExternalNativeJsonGenerator.Companion.normalizeFilePath(buildDirectory);
        handshakeRequest.sourceDirectory = CmakeServerExternalNativeJsonGenerator.Companion.normalizeFilePath(sourceDirectory);
        return handshakeRequest;
    }

    private final void generateAndroidGradleBuild(CxxAbiModel config2, Server cmakeServer) throws IOException {
        NativeBuildConfigValue nativeBuildConfigValue = this.getNativeBuildConfigValue(config2, cmakeServer);
        AndroidBuildGradleJsons.writeNativeBuildConfigValueToJsonFile(CxxAbiModelKt.getJsonFile(config2), nativeBuildConfigValue);
    }

    @VisibleForTesting
    private final NativeBuildConfigValue getNativeBuildConfigValue(CxxAbiModel abi, Server cmakeServer) throws IOException {
        String string;
        NativeBuildConfigValue nativeBuildConfigValue = CmakeServerExternalNativeJsonGenerator.Companion.createDefaultNativeBuildConfigValue();
        boolean bl = nativeBuildConfigValue.stringTable != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        Map<Integer, String> map2 = nativeBuildConfigValue.stringTable;
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"nativeBuildConfigValue.stringTable!!");
        StringTable strings = new StringTable(map2);
        bl2 = nativeBuildConfigValue.buildFiles != null;
        bl3 = false;
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl6 = false;
            String string3 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string3));
        }
        Collection<File> collection = nativeBuildConfigValue.buildFiles;
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        collection.addAll((Collection<File>)this.getBuildFiles(cmakeServer));
        bl2 = nativeBuildConfigValue.cleanCommandsComponents != null;
        bl3 = false;
        bl5 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl7 = false;
            String string4 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        List<List<String>> list = nativeBuildConfigValue.cleanCommandsComponents;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        File file = this.getCmake().getCmakeExe();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        list.add(CmakeUtils.getCleanCommand(file, abi.getCxxBuildFolder()));
        bl2 = nativeBuildConfigValue.buildTargetsCommandComponents != null;
        bl3 = false;
        bl5 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl8 = false;
            String string5 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string5));
        }
        File file2 = this.getCmake().getCmakeExe();
        if (file2 == null) {
            Intrinsics.throwNpe();
        }
        nativeBuildConfigValue.buildTargetsCommandComponents = CmakeUtils.getBuildTargetsCommand(file2, abi.getCxxBuildFolder(), CxxAbiModelCMakeSettingsRewriterKt.getBuildCommandArguments(abi));
        CodeModel codeModel = cmakeServer.codemodel();
        Intrinsics.checkExpressionValueIsNotNull((Object)codeModel, (String)"cmakeServer.codemodel()");
        CodeModel codeModel2 = codeModel;
        if (!ServerUtils.isCodeModelValid(codeModel2)) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string6 = "Invalid code model received from Cmake server: \n%s\n%s";
            Object[] objectArray = new Object[]{CmakeUtils.getObjectToString(codeModel2), CmakeServerExternalNativeJsonGenerator.Companion.getCmakeInfoString(cmakeServer)};
            boolean bl9 = false;
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new RuntimeException(string7);
        }
        bl3 = nativeBuildConfigValue.cFileExtensions != null;
        bl5 = false;
        int n = 0;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl10 = false;
            String string8 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string8));
        }
        Collection<String> collection2 = nativeBuildConfigValue.cFileExtensions;
        if (collection2 == null) {
            Intrinsics.throwNpe();
        }
        Set<String> set = CmakeUtils.getCExtensionSet(codeModel2);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"CmakeUtils.getCExtensionSet(codeModel)");
        collection2.addAll((Collection<String>)set);
        bl3 = nativeBuildConfigValue.cppFileExtensions != null;
        bl5 = false;
        n = 0;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl11 = false;
            String string9 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string9));
        }
        Collection<String> collection3 = nativeBuildConfigValue.cppFileExtensions;
        if (collection3 == null) {
            Intrinsics.throwNpe();
        }
        Set<String> set2 = CmakeUtils.getCppExtensionSet(codeModel2);
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"CmakeUtils.getCppExtensionSet(codeModel)");
        collection3.addAll((Collection<String>)set2);
        if (abi.getVariant().getModule().getProject().isV2NativeModelEnabled()) {
            string = null;
        } else {
            Collection<String> collection4 = nativeBuildConfigValue.cppFileExtensions;
            if (collection4 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(collection4, (String)"nativeBuildConfigValue.cppFileExtensions!!");
            Collection<String> collection5 = nativeBuildConfigValue.cFileExtensions;
            if (collection5 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(collection5, (String)"nativeBuildConfigValue.cFileExtensions!!");
            nativeBuildConfigValue.toolchains = CmakeServerExternalNativeJsonGenerator.Companion.getNativeToolchains(abi, cmakeServer, collection4, collection5);
            Map<String, NativeToolchainValue> map3 = nativeBuildConfigValue.toolchains;
            if (map3 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(map3, (String)"nativeBuildConfigValue.toolchains!!");
            string = CmakeServerExternalNativeJsonGenerator.Companion.getOnlyToolchainName(map3);
        }
        String toolchainHashString = string;
        for (Configuration config2 : codeModel2.configurations) {
            for (Project project : config2.projects) {
                Target[] targetArray = project.targets;
                int n2 = targetArray.length;
                for (int j = 0; j < n2; ++j) {
                    Target target;
                    Target target2 = target = targetArray[j];
                    Intrinsics.checkExpressionValueIsNotNull((Object)target2, (String)"target");
                    if (!CmakeServerExternalNativeJsonGenerator.Companion.canAddTargetToNativeLibrary(target2)) continue;
                    NativeLibraryValue nativeLibraryValue = this.getNativeLibraryValue(abi, abi.getCxxBuildFolder(), target, strings);
                    nativeLibraryValue.toolchain = toolchainHashString;
                    String libraryName = target.name + "-" + config2.name + "-" + abi.getAbi().getTag();
                    boolean bl12 = nativeBuildConfigValue.libraries != null;
                    boolean bl13 = false;
                    boolean bl14 = false;
                    if (_Assertions.ENABLED && !bl12) {
                        boolean bl15 = false;
                        String string10 = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string10));
                    }
                    Map<String, NativeLibraryValue> map4 = nativeBuildConfigValue.libraries;
                    if (map4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull(map4, (String)"nativeBuildConfigValue.libraries!!");
                    map4.put(libraryName, nativeLibraryValue);
                }
            }
        }
        return nativeBuildConfigValue;
    }

    @VisibleForTesting
    private final NativeLibraryValue getNativeLibraryValue(CxxAbiModel abi, File workingDirectory, Target target, StringTable strings) throws FileNotFoundException {
        File file = this.getCmake().getCmakeExe();
        if (file == null) {
            Intrinsics.throwNpe();
        }
        File file2 = abi.getCxxBuildFolder();
        boolean bl = this.getVariant().isDebuggableEnabled();
        Function0 function0 = (Function0)new Function0<Reader>(abi){
            final /* synthetic */ CxxAbiModel $abi;

            @NotNull
            public final Reader invoke() {
                CxxCmakeAbiModel cxxCmakeAbiModel = this.$abi.getCmake();
                if (cxxCmakeAbiModel == null) {
                    Intrinsics.throwNpe();
                }
                File file = CxxCmakeAbiModelKt.getCompileCommandsJsonFile(cxxCmakeAbiModel);
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                Charset charset2 = charset;
                boolean bl = false;
                Object object = file;
                boolean bl2 = false;
                object = new FileInputStream((File)object);
                bl2 = false;
                return new InputStreamReader((InputStream)object, charset2);
            }
            {
                this.$abi = cxxAbiModel;
                super(0);
            }
        };
        String string = abi.getAbi().getTag();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"abi.abi.tag");
        return Companion.getNativeLibraryValue(file, file2, bl, (Function0<? extends Reader>)function0, string, workingDirectory, target, strings, abi.getVariant().getModule().getProject().isV2NativeModelEnabled());
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getBuildFiles(Server cmakeServer) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        CmakeInputsResult cmakeInputsResult = cmakeServer.cmakeInputs();
        Intrinsics.checkExpressionValueIsNotNull((Object)cmakeInputsResult, (String)"cmakeServer.cmakeInputs()");
        CmakeInputsResult cmakeInputsResult2 = cmakeInputsResult;
        if (!ServerUtils.isCmakeInputsResultValid(cmakeInputsResult2) || cmakeInputsResult2.buildFiles == null) {
            return CollectionsKt.listOf((Object)this.getVariant().getModule().getMakeFile().getAbsoluteFile());
        }
        String string = cmakeInputsResult2.sourceDirectory;
        if (string == null) {
            File file = this.getVariant().getModule().getMakeFile().getAbsoluteFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"variant.module.makeFile.absoluteFile");
            string = file.getParent();
        }
        File sourceDirectory = new File(string);
        BuildFiles[] buildFilesArray = cmakeInputsResult2.buildFiles;
        Collection collection = CollectionsKt.listOf((Object)this.getVariant().getModule().getMakeFile());
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv;
        int n = ((void)iterator).length;
        for (int j = 0; j < n; ++j) {
            Iterable iterable2;
            void element$iv$iv;
            void buildFiles = element$iv$iv = iterator[j];
            boolean bl = false;
            Object object = buildFiles.sources;
            if (buildFiles.sources != null && (object = ArraysKt.filterNotNull((Object[])object)) != null) {
                iterable2 = (Iterable)object;
            } else {
                boolean bl2 = false;
                iterable2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = iterable2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Object object = (List)destination$iv$iv;
        $this$flatMap$iv = (Iterable)object;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            File file = new File((String)it);
            object.add(file);
        }
        object = (List)destination$iv$iv;
        List files2 = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object));
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            String string3 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.name");
            if (!(StringsKt.compareTo((String)string3, (String)"CMakeLists.txt", (boolean)true) == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            File it = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = FilesKt.resolve((File)sourceDirectory, (File)file).getCanonicalFile();
            collection.add(object);
        }
        Iterable $this$sortedBy$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$sortedBy = false;
        iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                File it = (File)a;
                boolean bl2 = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                it = (File)b;
                Comparable comparable = Integer.valueOf(file.getPath().length());
                bl2 = false;
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                Integer n = file2.getPath().length();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    public CmakeServerExternalNativeJsonGenerator(@NotNull CxxVariantModel variant, @NotNull List<CxxAbiModel> abis, @NotNull GradleBuildVariant.Builder variantBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(abis, (String)"abis");
        Intrinsics.checkParameterIsNotNull((Object)variantBuilder, (String)"variantBuilder");
        super(variant, abis, variantBuilder);
        variantBuilder.setNativeBuildSystemType(GradleNativeAndroidModule.NativeBuildSystemType.CMAKE);
        CmakeExternalNativeJsonGeneratorUtilsKt.cmakeMakefileChecks(variant);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002JV\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0007J@\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u001e\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00040(H\u0002J\u001e\u0010*\u001a\u0004\u0018\u00010\u00042\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020%0$H\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0014H\u0002J\u0010\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/build/gradle/tasks/CmakeServerExternalNativeJsonGenerator$Companion;", "", "()V", "CMAKE_SERVER_LOG_PREFIX", "", "canAddTargetToNativeLibrary", "", "target", "Lcom/android/build/gradle/external/cmake/server/Target;", "compileFlagsFromFileGroup", "fileGroup", "Lcom/android/build/gradle/external/cmake/server/FileGroup;", "createDefaultNativeBuildConfigValue", "Lcom/android/build/gradle/internal/cxx/json/NativeBuildConfigValue;", "doCompute", "Lcom/android/build/gradle/external/cmake/server/ComputeResult;", "cmakeServer", "Lcom/android/build/gradle/external/cmake/server/Server;", "findRuntimeFiles", "", "Ljava/io/File;", "getCmakeInfoString", "getNativeLibraryValue", "Lcom/android/build/gradle/internal/cxx/json/NativeLibraryValue;", "cmakeExecutable", "outputFolder", "isDebuggable", "compileCommandsJsonReader", "Lkotlin/Function0;", "Ljava/io/Reader;", "abi", "workingDirectory", "strings", "Lcom/android/build/gradle/internal/cxx/json/StringTable;", "isV2NativeModelEnabled", "getNativeToolchains", "", "Lcom/android/build/gradle/internal/cxx/json/NativeToolchainValue;", "Lcom/android/build/gradle/internal/cxx/model/CxxAbiModel;", "cppExtensionSet", "", "cExtensionSet", "getOnlyToolchainName", "toolchains", "logInteractiveMessage", "", "message", "Lcom/android/build/gradle/external/cmake/server/receiver/InteractiveMessage;", "makeFileDirectory", "normalizeFilePath", "file", "gradle-core"})
    public static final class Companion {
        private final String getOnlyToolchainName(Map<String, ? extends NativeToolchainValue> toolchains) {
            if (toolchains.size() != 1) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Invalid number %d of toolchains. Only one toolchain should be present.";
                Object[] objectArray = new Object[]{toolchains.size()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                throw (Throwable)new RuntimeException(string2);
            }
            return toolchains.keySet().iterator().next();
        }

        private final String getCmakeInfoString(Server cmakeServer) throws IOException {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Cmake path: %s, version: %s";
            Object[] objectArray = new Object[]{cmakeServer.getCmakePath(), CmakeUtils.getVersion(new File(cmakeServer.getCmakePath())).toString()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private final void logInteractiveMessage(InteractiveMessage message, File makeFileDirectory) {
            String correctedMessage;
            block10: {
                block9: {
                    String cmakeWarningPrefix;
                    block8: {
                        block7: {
                            String cmakeErrorPrefix = "CMake Error";
                            cmakeWarningPrefix = "CMake Warning";
                            if (message.type != null && Intrinsics.areEqual((Object)message.type, (Object)"error")) {
                                String string = message.errorMessage;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.errorMessage");
                                LoggingEnvironmentKt.errorln(MakeCmakeMessagePathsAbsoluteKt.makeCmakeMessagePathsAbsolute(string, makeFileDirectory), new Object[0]);
                                return;
                            }
                            String string = message.message;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.message");
                            correctedMessage = MakeCmakeMessagePathsAbsoluteKt.makeCmakeMessagePathsAbsolute(string, makeFileDirectory);
                            if (message.title != null && Intrinsics.areEqual((Object)message.title, (Object)"Error")) break block7;
                            String string2 = message.message;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"message.message");
                            if (!StringsKt.startsWith$default((String)string2, (String)cmakeErrorPrefix, (boolean)false, (int)2, null)) break block8;
                        }
                        LoggingEnvironmentKt.errorln(correctedMessage, new Object[0]);
                        return;
                    }
                    if (message.title != null && Intrinsics.areEqual((Object)message.title, (Object)"Warning")) break block9;
                    String string = message.message;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.message");
                    if (!StringsKt.startsWith$default((String)string, (String)cmakeWarningPrefix, (boolean)false, (int)2, null)) break block10;
                }
                LoggingEnvironmentKt.warnln(correctedMessage, new Object[0]);
                return;
            }
            LoggingEnvironmentKt.infoln(correctedMessage, new Object[0]);
        }

        private final ComputeResult doCompute(Server cmakeServer) throws IOException {
            ComputeResult computeResult = cmakeServer.compute();
            Intrinsics.checkExpressionValueIsNotNull((Object)computeResult, (String)"cmakeServer.compute()");
            return computeResult;
        }

        private final List<File> findRuntimeFiles(Target target) {
            if (target.linkLibraries == null || Intrinsics.areEqual((Object)target.type, (Object)"OBJECT_LIBRARY")) {
                return null;
            }
            Path sysroot = Paths.get(target.sysroot, new String[0]);
            boolean bl = false;
            List runtimeFiles = new ArrayList();
            for (String library : LinkLibrariesParserKt.parseLinkLibraries(target.linkLibraries)) {
                if (StringsKt.startsWith$default((String)library, (String)"-", (boolean)false, (int)2, null)) continue;
                Path path = Paths.get(library, new String[0]);
                boolean bl2 = false;
                boolean bl3 = false;
                Path it = path;
                boolean bl4 = false;
                Path path2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"it");
                Path libraryPath = (!path2.isAbsolute() ? Paths.get(target.buildDirectory, new String[0]).resolve(it) : it).normalize();
                if (libraryPath.startsWith(sysroot)) continue;
                Path path3 = libraryPath;
                Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"libraryPath");
                PathMatcher pathMatcher = path3.getFileSystem().getPathMatcher("glob:*.a");
                if (pathMatcher.matches(libraryPath.getFileName())) continue;
                File file = libraryPath.toFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"libraryPath.toFile()");
                runtimeFiles.add(file);
            }
            return runtimeFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        @NotNull
        public final NativeLibraryValue getNativeLibraryValue(@NotNull File cmakeExecutable, @NotNull File outputFolder, boolean isDebuggable, @NotNull Function0<? extends Reader> compileCommandsJsonReader, @NotNull String abi, @NotNull File workingDirectory, @NotNull Target target, @NotNull StringTable strings, boolean isV2NativeModelEnabled) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)cmakeExecutable, (String)"cmakeExecutable");
            Intrinsics.checkParameterIsNotNull((Object)outputFolder, (String)"outputFolder");
            Intrinsics.checkParameterIsNotNull(compileCommandsJsonReader, (String)"compileCommandsJsonReader");
            Intrinsics.checkParameterIsNotNull((Object)abi, (String)"abi");
            Intrinsics.checkParameterIsNotNull((Object)workingDirectory, (String)"workingDirectory");
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            Intrinsics.checkParameterIsNotNull((Object)strings, (String)"strings");
            NativeLibraryValue nativeLibraryValue = new NativeLibraryValue();
            nativeLibraryValue.abi = abi;
            nativeLibraryValue.buildCommandComponents = CmakeUtils.getBuildCommand(cmakeExecutable, outputFolder, target.name);
            nativeLibraryValue.artifactName = target.name;
            String string = nativeLibraryValue.buildType = isDebuggable ? "debug" : "release";
            if (Intrinsics.areEqual((Object)"OBJECT_LIBRARY", (Object)target.type) ^ true && target.artifacts != null) {
                String[] stringArray = target.artifacts;
                boolean bl2 = false;
                String[] stringArray2 = stringArray;
                bl = false;
                if (!(stringArray2.length == 0)) {
                    nativeLibraryValue.output = new File(target.artifacts[0]);
                }
            }
            nativeLibraryValue.runtimeFiles = this.findRuntimeFiles(target);
            if (isV2NativeModelEnabled) {
                return nativeLibraryValue;
            }
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"Maps.newHashMap()");
            Map<String, Integer> compilationDatabaseFlags = hashMap;
            int workingDirectoryOrdinal = strings.intern(this.normalizeFilePath(workingDirectory));
            bl = false;
            List files2 = new ArrayList();
            boolean bl3 = false;
            List headers = new ArrayList();
            Closeable closeable = (Closeable)new JsonReader((Reader)compileCommandsJsonReader.invoke());
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                JsonReader compileCommandsJson = (JsonReader)closeable;
                boolean bl5 = false;
                FileGroup[] $this$orEmpty$iv = target.fileGroups;
                boolean $i$f$orEmpty = false;
                FileGroup[] fileGroupArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    fileGroupArray = new FileGroup[]{};
                }
                for (FileGroup fileGroup : fileGroupArray) {
                    String[] stringArray = fileGroup.sources;
                    int n = stringArray.length;
                    for (int j = 0; j < n; ++j) {
                        File sourceFile;
                        Path sourceFilePath;
                        String source;
                        String string2 = source = stringArray[j];
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"source");
                        if (StringsKt.endsWith$default((String)string2, (String)".o", (boolean)false, (int)2, null)) continue;
                        Path path = sourceFilePath = Paths.get(source, new String[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"sourceFilePath");
                        if (!path.isAbsolute()) {
                            sourceFilePath = Paths.get(target.sourceDirectory, source);
                        }
                        Path normalizedSourceFilePath = sourceFilePath.normalize();
                        CharSequence charSequence = ((Object)normalizedSourceFilePath).toString();
                        boolean bl6 = false;
                        if (charSequence.length() > 0) {
                            sourceFilePath = normalizedSourceFilePath;
                        }
                        File file = sourceFile = sourceFilePath.toFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"sourceFile");
                        if (CmakeSourceFileNamingKt.hasCmakeHeaderFileExtensions(file)) {
                            headers.add(new NativeHeaderFileValue(sourceFile, workingDirectoryOrdinal));
                            continue;
                        }
                        NativeSourceFileValue nativeSourceFileValue = new NativeSourceFileValue();
                        nativeSourceFileValue.workingDirectoryOrdinal = workingDirectoryOrdinal;
                        nativeSourceFileValue.src = sourceFile;
                        if (compilationDatabaseFlags.isEmpty()) {
                            compilationDatabaseFlags = CompilationDatabaseIndexingVisitorKt.indexCompilationDatabase(compileCommandsJson, strings);
                        }
                        if (compilationDatabaseFlags.containsKey(((Object)sourceFilePath).toString())) {
                            nativeSourceFileValue.flagsOrdinal = compilationDatabaseFlags.get(((Object)sourceFilePath).toString());
                        } else {
                            FileGroup fileGroup2 = fileGroup;
                            Intrinsics.checkExpressionValueIsNotNull((Object)fileGroup2, (String)"fileGroup");
                            String compileFlags = Companion.compileFlagsFromFileGroup(fileGroup2);
                            if (!Strings.isNullOrEmpty((String)compileFlags)) {
                                nativeSourceFileValue.flagsOrdinal = strings.intern(compileFlags);
                            }
                        }
                        files2.add(nativeSourceFileValue);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            nativeLibraryValue.files = files2;
            nativeLibraryValue.headers = headers;
            return nativeLibraryValue;
        }

        private final String compileFlagsFromFileGroup(FileGroup fileGroup) {
            StringBuilder flags = new StringBuilder();
            flags.append(fileGroup.compileFlags);
            if (fileGroup.defines != null) {
                for (String define : fileGroup.defines) {
                    flags.append(" -D").append(define);
                }
            }
            if (fileGroup.includePath != null) {
                Object[] objectArray = fileGroup.includePath;
                int n = objectArray.length;
                for (int j = 0; j < n; ++j) {
                    Object includePath;
                    Object object = includePath = objectArray[j];
                    if ((object != null ? ((IncludePath)object).path : null) == null) continue;
                    if (((IncludePath)includePath).isSystem != null && ((IncludePath)includePath).isSystem.booleanValue()) {
                        flags.append(" -system ");
                    } else {
                        flags.append(" -I ");
                    }
                    flags.append(((IncludePath)includePath).path);
                }
            }
            String string = flags.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"flags.toString()");
            return string;
        }

        private final boolean canAddTargetToNativeLibrary(Target target) {
            return target.artifacts != null || target.fileGroups != null;
        }

        private final NativeBuildConfigValue createDefaultNativeBuildConfigValue() {
            NativeBuildConfigValue nativeBuildConfigValue = new NativeBuildConfigValue();
            nativeBuildConfigValue.buildFiles = new ArrayList();
            nativeBuildConfigValue.cleanCommandsComponents = new ArrayList();
            nativeBuildConfigValue.libraries = new HashMap();
            nativeBuildConfigValue.toolchains = new HashMap();
            nativeBuildConfigValue.cFileExtensions = new ArrayList();
            nativeBuildConfigValue.cppFileExtensions = new ArrayList();
            nativeBuildConfigValue.stringTable = Maps.newHashMap();
            return nativeBuildConfigValue;
        }

        private final Map<String, NativeToolchainValue> getNativeToolchains(CxxAbiModel abi, Server cmakeServer, Collection<String> cppExtensionSet, Collection<String> cExtensionSet) {
            CharSequence cppCompilerExecutable1;
            File compilationDatabase;
            NativeToolchainValue toolchainValue = new NativeToolchainValue();
            File cCompilerExecutable = null;
            Object cppCompilerExecutable = null;
            CxxCmakeAbiModel cxxCmakeAbiModel = abi.getCmake();
            if (cxxCmakeAbiModel == null) {
                Intrinsics.throwNpe();
            }
            if ((compilationDatabase = CxxCmakeAbiModelKt.getCompileCommandsJsonFile(cxxCmakeAbiModel)).exists()) {
                CompilationDatabaseToolchain compilationDatabaseToolchain = CompilationDatabaseToolchainVisitorKt.populateCompilationDatabaseToolchains(compilationDatabase, cppExtensionSet, cExtensionSet);
                File file = compilationDatabaseToolchain.component1();
                File cCompilerExecutable1 = compilationDatabaseToolchain.component2();
                cppCompilerExecutable = cppCompilerExecutable1;
                cCompilerExecutable = cCompilerExecutable1;
            } else {
                String string = cmakeServer.getCCompilerExecutable();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cmakeServer.cCompilerExecutable");
                cppCompilerExecutable1 = string;
                boolean cCompilerExecutable1 = false;
                if (cppCompilerExecutable1.length() > 0) {
                    cCompilerExecutable = new File(cmakeServer.getCCompilerExecutable());
                }
                String string2 = cmakeServer.getCppCompilerExecutable();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"cmakeServer.cppCompilerExecutable");
                cppCompilerExecutable1 = string2;
                cCompilerExecutable1 = false;
                if (cppCompilerExecutable1.length() > 0) {
                    cppCompilerExecutable = new File(cmakeServer.getCppCompilerExecutable());
                }
            }
            if (cCompilerExecutable != null) {
                toolchainValue.cCompilerExecutable = cCompilerExecutable;
            }
            if (cppCompilerExecutable != null) {
                toolchainValue.cppCompilerExecutable = cppCompilerExecutable;
            }
            int toolchainHash = CmakeUtils.getToolchainHash(toolchainValue);
            String toolchainHashString = UnsignedInts.toString((int)toolchainHash);
            Map toolchains = new HashMap();
            String string = toolchainHashString;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toolchainHashString");
            toolchains.put(string, toolchainValue);
            return toolchains;
        }

        private final String normalizeFilePath(File file) {
            String string;
            if (ExternalNativeJsonGenerator.Companion.isWindows()) {
                String string2 = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.path");
                string = StringsKt.replace$default((String)string2, (String)"\\", (String)"/", (boolean)false, (int)4, null);
            } else {
                String string3 = file.getPath();
                string = string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.path");
            }
            return string;
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$logInteractiveMessage(Companion $this, InteractiveMessage message, File makeFileDirectory) {
            $this.logInteractiveMessage(message, makeFileDirectory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

