/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.manifest;

import com.android.build.gradle.internal.manifest.ManifestData;
import com.android.builder.errors.IssueReporter;
import com.android.utils.XmlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u001a&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"PARSER_FACTORY", "Ljavax/xml/parsers/SAXParserFactory;", "kotlin.jvm.PlatformType", "parseManifest", "Lcom/android/build/gradle/internal/manifest/ManifestData;", "file", "Ljava/io/File;", "manifestFileRequired", "", "manifestParsingAllowed", "Ljava/util/function/BooleanSupplier;", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "toAndroidTarget", "Lcom/android/build/gradle/internal/manifest/ManifestData$AndroidTarget;", "", "gradle-core"})
public final class ManifestDataKt {
    private static final SAXParserFactory PARSER_FACTORY;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ManifestData parseManifest(@NotNull File file, boolean manifestFileRequired, @NotNull BooleanSupplier manifestParsingAllowed, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manifestParsingAllowed, (String)"manifestParsingAllowed");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter2, (String)"issueReporter");
        if (!manifestParsingAllowed.getAsBoolean()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv;
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
            Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"Thread.currentThread().stackTrace");
            Object $this$map$iv = stackTraceElementArray;
            boolean $i$f$map = false;
            StackTraceElement[] stackTraceElementArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((StackTraceElement[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv;
            int n = ((void)iterator).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var14_18 = item$iv$iv = iterator[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.toString();
                collection.add(string);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                if (!(!StringsKt.startsWith$default((String)string, (String)"com.android.build.gradle.internal.manifest.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)it, (String)"org.gradle.", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List stackTrace = ((List)destination$iv$iv).subList(1, 10);
            String stackTraceString = CollectionsKt.joinToString$default((Iterable)stackTrace, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            IssueReporter.reportWarning$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.MANIFEST_PARSED_DURING_CONFIGURATION, (String)("The manifest is being parsed during configuration. Please either remove android.disableConfigurationManifestParsing from build.gradle or remove any build configuration rules that read the android manifest file.\n" + stackTraceString), null, null, (int)12, null);
        }
        ManifestData data = new ManifestData(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null);
        if (!file.exists()) {
            if (manifestFileRequired) {
                IssueReporter.reportError$default((IssueReporter)issueReporter2, (IssueReporter.Type)IssueReporter.Type.MISSING_ANDROID_MANIFEST, (String)("Manifest file does not exist: " + file.getAbsolutePath()), null, null, (int)12, null);
                data.setPackageName("fake.package.name.for.sync");
            }
            return data;
        }
        DefaultHandler handler2 = new DefaultHandler(data){
            final /* synthetic */ ManifestData $data;

            public void startElement(@Nullable String uri, @NotNull String localName, @NotNull String qName, @NotNull Attributes attributes2) throws SAXException {
                block10: {
                    Boolean bl;
                    Boolean bl2;
                    boolean bl3;
                    CharSequence charSequence;
                    block13: {
                        block12: {
                            Boolean bl4;
                            Boolean bl5;
                            block11: {
                                Integer n;
                                Intrinsics.checkParameterIsNotNull((Object)localName, (String)"localName");
                                Intrinsics.checkParameterIsNotNull((Object)qName, (String)"qName");
                                Intrinsics.checkParameterIsNotNull((Object)attributes2, (String)"attributes");
                                charSequence = uri;
                                bl3 = false;
                                boolean bl6 = false;
                                if (!(charSequence == null || charSequence.length() == 0)) break block10;
                                if (!Intrinsics.areEqual((Object)"manifest", (Object)localName)) break block11;
                                this.$data.setSplit(attributes2.getValue("", "split"));
                                this.$data.setPackageName(attributes2.getValue("", "package"));
                                String string = attributes2.getValue("http://schemas.android.com/apk/res/android", "versionCode");
                                if (string != null) {
                                    charSequence = string;
                                    bl3 = false;
                                    n = Integer.parseInt((String)charSequence);
                                } else {
                                    n = null;
                                }
                                this.$data.setVersionCode(n);
                                this.$data.setVersionName(attributes2.getValue("http://schemas.android.com/apk/res/android", "versionName"));
                                break block10;
                            }
                            if (!Intrinsics.areEqual((Object)"instrumentation", (Object)localName)) break block12;
                            this.$data.setTestLabel(attributes2.getValue("http://schemas.android.com/apk/res/android", "label"));
                            String string = attributes2.getValue("http://schemas.android.com/apk/res/android", "functionalTest");
                            if (string != null) {
                                charSequence = string;
                                bl3 = false;
                                bl5 = Boolean.parseBoolean((String)charSequence);
                            } else {
                                bl5 = null;
                            }
                            this.$data.setFunctionalTest(bl5);
                            this.$data.setInstrumentationRunner(attributes2.getValue("http://schemas.android.com/apk/res/android", "name"));
                            String string2 = attributes2.getValue("http://schemas.android.com/apk/res/android", "handleProfiling");
                            if (string2 != null) {
                                charSequence = string2;
                                bl3 = false;
                                bl4 = Boolean.parseBoolean((String)charSequence);
                            } else {
                                bl4 = null;
                            }
                            this.$data.setHandleProfiling(bl4);
                            break block10;
                        }
                        if (!Intrinsics.areEqual((Object)"uses-sdk", (Object)localName)) break block13;
                        String string = attributes2.getValue("http://schemas.android.com/apk/res/android", "minSdkVersion");
                        this.$data.setMinSdkVersion(string != null ? ManifestDataKt.access$toAndroidTarget(string) : null);
                        String string3 = attributes2.getValue("http://schemas.android.com/apk/res/android", "targetSdkVersion");
                        this.$data.setTargetSdkVersion(string3 != null ? ManifestDataKt.access$toAndroidTarget(string3) : null);
                        break block10;
                    }
                    if (!Intrinsics.areEqual((Object)"application", (Object)localName)) break block10;
                    String string = attributes2.getValue("http://schemas.android.com/apk/res/android", "extractNativeLibs");
                    if (string != null) {
                        charSequence = string;
                        bl3 = false;
                        bl2 = Boolean.parseBoolean((String)charSequence);
                    } else {
                        bl2 = null;
                    }
                    this.$data.setExtractNativeLibs(bl2);
                    String string4 = attributes2.getValue("http://schemas.android.com/apk/res/android", "useEmbeddedDex");
                    if (string4 != null) {
                        charSequence = string4;
                        bl3 = false;
                        bl = Boolean.parseBoolean((String)charSequence);
                    } else {
                        bl = null;
                    }
                    this.$data.setUseEmbeddedDex(bl);
                }
            }
            {
                this.$data = $captured_local_variable$0;
            }
        };
        try {
            SAXParser saxParser = XmlUtils.createSaxParser((SAXParserFactory)PARSER_FACTORY);
            saxParser.parse(file, handler2);
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
        return data;
    }

    private static final ManifestData.AndroidTarget toAndroidTarget(String $this$toAndroidTarget) {
        ManifestData.AndroidTarget androidTarget;
        try {
            Integer apiLevel = Integer.valueOf($this$toAndroidTarget);
            androidTarget = new ManifestData.AndroidTarget(apiLevel, null);
        }
        catch (NumberFormatException ignored) {
            androidTarget = new ManifestData.AndroidTarget(null, $this$toAndroidTarget);
        }
        return androidTarget;
    }

    static {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        boolean bl = false;
        boolean bl2 = false;
        SAXParserFactory it = sAXParserFactory;
        boolean bl3 = false;
        XmlUtils.configureSaxFactory((SAXParserFactory)it, (boolean)true, (boolean)false);
        PARSER_FACTORY = sAXParserFactory;
    }

    public static final /* synthetic */ ManifestData.AndroidTarget access$toAndroidTarget(String $this$access_u24toAndroidTarget) {
        return ManifestDataKt.toAndroidTarget($this$access_u24toAndroidTarget);
    }
}

