/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.plugins;

import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.build.gradle.internal.dsl.DslVariableFactory;
import com.android.build.gradle.internal.dsl.TestOptions;
import com.android.build.gradle.internal.errors.DeprecationReporterImpl;
import com.android.build.gradle.internal.errors.SyncIssueReporterImpl;
import com.android.build.gradle.internal.services.DslServicesImpl;
import com.android.build.gradle.internal.services.ProjectServices;
import com.android.build.gradle.internal.tasks.AndroidReportTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.options.ProjectOptionService;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.utils.FileUtils;
import java.io.File;
import kotlin.jvm.functions.Function1;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;

class ReportingPlugin
implements Plugin<Project> {
    private TestOptions extension;

    public void apply(Project project) {
        project.evaluationDependsOnChildren();
        ProjectOptions projectOptions = ((ProjectOptionService)new ProjectOptionService.RegistrationAction(project).execute().get()).getProjectOptions();
        SyncIssueReporterImpl syncIssueHandler = new SyncIssueReporterImpl(SyncOptions.getModelQueryMode(projectOptions), project.getLogger());
        DeprecationReporterImpl deprecationReporter = new DeprecationReporterImpl(syncIssueHandler, projectOptions, project.getPath());
        ProjectServices projectServices = new ProjectServices(syncIssueHandler, deprecationReporter, project.getObjects(), project.getLogger(), project.getProviders(), project.getLayout(), projectOptions, project.getGradle().getSharedServices(), null, project.getGradle().getStartParameter().getMaxWorkerCount(), (Function1<Object, ? extends File>)((Function1)arg_0 -> ((Project)project).file(arg_0)));
        DslServicesImpl dslServices = new DslServicesImpl(projectServices, new DslVariableFactory(syncIssueHandler), (Provider<SdkComponentsBuildService>)project.getProviders().provider(() -> null));
        this.extension = (TestOptions)project.getExtensions().create("android", TestOptions.class, new Object[]{dslServices});
        AndroidReportTask mergeReportsTask = (AndroidReportTask)project.getTasks().create("mergeAndroidReports", AndroidReportTask.class);
        mergeReportsTask.setGroup("verification");
        mergeReportsTask.setDescription("Merges all the Android test reports from the sub projects.");
        mergeReportsTask.setReportType(ReportType.MULTI_PROJECT);
        mergeReportsTask.getResultsDir().set(project.provider(() -> {
            String resultsDir = this.extension.getResultsDir();
            if (resultsDir == null) {
                return (Directory)project.getLayout().getBuildDirectory().dir("androidTest-results").get();
            }
            return project.getLayout().getProjectDirectory().dir(resultsDir);
        }));
        mergeReportsTask.getReportsDir().set(project.provider(() -> {
            String reportsDir = this.extension.getReportDir();
            if (reportsDir == null) {
                return (Directory)project.getLayout().getBuildDirectory().dir(FileUtils.join((String[])new String[]{"reports", "androidTests"})).get();
            }
            return project.getLayout().getProjectDirectory().dir(reportsDir);
        }));
        project.afterEvaluate(prj -> {
            for (Project p : prj.getSubprojects()) {
                TaskCollection tasks = p.getTasks().withType(AndroidReportTask.class);
                for (AndroidReportTask task : tasks) {
                    mergeReportsTask.addTask(task);
                }
                TaskCollection tasks2 = p.getTasks().withType(DeviceProviderInstrumentTestTask.class);
                for (DeviceProviderInstrumentTestTask task : tasks2) {
                    mergeReportsTask.addTask(task);
                }
            }
        });
        if (project.getGradle().getStartParameter().isContinueOnFailure()) {
            project.getGradle().getTaskGraph().whenReady(taskExecutionGraph -> {
                if (taskExecutionGraph.hasTask((Task)mergeReportsTask)) {
                    mergeReportsTask.setWillRun();
                }
            });
        }
    }
}

