/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.mlkit.codegen;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.tasks.mlkit.codegen.ClassMetadata;
import com.android.build.gradle.internal.tasks.mlkit.codegen.ClassNames;
import com.android.build.gradle.internal.tasks.mlkit.codegen.CodeUtils;
import com.android.build.gradle.internal.tasks.mlkit.codegen.ModelGenerator;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.InjectorUtils;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.codeblock.CodeBlockInjector;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.codeblock.processor.DefaultProcessInjector;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.fields.FieldInjector;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.innerclass.GroupClassInjector;
import com.android.build.gradle.internal.tasks.mlkit.codegen.codeinjector.innerclass.OutputsClassInjector;
import com.android.tools.mlkit.MlNames;
import com.android.tools.mlkit.ModelInfo;
import com.android.tools.mlkit.TensorGroupInfo;
import com.android.tools.mlkit.TensorInfo;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/build/gradle/internal/tasks/mlkit/codegen/TfliteModelGenerator;", "Lcom/android/build/gradle/internal/tasks/mlkit/codegen/ModelGenerator;", "modelFile", "Ljava/io/File;", "packageName", "", "localModelPath", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "androidLogger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "className", "logger", "Lorg/gradle/api/logging/Logger;", "modelInfo", "Lcom/android/tools/mlkit/ModelInfo;", "buildCloseMethod", "", "classBuilder", "Lcom/squareup/javapoet/TypeSpec$Builder;", "buildConstructor", "buildFields", "buildInnerClass", "buildProcessMethod", "isGeneric", "", "buildStaticNewInstanceMethods", "generateBuildClass", "outputDirProperty", "Lorg/gradle/api/file/DirectoryProperty;", "Companion", "gradle-core"})
public final class TfliteModelGenerator
implements ModelGenerator {
    private final Logger logger;
    private final ModelInfo modelInfo;
    private final String className;
    private final LoggerWrapper androidLogger;
    private final File modelFile;
    private final String packageName;
    private final String localModelPath;
    private static final String FIELD_MODEL = "model";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void generateBuildClass(@NotNull DirectoryProperty outputDirProperty) {
        boolean bl;
        TypeSpec.Builder classBuilder;
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)outputDirProperty, (String)"outputDirProperty");
            classBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            if (!this.modelInfo.isMinParserVersionSatisfied()) {
                this.androidLogger.warning("Model is not fully supported in current Android Gradle Plugin" + " and will use fallback APIs, so please update to the latest version: " + this.modelFile.getAbsolutePath(), new Object[0]);
            }
            if (this.modelInfo.isMetadataExisted()) {
                classBuilder.addJavadoc(this.modelInfo.getModelDescription(), new Object[0]);
            } else {
                classBuilder.addJavadoc("This model doesn't have metadata, so no javadoc can be generated.", new Object[0]);
            }
            TypeSpec.Builder builder = classBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"classBuilder");
            this.buildFields(builder);
            this.buildConstructor(classBuilder);
            this.buildStaticNewInstanceMethods(classBuilder);
            TfliteModelGenerator.buildProcessMethod$default(this, classBuilder, false, 2, null);
            this.buildCloseMethod(classBuilder);
            List<TensorInfo> list = this.modelInfo.getInputs();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"modelInfo.inputs");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TensorInfo it = (TensorInfo)element$iv;
                    boolean bl2 = false;
                    TensorInfo tensorInfo = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)tensorInfo, (String)"it");
                    if (!tensorInfo.isRGBImage()) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            this.buildProcessMethod(classBuilder, true);
        }
        this.buildInnerClass(classBuilder);
        try {
            JavaFile.builder((String)this.packageName, (TypeSpec)classBuilder.build()).build().writeTo((File)outputDirProperty.getAsFile().get());
        }
        catch (IOException e) {
            this.logger.debug("Failed to write mlkit generated java file");
        }
    }

    private final void buildFields(TypeSpec.Builder classBuilder) {
        for (TensorInfo tensorInfo : this.modelInfo.getInputs()) {
            FieldInjector fieldInjector = InjectorUtils.getFieldInjector();
            TensorInfo tensorInfo2 = tensorInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)tensorInfo2, (String)"tensorInfo");
            fieldInjector.inject(classBuilder, tensorInfo2);
        }
        for (TensorInfo tensorInfo : this.modelInfo.getOutputs()) {
            FieldInjector fieldInjector = InjectorUtils.getFieldInjector();
            TensorInfo tensorInfo3 = tensorInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)tensorInfo3, (String)"tensorInfo");
            fieldInjector.inject(classBuilder, tensorInfo3);
        }
        FieldSpec model = FieldSpec.builder((TypeName)((TypeName)ClassNames.MODEL), (String)FIELD_MODEL, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addAnnotation(ClassNames.NON_NULL).build();
        classBuilder.addField(model);
    }

    private final void buildInnerClass(TypeSpec.Builder classBuilder) {
        new OutputsClassInjector(new ClassMetadata(this.packageName, this.className)).inject(classBuilder, this.modelInfo);
        List<TensorGroupInfo> list = this.modelInfo.getOutputTensorGroups();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"modelInfo.outputTensorGroups");
        Collection collection = list;
        boolean bl = false;
        if (!collection.isEmpty()) {
            new GroupClassInjector().inject(classBuilder, this.modelInfo);
        }
    }

    private final void buildConstructor(TypeSpec.Builder classBuilder) {
        TensorInfo tensorInfo;
        ParameterSpec context = ParameterSpec.builder((TypeName)((TypeName)ClassNames.CONTEXT), (String)"context", (Modifier[])new Modifier[0]).addAnnotation(ClassNames.NON_NULL).build();
        ParameterSpec options = ParameterSpec.builder((TypeName)((TypeName)ClassNames.MODEL_OPTIONS), (String)"options", (Modifier[])new Modifier[0]).addAnnotation(ClassNames.NON_NULL).build();
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(context).addParameter(options).addException((TypeName)ClassNames.IO_EXCEPTION).addStatement("$L = $T.createModel(context, $S, options)", new Object[]{FIELD_MODEL, ClassNames.MODEL, this.localModelPath}).addStatement("$T extractor = new $T(model.getData())", new Object[]{ClassNames.METADATA_EXTRACTOR, ClassNames.METADATA_EXTRACTOR});
        Iterator<TensorInfo> iterator = this.modelInfo.getInputs().iterator();
        while (iterator.hasNext()) {
            TensorInfo tensorInfo2 = tensorInfo = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)tensorInfo2, (String)"tensorInfo");
            if (!tensorInfo2.isMetadataExisted()) continue;
            CodeBlockInjector preprocessorInjector = InjectorUtils.getInputProcessorInjector(tensorInfo);
            MethodSpec.Builder builder = constructorBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"constructorBuilder");
            preprocessorInjector.inject(builder, tensorInfo);
        }
        iterator = this.modelInfo.getOutputs().iterator();
        while (iterator.hasNext()) {
            TensorInfo tensorInfo3 = tensorInfo = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)tensorInfo3, (String)"tensorInfo");
            if (!tensorInfo3.isMetadataExisted()) continue;
            CodeBlockInjector postprocessorInjector = InjectorUtils.getOutputProcessorInjector(tensorInfo);
            MethodSpec.Builder builder = constructorBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"constructorBuilder");
            postprocessorInjector.inject(builder, tensorInfo);
            CodeBlockInjector codeBlockInjector = InjectorUtils.getAssociatedFileInjector();
            codeBlockInjector.inject(constructorBuilder, tensorInfo);
        }
        classBuilder.addMethod(constructorBuilder.build());
    }

    private final void buildProcessMethod(TypeSpec.Builder classBuilder, boolean isGeneric) {
        ClassName className = ClassName.get((String)this.packageName, (String)this.className, (String[])new String[0]).nestedClass("Outputs");
        Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"ClassName.get(packageNam\u2026tedClass(MlNames.OUTPUTS)");
        TypeName outputType = (TypeName)className;
        String localOutputs = "outputs";
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"process").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(ClassNames.NON_NULL).returns(outputType);
        List byteBufferList = new ArrayList();
        Iterator<TensorInfo> iterator = this.modelInfo.getInputs().iterator();
        while (iterator.hasNext()) {
            TensorInfo tensorInfo;
            TensorInfo tensorInfo2 = tensorInfo = iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)tensorInfo2, (String)"tensorInfo");
            String processedTypeName = CodeUtils.getProcessedTypeName(tensorInfo2);
            TypeName parameterType = isGeneric ? (TypeName)ClassNames.TENSOR_BUFFER : CodeUtils.getParameterType(tensorInfo);
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)parameterType, (String)tensorInfo.getIdentifierName(), (Modifier[])new Modifier[0]).addAnnotation(ClassNames.NON_NULL).build();
            methodBuilder.addParameter(parameterSpec);
            byteBufferList.add(processedTypeName + ".getBuffer()");
        }
        for (TensorInfo tensorInfo : this.modelInfo.getInputs()) {
            if (isGeneric) {
                DefaultProcessInjector defaultProcessInjector = new DefaultProcessInjector();
                MethodSpec.Builder builder = methodBuilder;
                Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"methodBuilder");
                TensorInfo tensorInfo3 = tensorInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)tensorInfo3, (String)"tensorInfo");
                defaultProcessInjector.inject(builder, tensorInfo3);
                continue;
            }
            TensorInfo tensorInfo4 = tensorInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)tensorInfo4, (String)"tensorInfo");
            CodeBlockInjector codeBlockInjector = InjectorUtils.getProcessInjector(tensorInfo4);
            MethodSpec.Builder builder = methodBuilder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"methodBuilder");
            codeBlockInjector.inject(builder, tensorInfo);
        }
        methodBuilder.addStatement("$T $L = new $T(model)", new Object[]{outputType, localOutputs, outputType});
        Object[] objectArray = new Object[3];
        objectArray[0] = FIELD_MODEL;
        Collection $this$toTypedArray$iv = byteBufferList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray[1] = CodeUtils.getObjectArrayString(stringArray);
        objectArray[2] = localOutputs;
        methodBuilder.addStatement("$L.run($L, $L.getBuffer())", objectArray);
        methodBuilder.addStatement("return $L", new Object[]{localOutputs});
        classBuilder.addMethod(methodBuilder.build());
    }

    static /* synthetic */ void buildProcessMethod$default(TfliteModelGenerator tfliteModelGenerator, TypeSpec.Builder builder, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        tfliteModelGenerator.buildProcessMethod(builder, bl);
    }

    private final void buildCloseMethod(TypeSpec.Builder classBuilder) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"close").addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$L.close()", new Object[]{FIELD_MODEL});
        classBuilder.addMethod(methodBuilder.build());
    }

    private final void buildStaticNewInstanceMethods(TypeSpec.Builder classBuilder) {
        ParameterSpec context = ParameterSpec.builder((TypeName)((TypeName)ClassNames.CONTEXT), (String)"context", (Modifier[])new Modifier[0]).addAnnotation(ClassNames.NON_NULL).build();
        ParameterSpec options = ParameterSpec.builder((TypeName)((TypeName)ClassNames.MODEL_OPTIONS), (String)"options", (Modifier[])new Modifier[0]).addAnnotation(ClassNames.NON_NULL).build();
        ClassName className = ClassName.get((String)this.packageName, (String)this.className, (String[])new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)className, (String)"ClassName.get(packageName, className)");
        TypeName returnType = (TypeName)className;
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"newInstance").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(context).addException((TypeName)ClassNames.IO_EXCEPTION).addAnnotation(ClassNames.NON_NULL).returns(returnType).addStatement("return new $T(context, (new $T.Builder()).build())", new Object[]{returnType, ClassNames.MODEL_OPTIONS});
        classBuilder.addMethod(methodBuilder.build());
        MethodSpec.Builder methodWithOptionsBuilder = MethodSpec.methodBuilder((String)"newInstance").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(context).addParameter(options).addException((TypeName)ClassNames.IO_EXCEPTION).addAnnotation(ClassNames.NON_NULL).returns(returnType).addStatement("return new $T(context, options)", new Object[]{returnType});
        classBuilder.addMethod(methodWithOptionsBuilder.build());
    }

    public TfliteModelGenerator(@NotNull File modelFile, @NotNull String packageName2, @NotNull String localModelPath) {
        Intrinsics.checkParameterIsNotNull((Object)modelFile, (String)"modelFile");
        Intrinsics.checkParameterIsNotNull((Object)packageName2, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)localModelPath, (String)"localModelPath");
        this.modelFile = modelFile;
        this.packageName = packageName2;
        this.localModelPath = localModelPath;
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(this.javaClass)");
        this.logger = logger;
        ModelInfo modelInfo = ModelInfo.buildFrom(ByteBuffer.wrap(FilesKt.readBytes((File)this.modelFile)));
        Intrinsics.checkExpressionValueIsNotNull((Object)modelInfo, (String)"ModelInfo.buildFrom(Byte\u2026p(modelFile.readBytes()))");
        this.modelInfo = modelInfo;
        String string = MlNames.computeModelClassName(this.localModelPath);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MlNames.computeModelClassName(localModelPath)");
        this.className = string;
        this.androidLogger = new LoggerWrapper(this.logger);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/mlkit/codegen/TfliteModelGenerator$Companion;", "", "()V", "FIELD_MODEL", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

