/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.mlkit;

import com.android.tools.mlkit.MlNames;
import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tensorflow.lite.support.metadata.schema.TensorGroup;

public class TensorGroupInfo {
    private final String name;
    private final String identifierName;
    private final List<String> tensorNames;

    public TensorGroupInfo(TensorGroup tensorGroup) {
        this.name = Strings.nullToEmpty((String)tensorGroup.name());
        this.identifierName = MlNames.computeIdentifierName(this.name, "");
        int len = tensorGroup.tensorNamesLength();
        this.tensorNames = new ArrayList<String>();
        for (int i2 = 0; i2 < len; ++i2) {
            this.tensorNames.add(tensorGroup.tensorNames(i2));
        }
    }

    public String getName() {
        return this.name;
    }

    public List<String> getTensorNames() {
        return this.tensorNames;
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public TensorGroupInfo(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.identifierName = in.readUTF();
        int length = in.readInt();
        this.tensorNames = new ArrayList<String>();
        for (int i2 = 0; i2 < length; ++i2) {
            this.tensorNames.add(in.readUTF());
        }
    }

    public void save(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.identifierName);
        out.writeInt(this.tensorNames.size());
        for (String tensorName : this.tensorNames) {
            out.writeUTF(tensorName);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TensorGroupInfo that = (TensorGroupInfo)o;
        return this.name.equals(that.name) && this.identifierName.equals(that.identifierName) && this.tensorNames.equals(that.tensorNames);
    }
}

