/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkComponentsBuildService;
import com.android.io.IAbstractFile;
import com.android.prefs.AndroidLocationsProvider;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdCamera;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.internal.avd.HardwareProperties;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140 J,\u0010!\u001a\u00020\u00032\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00052\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0014J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140(H\u0002J\u0014\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00140 J\u000e\u0010,\u001a\u00020-2\u0006\u0010%\u001a\u00020\u0014J\u001a\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00100\u001a\u000201H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0011\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/build/gradle/internal/AvdManager;", "", "avdFolder", "Ljava/io/File;", "versionedSdkLoader", "Lorg/gradle/api/provider/Provider;", "Lcom/android/build/gradle/internal/SdkComponentsBuildService$VersionedSdkLoader;", "sdkHandler", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "androidLocationsProvider", "Lcom/android/prefs/AndroidLocationsProvider;", "(Ljava/io/File;Lorg/gradle/api/provider/Provider;Lcom/android/sdklib/repository/AndroidSdkHandler;Lcom/android/prefs/AndroidLocationsProvider;)V", "avdManager", "Lcom/android/sdklib/internal/avd/AvdManager;", "getAvdManager", "()Lcom/android/sdklib/internal/avd/AvdManager;", "avdManager$delegate", "Lkotlin/Lazy;", "defaultEmulatorPropertiesMap", "", "", "deviceManager", "Lcom/android/sdklib/devices/DeviceManager;", "getDeviceManager", "()Lcom/android/sdklib/devices/DeviceManager;", "deviceManager$delegate", "logger", "Lcom/android/utils/ILogger;", "sdkDirectory", "getSdkDirectory", "()Ljava/io/File;", "allAvds", "", "createOrRetrieveAvd", "imageProvider", "Lorg/gradle/api/file/Directory;", "imageHash", "deviceName", "hardwareProfile", "defaultHardwareConfig", "", "deleteAvds", "", "avds", "deviceSnapshotCreated", "", "retrieveSystemImage", "Lcom/android/sdklib/ISystemImage;", "imageLocation", "Ljava/nio/file/Path;", "gradle-core"})
public final class AvdManager {
    @NotNull
    private final Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader;
    @NotNull
    private final AndroidSdkHandler sdkHandler;
    @NotNull
    private final AndroidLocationsProvider androidLocationsProvider;
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Lazy avdManager$delegate;
    @NotNull
    private final Lazy deviceManager$delegate;
    @NotNull
    private final Map<String, String> defaultEmulatorPropertiesMap;

    public AvdManager(@NotNull File avdFolder, @NotNull Provider<SdkComponentsBuildService.VersionedSdkLoader> versionedSdkLoader, @NotNull AndroidSdkHandler sdkHandler, @NotNull AndroidLocationsProvider androidLocationsProvider) {
        Intrinsics.checkParameterIsNotNull((Object)avdFolder, (String)"avdFolder");
        Intrinsics.checkParameterIsNotNull(versionedSdkLoader, (String)"versionedSdkLoader");
        Intrinsics.checkParameterIsNotNull((Object)sdkHandler, (String)"sdkHandler");
        Intrinsics.checkParameterIsNotNull((Object)androidLocationsProvider, (String)"androidLocationsProvider");
        this.versionedSdkLoader = versionedSdkLoader;
        this.sdkHandler = sdkHandler;
        this.androidLocationsProvider = androidLocationsProvider;
        Pair[] pairArray = LoggerWrapper.getLogger(AvdManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)pairArray, (String)"getLogger(AvdManager::class.java)");
        this.logger = (ILogger)pairArray;
        this.avdManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<com.android.sdklib.internal.avd.AvdManager>(this, avdFolder){
            final /* synthetic */ AvdManager this$0;
            final /* synthetic */ File $avdFolder;
            {
                this.this$0 = $receiver;
                this.$avdFolder = $avdFolder;
                super(0);
            }

            @NotNull
            public final com.android.sdklib.internal.avd.AvdManager invoke() {
                com.android.sdklib.internal.avd.AvdManager avdManager2 = com.android.sdklib.internal.avd.AvdManager.getInstance((AndroidSdkHandler)AvdManager.access$getSdkHandler$p(this.this$0), (File)this.$avdFolder, (ILogger)AvdManager.access$getLogger$p(this.this$0));
                if (avdManager2 == null) {
                    throw new RuntimeException("Failed to initialize AvdManager.");
                }
                return avdManager2;
            }
        }));
        this.deviceManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DeviceManager>(this){
            final /* synthetic */ AvdManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final DeviceManager invoke() {
                return DeviceManager.createInstance((AndroidLocationsProvider)AvdManager.access$getAndroidLocationsProvider$p(this.this$0), (Path)AvdManager.access$getSdkDirectory(this.this$0).toPath(), (ILogger)AvdManager.access$getLogger$p(this.this$0));
            }
        }));
        pairArray = new Pair[]{TuplesKt.to((Object)"hw.camera.back", (Object)AvdCamera.EMULATED.getAsParameter()), TuplesKt.to((Object)"hw.cpu.ncore", (Object)String.valueOf(EmulatedProperties.RECOMMENDED_NUMBER_OF_CORES)), TuplesKt.to((Object)"skin.path", (Object)"_no_skin"), TuplesKt.to((Object)"showDeviceFrame", (Object)"yes"), TuplesKt.to((Object)"hw.camera.front", (Object)AvdCamera.EMULATED.getAsParameter()), TuplesKt.to((Object)"hw.keyboard", (Object)"yes"), TuplesKt.to((Object)"hw.gpu.mode", (Object)GpuMode.AUTO.getGpuSetting()), TuplesKt.to((Object)"hw.initialOrientation", (Object)"Portrait"), TuplesKt.to((Object)"disk.dataPartition.size", (Object)EmulatedProperties.DEFAULT_INTERNAL_STORAGE.toString()), TuplesKt.to((Object)"runtime.network.latency", (Object)"None"), TuplesKt.to((Object)"runtime.network.speed", (Object)"Full"), TuplesKt.to((Object)"sdcard.size", (Object)EmulatedProperties.DEFAULT_SDCARD_SIZE.toString()), TuplesKt.to((Object)"fastboot.forceChosenSnapshotBoot", (Object)"no"), TuplesKt.to((Object)"fastboot.forceColdBoot", (Object)"no"), TuplesKt.to((Object)"fastboot.forceFastBoot", (Object)"yes"), TuplesKt.to((Object)"hw.gpu.enabled", (Object)"yes"), TuplesKt.to((Object)"vm.heapSize", (Object)EmulatedProperties.DEFAULT_HEAP.toString())};
        this.defaultEmulatorPropertiesMap = MapsKt.mapOf((Pair[])pairArray);
    }

    private final File getSdkDirectory() {
        File file = ((Directory)((SdkComponentsBuildService.VersionedSdkLoader)this.versionedSdkLoader.get()).getSdkDirectoryProvider().get()).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"versionedSdkLoader.get().sdkDirectoryProvider.get().asFile");
        return file;
    }

    private final com.android.sdklib.internal.avd.AvdManager getAvdManager() {
        Lazy lazy = this.avdManager$delegate;
        boolean bl = false;
        return (com.android.sdklib.internal.avd.AvdManager)lazy.getValue();
    }

    private final DeviceManager getDeviceManager() {
        Lazy lazy = this.deviceManager$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pyright (C) 2020 The Android Open Source Project\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *      http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\npackage com.android.build.gradle.internal\n\nimport com.android.SdkConstants\nimport com.android.prefs.AndroidLocationsProvider\nimport com.android.sdklib.ISystemImage\nimport com.android.sdklib.PathFileWrapper\nimport com.android.sdklib.devices.DeviceManager\nimport com.android.sdklib.internal.avd.AvdCamera\nimport com.android.sdklib.internal.avd.AvdInfo\nimport com.android.sdklib.internal.avd.EmulatedProperties\nimport com.android.sdklib.internal.avd.GpuMode\nimport com.android.sdklib.internal.avd.HardwareProperties\nimport com.android.sdklib.repository.AndroidSdkHandler\nimport com.android.sdklib.repository.LoggerProgressIndicatorWrapper\nimport com.android.utils.ILogger\nimport com.android.utils.StdLogger\nimport org.gradle.api.file.Directory\nimport org.gradle.api.provider.Provider\nimport java.io.File\nimport java.nio.file.Path\nimport kotlin.math.min\n\nprivate const val MAX_SYSTEM_IMAGE_RETRIES = 4;\nprivate const val BASE_RETRY_DELAY_SECONDS = 2L;\nprivate const val MAX_RETRY_DELAY_SECONDS = 10L;\n\n/**\n * Manages AVDs for the Avd build service inside the Android Gradle Plugin.\n */\nclass AvdManager(\n    avdFolder: File,\n    private val versionedSdkLoader: Provider<SdkComponentsBuildService.VersionedSdkLoader>,\n    private val sdkHandler: AndroidSdkHandler,\n    private val androidLocationsProvider: AndroidLocationsProvider\n) {\n\n    private val sdkDirectory: File\n    get() = versionedSdkLoader.get().sdkDirectoryProvider.get().asFile\n\n    private val logger: ILogger = LoggerWrapper.getLogger(AvdManager::class.java)\n\n    private val avdManager: com.android.sdklib.internal.avd.AvdManager by lazy {\n        com.android.sdklib.internal.avd.AvdManager.getInstance(\n            sdkHandler,\n            avdFolder,\n            logger\n        ) ?: throw RuntimeException(\"Failed to initialize AvdManager.\")\n    }\n\n    private val deviceManager: DeviceManager by lazy {\n        DeviceManager.createInstance(androidLocationsProvider, sdkDirectory.toPath(), logger)\n    }");
        return (DeviceManager)object;
    }

    @NotNull
    public final File createOrRetrieveAvd(@NotNull Provider<Directory> imageProvider, @NotNull String imageHash, @NotNull String deviceName, @NotNull String hardwareProfile) {
        Object v0;
        Object object;
        boolean bl;
        Object object22;
        ISystemImage systemImage;
        FileOp fileOp;
        block6: {
            AvdInfo info2;
            Intrinsics.checkParameterIsNotNull(imageProvider, (String)"imageProvider");
            Intrinsics.checkParameterIsNotNull((Object)imageHash, (String)"imageHash");
            Intrinsics.checkParameterIsNotNull((Object)deviceName, (String)"deviceName");
            Intrinsics.checkParameterIsNotNull((Object)hardwareProfile, (String)"hardwareProfile");
            this.getAvdManager().reloadAvds(this.logger);
            AvdInfo avdInfo = info2 = this.getAvdManager().getAvd(deviceName, false);
            if (avdInfo != null) {
                AvdInfo avdInfo2 = avdInfo;
                boolean bl2 = false;
                boolean bl3 = false;
                AvdInfo it = avdInfo2;
                boolean object22 = false;
                this.logger.info("Device: " + deviceName + " already exists. AVD creation skipped.", new Object[0]);
                File file = info2.getConfigFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"info.configFile");
                return file;
            }
            if (!imageProvider.isPresent()) {
                throw new RuntimeException(Intrinsics.stringPlus((String)"Failed to find system image for hash: ", (Object)imageHash));
            }
            fileOp = this.sdkHandler.getFileOp();
            Path imageLocation = fileOp.toPath(((Directory)imageProvider.get()).getAsFile());
            Intrinsics.checkExpressionValueIsNotNull((Object)imageLocation, (String)"imageLocation");
            ISystemImage iSystemImage = systemImage = this.retrieveSystemImage(this.sdkHandler, imageLocation);
            if (iSystemImage == null) {
                String it = Intrinsics.stringPlus((String)"System image does not exist at ", (Object)imageLocation);
                boolean object22 = false;
                throw (Throwable)new IllegalStateException(it.toString());
            }
            object22 = this.getDeviceManager().getDevices(DeviceManager.ALL_DEVICES);
            Intrinsics.checkExpressionValueIsNotNull((Object)object22, (String)"deviceManager.getDevices(DeviceManager.ALL_DEVICES)");
            object22 = (Iterable)object22;
            bl = false;
            object = object22;
            boolean bl4 = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Device it = (Device)e;
                boolean bl5 = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)hardwareProfile)) continue;
                v0 = e;
                break block6;
            }
            v0 = null;
        }
        Device it = v0;
        if (it == null) {
            object22 = Intrinsics.stringPlus((String)"Failed to find hardware profile for name: ", (Object)hardwareProfile);
            bl = false;
            throw (Throwable)new IllegalStateException(object22.toString());
        }
        Device device = it;
        Map<String, String> hardwareConfig = this.defaultHardwareConfig();
        object22 = DeviceManager.getHardwareProperties((Device)device);
        Intrinsics.checkExpressionValueIsNotNull((Object)object22, (String)"getHardwareProperties(device)");
        hardwareConfig.putAll((Map<String, String>)object22);
        EmulatedProperties.restrictDefaultRamSize(hardwareConfig);
        File deviceFolder = AvdInfo.getDefaultAvdFolder((com.android.sdklib.internal.avd.AvdManager)this.getAvdManager(), (String)deviceName, (FileOp)fileOp, (boolean)false);
        AvdInfo newInfo = this.getAvdManager().createAvd(fileOp.toPath(deviceFolder), deviceName, systemImage, null, null, null, hardwareConfig, device.getBootProps(), device.hasPlayStore(), false, false, this.logger);
        Object object3 = newInfo;
        Object object4 = object = object3 == null ? null : object3.getConfigFile();
        if (object == null) {
            object3 = "AVD could not be created.";
            boolean bl6 = false;
            throw (Throwable)new IllegalStateException(object3.toString());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> allAvds() {
        void $this$mapTo$iv$iv;
        this.getAvdManager().reloadAvds(this.logger);
        AvdInfo[] avdInfoArray = this.getAvdManager().getAllAvds();
        Intrinsics.checkExpressionValueIsNotNull((Object)avdInfoArray, (String)"avdManager.allAvds");
        Object[] $this$map$iv = avdInfoArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AvdInfo avdInfo = (AvdInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public final void deleteAvds(@NotNull List<String> avds) {
        Intrinsics.checkParameterIsNotNull(avds, (String)"avds");
        this.getAvdManager().reloadAvds(this.logger);
        for (String avdName : avds) {
            AvdInfo avdInfo = this.getAvdManager().getAvd(avdName, false);
            if (avdInfo != null) {
                this.getAvdManager().deleteAvd(avdInfo, this.logger);
                continue;
            }
            this.logger.warning("Failed to delete avd: " + avdName + '.', new Object[0]);
        }
    }

    public final boolean deviceSnapshotCreated(@NotNull String deviceName) {
        Intrinsics.checkParameterIsNotNull((Object)deviceName, (String)"deviceName");
        AvdInfo avdInfo = this.getAvdManager().getAvd(deviceName, false);
        if (avdInfo == null) {
            return false;
        }
        AvdInfo device = avdInfo;
        File snapshotPath = new File(device.getDataFolderPath(), "snapshots/default_boot/snapshot.pb");
        return snapshotPath.exists();
    }

    private final Map<String, String> defaultHardwareConfig() {
        Provider<Directory> emulatorProvider = ((SdkComponentsBuildService.VersionedSdkLoader)this.versionedSdkLoader.get()).getEmulatorDirectoryProvider();
        if (!emulatorProvider.isPresent()) {
            String string = "AVD Emulator package is not downloaded. Failed to retrieve hardware defaults for virtual device.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        File emulatorLib = ((Directory)emulatorProvider.get()).getAsFile();
        File libDirectory = new File(emulatorLib, "lib");
        File hardwareDefs = new File(libDirectory, "hardware-properties.ini");
        Map map = HardwareProperties.parseHardwareDefinitions((IAbstractFile)((IAbstractFile)new PathFileWrapper(this.sdkHandler.getFileOp().toPath(hardwareDefs))), (ILogger)this.logger);
        if (map == null) {
            String string = "Failed to find hardware definitions for emulator.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Map hwMap = map;
        Map hwConfigMap = MapsKt.toMutableMap(this.defaultEmulatorPropertiesMap);
        Iterable $this$forEach$iv = hwMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HardwareProperties.HardwareProperty it = (HardwareProperties.HardwareProperty)element$iv;
            boolean bl = false;
            String string = it.getDefault();
            Object object = string;
            boolean bl2 = false;
            boolean bl3 = false;
            if (object == null || object.length() == 0) continue;
            object = hwConfigMap;
            String string2 = it.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.name");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"default");
            String string3 = string;
            boolean bl4 = false;
            object.put(string2, string3);
        }
        return hwConfigMap;
    }

    private final ISystemImage retrieveSystemImage(AndroidSdkHandler sdkHandler, Path imageLocation) {
        long delay = 2L;
        int n = 0;
        do {
            int retry = n++;
            ISystemImage systemImage = sdkHandler.getSystemImageManager((ProgressIndicator)new LoggerProgressIndicatorWrapper((ILogger)new StdLogger(StdLogger.Level.VERBOSE))).getImageAt(imageLocation);
            if (systemImage != null) {
                return systemImage;
            }
            if (retry == 4) continue;
            this.logger.warning("Failed to to retrieve system image at: " + imageLocation + " Retrying in " + delay + " seconds", new Object[0]);
            Thread.sleep(delay * (long)1000);
            long l = delay * 2L;
            long l2 = 10L;
            boolean bl = false;
            delay = Math.min(l, l2);
        } while (n <= 4);
        return null;
    }

    public static final /* synthetic */ AndroidSdkHandler access$getSdkHandler$p(AvdManager $this) {
        return $this.sdkHandler;
    }

    public static final /* synthetic */ ILogger access$getLogger$p(AvdManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ AndroidLocationsProvider access$getAndroidLocationsProvider$p(AvdManager $this) {
        return $this.androidLocationsProvider;
    }

    public static final /* synthetic */ File access$getSdkDirectory(AvdManager $this) {
        return $this.getSdkDirectory();
    }
}

