/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.json;

import com.android.build.gradle.internal.cxx.json.CompilationDatabaseStreamingVisitor;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0006\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/cxx/json/CompilationDatabaseStreamingParser;", "Ljava/io/Closeable;", "reader", "Lcom/google/gson/stream/JsonReader;", "visitor", "Lcom/android/build/gradle/internal/cxx/json/CompilationDatabaseStreamingVisitor;", "(Lcom/google/gson/stream/JsonReader;Lcom/android/build/gradle/internal/cxx/json/CompilationDatabaseStreamingVisitor;)V", "close", "", "parse", "parseCompilationEntry", "parseUnknown", "gradle-core"})
public class CompilationDatabaseStreamingParser
implements Closeable {
    @NotNull
    private final JsonReader reader;
    @NotNull
    private final CompilationDatabaseStreamingVisitor visitor;

    public CompilationDatabaseStreamingParser(@NotNull JsonReader reader, @NotNull CompilationDatabaseStreamingVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        Intrinsics.checkParameterIsNotNull((Object)visitor2, (String)"visitor");
        this.reader = reader;
        this.visitor = visitor2;
    }

    @Override
    public void close() {
        this.reader.close();
    }

    public final void parse() {
        this.reader.beginArray();
        while (this.reader.hasNext()) {
            int n;
            JsonToken jsonToken = this.reader.peek();
            int n2 = n = jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()];
            if (n == 1) {
                this.parseCompilationEntry();
                continue;
            }
            this.parseUnknown();
        }
        this.reader.endArray();
    }

    private final void parseCompilationEntry() {
        this.reader.beginObject();
        this.visitor.beginCommand();
        block10: while (this.reader.hasNext()) {
            String name;
            block14: {
                name = this.reader.nextName();
                if (name == null) break block14;
                int n = -1;
                switch (name.hashCode()) {
                    case 3143036: {
                        if (name.equals("file")) {
                            n = 1;
                        }
                        break;
                    }
                    case -962584979: {
                        if (name.equals("directory")) {
                            n = 2;
                        }
                        break;
                    }
                    case 950394699: {
                        if (name.equals("command")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        String string = this.reader.nextString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.nextString()");
                        this.visitor.visitDirectory(string);
                        continue block10;
                    }
                    case 3: {
                        String string = this.reader.nextString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.nextString()");
                        this.visitor.visitCommand(string);
                        continue block10;
                    }
                    case 1: {
                        String string = this.reader.nextString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"reader.nextString()");
                        this.visitor.visitFile(string);
                        continue block10;
                    }
                }
            }
            throw new RuntimeException('\'' + name + "' is not a recognized field");
        }
        this.visitor.endCommand();
        this.reader.endObject();
    }

    private final void parseUnknown() {
        throw new RuntimeException(this.reader.peek().toString());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            nArray[JsonToken.BEGIN_OBJECT.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

