/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.json;

import com.android.build.gradle.internal.cxx.json.PlainFileGsonTypeAdaptor;
import com.google.common.base.Charsets;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a'\u0010\u0005\u001a\u0002H\u0002\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\t\u00a2\u0006\u0002\u0010\n\u001a!\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"jsonStringOf", "", "T", "value", "(Ljava/lang/Object;)Ljava/lang/String;", "readJsonFile", "file", "Ljava/io/File;", "type", "Ljava/lang/Class;", "(Ljava/io/File;Ljava/lang/Class;)Ljava/lang/Object;", "writeJsonFile", "", "(Ljava/io/File;Ljava/lang/Object;)V", "gradle-core"})
public final class JsonHelpersKt {
    @NotNull
    public static final <T> String jsonStringOf(T value) {
        String string = new GsonBuilder().registerTypeAdapter((Type)((Object)File.class), (Object)new PlainFileGsonTypeAdaptor()).setPrettyPrinting().create().toJson(value);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public static final <T> void writeJsonFile(@NotNull File file, T value) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        String string = JsonHelpersKt.jsonStringOf(value);
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"UTF_8");
        FilesKt.writeText((File)file, (String)string, (Charset)charset);
    }

    public static final <T> T readJsonFile(@NotNull File file, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return (T)new GsonBuilder().registerTypeAdapter((Type)((Object)File.class), (Object)new PlainFileGsonTypeAdaptor()).create().fromJson(FilesKt.readText$default((File)file, null, (int)1, null), type);
    }
}

