/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.LoggingLevel;
import com.android.utils.cxx.CxxDiagnosticCode;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u00c6\u0003JA\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\b\u0010 \u001a\u00020\u0005H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/LoggingMessage;", "", "level", "Lcom/android/build/gradle/internal/cxx/logging/LoggingLevel;", "message", "", "file", "Ljava/io/File;", "tag", "diagnosticCode", "Lcom/android/utils/cxx/CxxDiagnosticCode;", "(Lcom/android/build/gradle/internal/cxx/logging/LoggingLevel;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Lcom/android/utils/cxx/CxxDiagnosticCode;)V", "getDiagnosticCode", "()Lcom/android/utils/cxx/CxxDiagnosticCode;", "getFile", "()Ljava/io/File;", "getLevel", "()Lcom/android/build/gradle/internal/cxx/logging/LoggingLevel;", "getMessage", "()Ljava/lang/String;", "getTag", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "gradle-core"})
public final class LoggingMessage {
    @NotNull
    private final LoggingLevel level;
    @NotNull
    private final String message;
    @Nullable
    private final File file;
    @Nullable
    private final String tag;
    @Nullable
    private final CxxDiagnosticCode diagnosticCode;

    public LoggingMessage(@NotNull LoggingLevel level, @NotNull String message, @Nullable File file, @Nullable String tag, @Nullable CxxDiagnosticCode diagnosticCode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.level = level;
        this.message = message;
        this.file = file;
        this.tag = tag;
        this.diagnosticCode = diagnosticCode;
    }

    public /* synthetic */ LoggingMessage(LoggingLevel loggingLevel, String string, File file, String string2, CxxDiagnosticCode cxxDiagnosticCode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            file = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            cxxDiagnosticCode = null;
        }
        this(loggingLevel, string, file, string2, cxxDiagnosticCode);
    }

    @NotNull
    public final LoggingLevel getLevel() {
        return this.level;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    @Nullable
    public final String getTag() {
        return this.tag;
    }

    @Nullable
    public final CxxDiagnosticCode getDiagnosticCode() {
        return this.diagnosticCode;
    }

    @NotNull
    public String toString() {
        String string;
        int n;
        CxxDiagnosticCode cxxDiagnosticCode = this.diagnosticCode;
        int n2 = n = cxxDiagnosticCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cxxDiagnosticCode.ordinal()];
        if (n == -1) {
            string = "C/C++: ";
        } else {
            LoggingLevel loggingLevel = this.level;
            int n3 = WhenMappings.$EnumSwitchMapping$1[loggingLevel.ordinal()];
            switch (n3) {
                case 1: {
                    string = "[CXX" + this.diagnosticCode.getWarningCode() + "] ";
                    break;
                }
                case 2: {
                    string = "[CXX" + this.diagnosticCode.getErrorCode() + "] ";
                    break;
                }
                default: {
                    throw new IllegalStateException("Message at " + (Object)((Object)this.level) + " should not have diagnostic code.");
                }
            }
        }
        String codeHeader = string;
        return this.file == null && this.tag == null ? Intrinsics.stringPlus((String)codeHeader, (Object)this.message) : (this.file != null && this.tag == null ? codeHeader + this.file + " : " + this.message : (this.file == null && this.tag != null ? codeHeader + this.tag + " : " + this.message : codeHeader + this.file + ' ' + this.tag + " : " + this.message));
    }

    @NotNull
    public final LoggingLevel component1() {
        return this.level;
    }

    @NotNull
    public final String component2() {
        return this.message;
    }

    @Nullable
    public final File component3() {
        return this.file;
    }

    @Nullable
    public final String component4() {
        return this.tag;
    }

    @Nullable
    public final CxxDiagnosticCode component5() {
        return this.diagnosticCode;
    }

    @NotNull
    public final LoggingMessage copy(@NotNull LoggingLevel level, @NotNull String message, @Nullable File file, @Nullable String tag, @Nullable CxxDiagnosticCode diagnosticCode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return new LoggingMessage(level, message, file, tag, diagnosticCode);
    }

    public static /* synthetic */ LoggingMessage copy$default(LoggingMessage loggingMessage, LoggingLevel loggingLevel, String string, File file, String string2, CxxDiagnosticCode cxxDiagnosticCode, int n, Object object) {
        if ((n & 1) != 0) {
            loggingLevel = loggingMessage.level;
        }
        if ((n & 2) != 0) {
            string = loggingMessage.message;
        }
        if ((n & 4) != 0) {
            file = loggingMessage.file;
        }
        if ((n & 8) != 0) {
            string2 = loggingMessage.tag;
        }
        if ((n & 0x10) != 0) {
            cxxDiagnosticCode = loggingMessage.diagnosticCode;
        }
        return loggingMessage.copy(loggingLevel, string, file, string2, cxxDiagnosticCode);
    }

    public int hashCode() {
        int result2 = this.level.hashCode();
        result2 = result2 * 31 + this.message.hashCode();
        result2 = result2 * 31 + (this.file == null ? 0 : this.file.hashCode());
        result2 = result2 * 31 + (this.tag == null ? 0 : this.tag.hashCode());
        result2 = result2 * 31 + (this.diagnosticCode == null ? 0 : this.diagnosticCode.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LoggingMessage)) {
            return false;
        }
        LoggingMessage loggingMessage = (LoggingMessage)other;
        if (this.level != loggingMessage.level) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.message, (Object)loggingMessage.message)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.file, (Object)loggingMessage.file)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)loggingMessage.tag)) {
            return false;
        }
        return this.diagnosticCode == loggingMessage.diagnosticCode;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            $EnumSwitchMapping$0 = new int[CxxDiagnosticCode.values().length];
            int[] nArray = new int[LoggingLevel.values().length];
            nArray[LoggingLevel.WARN.ordinal()] = 1;
            nArray[LoggingLevel.ERROR.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

