/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.logging;

import com.android.build.gradle.internal.cxx.logging.LoggingEnvironment;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.logging.LoggingLevel;
import com.android.build.gradle.internal.cxx.logging.LoggingMessage;
import com.android.build.gradle.internal.cxx.logging.LoggingMessageKt;
import com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment;
import com.android.utils.ILogger;
import com.android.utils.cxx.CxxDiagnosticCode;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "()V", "close", "", "Companion", "gradle-core"})
public abstract class ThreadLoggingEnvironment
implements LoggingEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ThreadLocal<Companion.LoggerStack> loggerStack;
    @NotNull
    private static final Companion.BottomLoggingEnvironment BOTTOM_LOGGING_ENVIRONMENT;

    public ThreadLoggingEnvironment() {
        ThreadLoggingEnvironment.Companion.push(this);
    }

    @Override
    public void close() {
        ThreadLoggingEnvironment.Companion.pop();
    }

    @JvmStatic
    @NotNull
    public static final LoggingEnvironment parentLogger() {
        return Companion.parentLogger();
    }

    static {
        ThreadLocal threadLocal = ThreadLocal.withInitial(Companion.loggerStack.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(threadLocal, (String)"withInitial { null }");
        loggerStack = threadLocal;
        BOTTOM_LOGGING_ENVIRONMENT = new Companion.BottomLoggingEnvironment();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\b\u0010\u0011\u001a\u00020\u0006H\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u001d\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion;", "", "()V", "BOTTOM_LOGGING_ENVIRONMENT", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment;", "logger", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "getLogger", "()Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "loggerStack", "Ljava/lang/ThreadLocal;", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "getILogger", "Lcom/android/utils/ILogger;", "warningDiagnosticCode", "Lcom/android/utils/cxx/CxxDiagnosticCode;", "errorDiagnosticCode", "parentLogger", "pop", "", "push", "Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment;", "reportFormattedErrorToCurrentLogger", "message", "", "diagnosticCode", "reportFormattedInfoToCurrentLogger", "reportFormattedLifecycleToCurrentLogger", "reportFormattedWarningToCurrentLogger", "requireExplicitLogger", "BottomLoggingEnvironment", "LoggerStack", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        private final LoggingEnvironment getLogger() {
            LoggerStack loggerStack2 = (LoggerStack)loggerStack.get();
            return loggerStack2 == null ? (LoggingEnvironment)BOTTOM_LOGGING_ENVIRONMENT : loggerStack2.getLogger();
        }

        private final void push(ThreadLoggingEnvironment logger) {
            loggerStack.set(new LoggerStack(logger, (LoggerStack)loggerStack.get()));
        }

        private final void pop() {
            LoggerStack next;
            LoggerStack loggerStack2 = (LoggerStack)loggerStack.get();
            LoggerStack loggerStack3 = next = loggerStack2 == null ? null : loggerStack2.getNext();
            if (next != null) {
                loggerStack.set(next);
            } else {
                loggerStack.remove();
            }
        }

        @JvmStatic
        @NotNull
        public final LoggingEnvironment parentLogger() {
            LoggerStack loggerStack2 = (LoggerStack)loggerStack.get();
            LoggerStack loggerStack3 = loggerStack2 == null ? null : loggerStack2.getNext();
            return loggerStack3 == null ? (LoggingEnvironment)BOTTOM_LOGGING_ENVIRONMENT : loggerStack3.getLogger();
        }

        public final void reportFormattedErrorToCurrentLogger(@NotNull String message, @Nullable CxxDiagnosticCode diagnosticCode) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().log(LoggingMessageKt.errorRecordOf(message, diagnosticCode));
        }

        public final void reportFormattedWarningToCurrentLogger(@NotNull String message, @Nullable CxxDiagnosticCode diagnosticCode) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().log(LoggingMessageKt.warnRecordOf(message, diagnosticCode));
        }

        public final void reportFormattedLifecycleToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().log(LoggingMessageKt.lifecycleRecordOf(message));
        }

        public final void reportFormattedInfoToCurrentLogger(@NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.getLogger().log(LoggingMessageKt.infoRecordOf(message));
        }

        public final void requireExplicitLogger() {
            if (Intrinsics.areEqual((Object)this.getLogger(), (Object)BOTTOM_LOGGING_ENVIRONMENT)) {
                throw new Exception("Non-default logger is required");
            }
        }

        @NotNull
        public final ILogger getILogger(@NotNull CxxDiagnosticCode warningDiagnosticCode, @NotNull CxxDiagnosticCode errorDiagnosticCode) {
            Intrinsics.checkParameterIsNotNull((Object)warningDiagnosticCode, (String)"warningDiagnosticCode");
            Intrinsics.checkParameterIsNotNull((Object)errorDiagnosticCode, (String)"errorDiagnosticCode");
            return new ILogger(errorDiagnosticCode, warningDiagnosticCode){
                final /* synthetic */ CxxDiagnosticCode $errorDiagnosticCode;
                final /* synthetic */ CxxDiagnosticCode $warningDiagnosticCode;
                {
                    this.$errorDiagnosticCode = $errorDiagnosticCode;
                    this.$warningDiagnosticCode = $warningDiagnosticCode;
                }

                public void error(@Nullable Throwable t, @Nullable String format, Object ... args) {
                    Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                    if (t != null) {
                        throw t;
                    }
                    LoggingEnvironment loggingEnvironment = com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion);
                    if (format == null) {
                        Intrinsics.throwNpe();
                    }
                    loggingEnvironment.log(LoggingMessageKt.errorRecordOf(LoggingEnvironmentKt.access$checkedFormat(format, args), this.$errorDiagnosticCode));
                }

                public void warning(@NotNull String format, Object ... args) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.warnRecordOf(LoggingEnvironmentKt.access$checkedFormat(format, args), this.$warningDiagnosticCode));
                }

                public void info(@NotNull String format, Object ... args) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.infoRecordOf(LoggingEnvironmentKt.access$checkedFormat(format, args)));
                }

                public void verbose(@NotNull String format, Object ... args) {
                    Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
                    Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                    com.android.build.gradle.internal.cxx.logging.ThreadLoggingEnvironment$Companion.access$getLogger(ThreadLoggingEnvironment.Companion).log(LoggingMessageKt.infoRecordOf(LoggingEnvironmentKt.access$checkedFormat(format, args)));
                }
            };
        }

        public static final /* synthetic */ LoggingEnvironment access$getLogger(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "", "logger", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "next", "(Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;)V", "getLogger", "()Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "getNext", "()Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$LoggerStack;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "gradle-core"})
        private static final class LoggerStack {
            @NotNull
            private final LoggingEnvironment logger;
            @Nullable
            private final LoggerStack next;

            public LoggerStack(@NotNull LoggingEnvironment logger, @Nullable LoggerStack next) {
                Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
                this.logger = logger;
                this.next = next;
            }

            @NotNull
            public final LoggingEnvironment getLogger() {
                return this.logger;
            }

            @Nullable
            public final LoggerStack getNext() {
                return this.next;
            }

            @NotNull
            public final LoggingEnvironment component1() {
                return this.logger;
            }

            @Nullable
            public final LoggerStack component2() {
                return this.next;
            }

            @NotNull
            public final LoggerStack copy(@NotNull LoggingEnvironment logger, @Nullable LoggerStack next) {
                Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
                return new LoggerStack(logger, next);
            }

            public static /* synthetic */ LoggerStack copy$default(LoggerStack loggerStack2, LoggingEnvironment loggingEnvironment, LoggerStack loggerStack3, int n, Object object) {
                if ((n & 1) != 0) {
                    loggingEnvironment = loggerStack2.logger;
                }
                if ((n & 2) != 0) {
                    loggerStack3 = loggerStack2.next;
                }
                return loggerStack2.copy(loggingEnvironment, loggerStack3);
            }

            @NotNull
            public String toString() {
                return "LoggerStack(logger=" + this.logger + ", next=" + this.next + ')';
            }

            public int hashCode() {
                int result2 = this.logger.hashCode();
                result2 = result2 * 31 + (this.next == null ? 0 : this.next.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LoggerStack)) {
                    return false;
                }
                LoggerStack loggerStack2 = (LoggerStack)other;
                if (!Intrinsics.areEqual((Object)this.logger, (Object)loggerStack2.logger)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.next, (Object)loggerStack2.next);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/cxx/logging/ThreadLoggingEnvironment$Companion$BottomLoggingEnvironment;", "Lcom/android/build/gradle/internal/cxx/logging/LoggingEnvironment;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "close", "", "log", "message", "Lcom/android/build/gradle/internal/cxx/logging/LoggingMessage;", "gradle-core"})
        private static final class BottomLoggingEnvironment
        implements LoggingEnvironment {
            private final Logger logger = Logging.getLogger(BottomLoggingEnvironment.class);

            @Override
            public void log(@NotNull LoggingMessage message) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                LoggingLevel loggingLevel = message.getLevel();
                int n = WhenMappings.$EnumSwitchMapping$0[loggingLevel.ordinal()];
                switch (n) {
                    case 1: {
                        this.logger.error(message.toString());
                        break;
                    }
                    case 2: {
                        this.logger.warn(message.toString());
                        break;
                    }
                    case 3: {
                        this.logger.lifecycle(message.toString());
                        break;
                    }
                    case 4: {
                        this.logger.info(message.toString());
                    }
                }
            }

            @Override
            public void close() {
            }

            @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[LoggingLevel.values().length];
                    nArray[LoggingLevel.ERROR.ordinal()] = 1;
                    nArray[LoggingLevel.WARN.ordinal()] = 2;
                    nArray[LoggingLevel.LIFECYCLE.ordinal()] = 3;
                    nArray[LoggingLevel.INFO.ordinal()] = 4;
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

