/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.cxx.model;

import com.android.build.gradle.internal.cxx.configure.BuildSystemCommandLineKt;
import com.android.build.gradle.internal.cxx.configure.CmakeLocatorKt;
import com.android.build.gradle.internal.cxx.configure.CmakeProperty;
import com.android.build.gradle.internal.cxx.configure.CommandLineArgument;
import com.android.build.gradle.internal.cxx.configure.NdkBuildProperty;
import com.android.build.gradle.internal.cxx.configure.NdkMetaPlatforms;
import com.android.build.gradle.internal.cxx.logging.LoggingEnvironmentKt;
import com.android.build.gradle.internal.cxx.model.CxxModuleModel;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.utils.FileUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0017\u001a\u00020\u0018*\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a\u001a\u0018\u0010\u001b\u001a\u00020\u0018*\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001a\u001a\u0018\u0010\u001d\u001a\u00020\u0018*\u00020\u00022\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001a\u001a'\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f*\u00020\u00022\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001f0!\u00a2\u0006\u0002\u0010\"\u001a'\u0010#\u001a\u0004\u0018\u0001H\u001f\"\u0004\b\u0000\u0010\u001f*\u00020\u00022\u000e\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001f0!\u00a2\u0006\u0002\u0010\"\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0004\"\u0015\u0010\r\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\"\u0015\u0010\u000f\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\"\u0015\u0010\u0011\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\b\"\u0015\u0010\u0013\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\"\u0015\u0010\u0015\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\b\u00a8\u0006$"}, d2={"buildSettingsFile", "Ljava/io/File;", "Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;", "getBuildSettingsFile", "(Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;)Ljava/io/File;", "cmakeGenerator", "", "getCmakeGenerator", "(Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;)Ljava/lang/String;", "cmakeSettingsFile", "getCmakeSettingsFile", "makeFileFolder", "getMakeFileFolder", "moduleName", "getModuleName", "ndkMajorVersion", "getNdkMajorVersion", "ndkMaxPlatform", "getNdkMaxPlatform", "ndkMinPlatform", "getNdkMinPlatform", "ndkMinorVersion", "getNdkMinorVersion", "determineUsedStl", "Lcom/android/build/gradle/internal/ndk/Stl;", "arguments", "", "determineUsedStlForCmake", "Lcom/android/build/gradle/internal/cxx/configure/CommandLineArgument;", "determineUsedStlForNdkBuild", "ifCMake", "T", "compute", "Lkotlin/Function0;", "(Lcom/android/build/gradle/internal/cxx/model/CxxModuleModel;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ifNdkBuild", "gradle-core"})
public final class CxxModuleModelKt {
    @NotNull
    public static final File getCmakeSettingsFile(@NotNull CxxModuleModel $this$cmakeSettingsFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cmakeSettingsFile, (String)"<this>");
        String[] stringArray = new String[]{"CMakeSettings.json"};
        File file = FileUtils.join((File)$this$cmakeSettingsFile.getMakeFile().getParentFile(), (String[])stringArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"join(makeFile.parentFile, \"CMakeSettings.json\")");
        return file;
    }

    @NotNull
    public static final File getBuildSettingsFile(@NotNull CxxModuleModel $this$buildSettingsFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$buildSettingsFile, (String)"<this>");
        String[] stringArray = new String[]{"BuildSettings.json"};
        File file = FileUtils.join((File)$this$buildSettingsFile.getMakeFile().getParentFile(), (String[])stringArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"join(makeFile.parentFile, \"BuildSettings.json\")");
        return file;
    }

    @NotNull
    public static final File getMakeFileFolder(@NotNull CxxModuleModel $this$makeFileFolder) {
        Intrinsics.checkParameterIsNotNull((Object)$this$makeFileFolder, (String)"<this>");
        File file = $this$makeFileFolder.getMakeFile().getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"makeFile.parentFile");
        return file;
    }

    @NotNull
    public static final String getModuleName(@NotNull CxxModuleModel $this$moduleName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$moduleName, (String)"<this>");
        return StringsKt.substringAfterLast$default((String)$this$moduleName.getGradleModulePathName(), (String)":", null, (int)2, null);
    }

    @NotNull
    public static final String getNdkMinPlatform(@NotNull CxxModuleModel $this$ndkMinPlatform) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)$this$ndkMinPlatform, (String)"<this>");
        Object object = $this$ndkMinPlatform.getNdkMetaPlatforms();
        Integer n2 = n = object == null ? null : Integer.valueOf(((NdkMetaPlatforms)object).getMin());
        return n == null ? "" : ((object = n.toString()) == null ? "" : object);
    }

    @NotNull
    public static final String getNdkMaxPlatform(@NotNull CxxModuleModel $this$ndkMaxPlatform) {
        Integer n;
        Intrinsics.checkParameterIsNotNull((Object)$this$ndkMaxPlatform, (String)"<this>");
        Object object = $this$ndkMaxPlatform.getNdkMetaPlatforms();
        Integer n2 = n = object == null ? null : Integer.valueOf(((NdkMetaPlatforms)object).getMax());
        return n == null ? "" : ((object = n.toString()) == null ? "" : object);
    }

    @NotNull
    public static final String getNdkMajorVersion(@NotNull CxxModuleModel $this$ndkMajorVersion) {
        Intrinsics.checkParameterIsNotNull((Object)$this$ndkMajorVersion, (String)"<this>");
        return String.valueOf($this$ndkMajorVersion.getNdkVersion().getMajor());
    }

    @NotNull
    public static final String getNdkMinorVersion(@NotNull CxxModuleModel $this$ndkMinorVersion) {
        Intrinsics.checkParameterIsNotNull((Object)$this$ndkMinorVersion, (String)"<this>");
        return String.valueOf($this$ndkMinorVersion.getNdkVersion().getMinor());
    }

    @NotNull
    public static final String getCmakeGenerator(@NotNull CxxModuleModel $this$cmakeGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cmakeGenerator, (String)"<this>");
        return $this$cmakeGenerator.getCmake() == null ? "" : (CmakeLocatorKt.isCmakeForkVersion($this$cmakeGenerator.getCmake().getMinimumCmakeVersion()) ? "Android Gradle - Ninja" : "Ninja");
    }

    @Nullable
    public static final <T> T ifCMake(@NotNull CxxModuleModel $this$ifCMake, @NotNull Function0<? extends T> compute) {
        Intrinsics.checkParameterIsNotNull((Object)$this$ifCMake, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(compute, (String)"compute");
        return (T)($this$ifCMake.getBuildSystem() == NativeBuildSystem.CMAKE ? compute.invoke() : null);
    }

    @Nullable
    public static final <T> T ifNdkBuild(@NotNull CxxModuleModel $this$ifNdkBuild, @NotNull Function0<? extends T> compute) {
        Intrinsics.checkParameterIsNotNull((Object)$this$ifNdkBuild, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(compute, (String)"compute");
        return (T)($this$ifNdkBuild.getBuildSystem() == NativeBuildSystem.NDK_BUILD ? compute.invoke() : null);
    }

    @NotNull
    public static final Stl determineUsedStlForCmake(@NotNull CxxModuleModel $this$determineUsedStlForCmake, @NotNull List<? extends CommandLineArgument> arguments) {
        Intrinsics.checkParameterIsNotNull((Object)$this$determineUsedStlForCmake, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        String stlFromArgument = BuildSystemCommandLineKt.getCmakeProperty(arguments, CmakeProperty.ANDROID_STL);
        if (stlFromArgument != null) {
            Stl result2 = Stl.Companion.fromArgumentName(stlFromArgument);
            if (result2 != null) {
                return result2;
            }
            LoggingEnvironmentKt.warnln(Intrinsics.stringPlus((String)"Unable to parse STL from build.gradle arguments: ", (Object)stlFromArgument), new Object[0]);
        }
        return $this$determineUsedStlForCmake.getNdkDefaultStl();
    }

    @NotNull
    public static final Stl determineUsedStlForNdkBuild(@NotNull CxxModuleModel $this$determineUsedStlForNdkBuild, @NotNull List<? extends CommandLineArgument> arguments) {
        Intrinsics.checkParameterIsNotNull((Object)$this$determineUsedStlForNdkBuild, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        String stlFromArgument = BuildSystemCommandLineKt.getNdkBuildProperty(arguments, NdkBuildProperty.APP_STL);
        if (stlFromArgument != null) {
            Stl result2 = Stl.Companion.fromArgumentName(stlFromArgument);
            if (result2 != null) {
                return result2;
            }
            LoggingEnvironmentKt.warnln(Intrinsics.stringPlus((String)"Unable to parse STL from build.gradle arguments: ", (Object)stlFromArgument), new Object[0]);
        }
        String appStl = null;
        File applicationMk = FilesKt.resolveSibling((File)$this$determineUsedStlForNdkBuild.getMakeFile(), (String)"Application.mk");
        if (applicationMk.exists()) {
            Iterator iterator = StringsKt.lines((CharSequence)FilesKt.readText$default((File)applicationMk, null, (int)1, null)).iterator();
            while (iterator.hasNext()) {
                String line;
                String string = line = (String)iterator.next();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                MatchResult matchResult = Regex.find$default((Regex)new Regex("^APP_STL\\s*:?=\\s*(.*)$"), (CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (int)0, (int)2, null);
                if (matchResult == null) continue;
                MatchResult match = matchResult;
                MatchGroup appStlMatch = match.getGroups().get(1);
                boolean bl2 = appStlMatch != null;
                bl = false;
                boolean bl3 = false;
                bl3 = false;
                boolean bl4 = false;
                if (!bl2) {
                    boolean bl5 = false;
                    String string3 = "Failed requirement.";
                    throw (Throwable)new IllegalArgumentException(string3.toString());
                }
                string = appStlMatch.getValue();
                bl = false;
                bl3 = false;
                String it = string;
                boolean bl6 = false;
                CharSequence charSequence = it;
                boolean bl7 = false;
                appStl = charSequence.length() > 0 ? string : null;
            }
            if (appStl != null) {
                Stl result3 = Stl.Companion.fromArgumentName(appStl);
                if (result3 != null) {
                    return result3;
                }
                LoggingEnvironmentKt.warnln("Unable to parse APP_STL from " + applicationMk + ": " + appStl, new Object[0]);
            }
        }
        return $this$determineUsedStlForNdkBuild.getNdkDefaultStl();
    }

    @NotNull
    public static final Stl determineUsedStl(@NotNull CxxModuleModel $this$determineUsedStl, @NotNull List<String> arguments) {
        Intrinsics.checkParameterIsNotNull((Object)$this$determineUsedStl, (String)"<this>");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        Stl stl2 = (Stl)((Object)CxxModuleModelKt.ifCMake($this$determineUsedStl, (Function0)new Function0<Stl>($this$determineUsedStl, arguments){
            final /* synthetic */ CxxModuleModel $this_determineUsedStl;
            final /* synthetic */ List<String> $arguments;
            {
                this.$this_determineUsedStl = $receiver;
                this.$arguments = $arguments;
                super(0);
            }

            @Nullable
            public final Stl invoke() {
                return CxxModuleModelKt.determineUsedStlForCmake(this.$this_determineUsedStl, BuildSystemCommandLineKt.toCmakeArguments(this.$arguments));
            }
        }));
        return stl2 == null ? CxxModuleModelKt.determineUsedStlForNdkBuild($this$determineUsedStl, BuildSystemCommandLineKt.toNdkBuildArguments(arguments)) : stl2;
    }
}

