/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.AndroidXDependencyCheck;
import com.android.build.gradle.internal.utils.ComponentPath;
import com.android.build.gradle.internal.utils.ResolutionResultUtils;
import com.android.build.gradle.options.BooleanOption;
import com.android.builder.errors.IssueReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/build/gradle/internal/dependency/AndroidXDependencyCheck;", "Lorg/gradle/api/Action;", "Lorg/gradle/api/artifacts/ResolvableDependencies;", "configurationName", "", "issueReporter", "Lcom/android/builder/errors/IssueReporter;", "(Ljava/lang/String;Lcom/android/builder/errors/IssueReporter;)V", "execute", "", "resolvableDependencies", "gradle-core"})
public final class AndroidXDependencyCheck
implements Action<ResolvableDependencies> {
    @NotNull
    private final String configurationName;
    @NotNull
    private final IssueReporter issueReporter;

    public AndroidXDependencyCheck(@NotNull String configurationName, @NotNull IssueReporter issueReporter2) {
        Intrinsics.checkParameterIsNotNull((Object)configurationName, (String)"configurationName");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter2, (String)"issueReporter");
        this.configurationName = configurationName;
        this.issueReporter = issueReporter2;
    }

    /*
     * WARNING - void declaration
     */
    public void execute(@NotNull ResolvableDependencies resolvableDependencies) {
        void $this$filterNotTo$iv$iv;
        Collection $this$filterNot$iv;
        String it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)resolvableDependencies, (String)"resolvableDependencies");
        if (this.issueReporter.hasIssue(IssueReporter.Type.ANDROID_X_PROPERTY_NOT_ENABLED)) {
            return;
        }
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolutionResult, (String)"resolvableDependencies.resolutionResult");
        List<ResolvedComponentResult> androidXDependencies2 = ResolutionResultUtils.getModuleComponents(resolutionResult, (Function1<? super ModuleComponentIdentifier, Boolean>)((Function1)execute.androidXDependencies.1.INSTANCE));
        Iterable $this$map$iv = androidXDependencies2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ResolvedComponentResult resolvedComponentResult = (ResolvedComponentResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = ComponentPath.getPathString$default(ResolutionResultUtils.getPathFromRoot((ResolvedComponentResult)it), this.configurationName, null, 2, null);
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)it, (CharSequence)"androidx.databinding:databinding-compiler:", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List pathsToAndroidXDependencies = (List)destination$iv$iv;
        $this$filterNot$iv = pathsToAndroidXDependencies;
        boolean bl = false;
        if (!$this$filterNot$iv.isEmpty()) {
            String message = "Configuration `" + this.configurationName + "` uses AndroidX dependencies, but the `" + BooleanOption.USE_ANDROID_X.getPropertyName() + "` property is not enabled.\nSet `" + BooleanOption.USE_ANDROID_X.getPropertyName() + "=true` in the `gradle.properties` file and retry.\nThe following AndroidX dependencies are detected:\n" + CollectionsKt.joinToString$default((Iterable)pathsToAndroidXDependencies, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            IssueReporter.reportError$default((IssueReporter)this.issueReporter, (IssueReporter.Type)IssueReporter.Type.ANDROID_X_PROPERTY_NOT_ENABLED, (String)message, (String)CollectionsKt.joinToString$default((Iterable)pathsToAndroidXDependencies, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), null, (int)8, null);
        }
    }
}

