/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.options.StringOption;
import java.io.Closeable;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0016\u0010\u0010\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction$LintWorkActionParameters;", "()V", "createClassLoader", "Ljava/net/URLClassLoader;", "execute", "", "getPlatformClassLoader", "Ljava/lang/ClassLoader;", "invokeLintMainRunMethod", "", "classLoader", "arguments", "", "", "runLint", "Companion", "LintWorkActionParameters", "gradle-core"})
public abstract class AndroidLintWorkAction
implements WorkAction<LintWorkActionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ERRNO_SUCCESS = 0;
    private static final int ERRNO_ERRORS = 1;
    private static final int ERRNO_USAGE = 2;
    private static final int ERRNO_EXISTS = 3;
    private static final int ERRNO_HELP = 4;
    private static final int ERRNO_INVALID_ARGS = 5;
    private static final int ERRNO_CREATED_BASELINE = 6;
    private static final int ERRNO_APPLIED_SUGGESTIONS = 7;
    @Nullable
    private static URLClassLoader cachedClassLoader;

    public void execute() {
        Throwable throwable;
        String string;
        Logger logger = Logging.getLogger(this.getClass());
        List arguments = (List)((LintWorkActionParameters)this.getParameters()).getArguments().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)arguments, (String)"arguments");
        logger.debug(Intrinsics.stringPlus((String)"Running lint ", (Object)CollectionsKt.joinToString$default((Iterable)arguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
        logger.info("Max memory for Android Lint: {}m\n(can be configured by {}=2G in gradle.properties)", (Object)(Runtime.getRuntime().maxMemory() / (long)1024 / (long)1024), (Object)StringOption.LINT_HEAP_SIZE.getPropertyName());
        int execResult = this.runLint(arguments);
        logger.debug(Intrinsics.stringPlus((String)"Lint returned ", (Object)execResult));
        if (execResult == 0) {
            return;
        }
        if (!((Boolean)((LintWorkActionParameters)this.getParameters()).getAndroid().get()).booleanValue()) {
            string = "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nlintOptions {\n    abortOnError false\n}\n...";
        } else {
            Object object = ((LintWorkActionParameters)this.getParameters()).getFatalOnly().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.fatalOnly.get()");
            string = (Boolean)object != false ? "Lint found fatal errors while assembling a release target.\n\nTo proceed, either fix the issues identified by lint, or modify your build script as follows:\n...\nandroid {\n    lintOptions {\n        checkReleaseBuilds false\n        // Or, if you prefer, you can continue to check for errors in release builds,\n        // but continue the build even when errors are found:\n        abortOnError false\n    }\n}\n..." : "Lint found errors in the project; aborting build.\n\nFix the issues identified by lint, or add the following to your build script to proceed with errors:\n...\nandroid {\n    lintOptions {\n        abortOnError false\n    }\n}\n...";
        }
        String message = string;
        int n = execResult;
        switch (n) {
            case 1: {
                throwable = new RuntimeException(message);
                break;
            }
            case 2: {
                throwable = new IllegalStateException("Internal Error: Unexpected lint usage");
                break;
            }
            case 3: {
                throw new RuntimeException("Unable to write lint output");
            }
            case 4: {
                throw new IllegalStateException("Internal error: Unexpected lint help call");
            }
            case 5: {
                throw new IllegalStateException("Internal error: Unexpected lint invalid arguments");
            }
            case 6: {
                throw new RuntimeException("Aborting build since new baseline file was created");
            }
            case 7: {
                throw new RuntimeException("Aborting build since sources were modified to apply quickfixes after compilation");
            }
            default: {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Internal error: unexpected lint return value ", (Object)execResult));
            }
        }
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int runLint(List<String> arguments) {
        Object object = ((LintWorkActionParameters)this.getParameters()).getCacheClassLoader().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.cacheClassLoader.get()");
        if (((Boolean)object).booleanValue()) {
            if (cachedClassLoader == null) {
                cachedClassLoader = this.createClassLoader();
            }
            if ((object = cachedClassLoader) == null) {
                Intrinsics.throwNpe();
            }
            return this.invokeLintMainRunMethod((ClassLoader)object, arguments);
        }
        object = this.createClassLoader();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            URLClassLoader it = (URLClassLoader)object;
            boolean bl3 = false;
            int n = this.invokeLintMainRunMethod(it, arguments);
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final URLClassLoader createClassLoader() {
        void $this$mapTo$iv$iv;
        Set set = ((LintWorkActionParameters)this.getParameters()).getClasspath().getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"parameters.classpath.files");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            URL uRL = it.toURI().toURL();
            collection.add(uRL);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        URL[] classpathUrls = uRLArray;
        return new URLClassLoader(classpathUrls, this.getPlatformClassLoader());
    }

    private final int invokeLintMainRunMethod(ClassLoader classLoader, List<String> arguments) {
        Class<?> cls = classLoader.loadClass((String)((LintWorkActionParameters)this.getParameters()).getMainClass().get());
        Class[] classArray = new Class[]{String[].class};
        Method method = cls.getMethod("run", classArray);
        Object lintMain = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Object[] objectArray = new Object[1];
        Collection $this$toTypedArray$iv = arguments;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        if (thisCollection$iv.toArray(new String[0]) == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object object = method.invoke(lintMain, objectArray);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Int");
        }
        int returnValue = (Integer)object;
        Class<?> uastEnvironment = classLoader.loadClass("com.android.tools.lint.UastEnvironment");
        Method disposeMethod = uastEnvironment.getDeclaredMethod("disposeApplicationEnvironment", new Class[0]);
        disposeMethod.invoke(null, new Object[0]);
        return returnValue;
    }

    private final ClassLoader getPlatformClassLoader() {
        Object object = ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.ClassLoader");
        }
        return (ClassLoader)object;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0007R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction$LintWorkActionParameters;", "Lorg/gradle/workers/WorkParameters;", "()V", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "arguments", "Lorg/gradle/api/provider/ListProperty;", "", "getArguments", "()Lorg/gradle/api/provider/ListProperty;", "cacheClassLoader", "getCacheClassLoader", "classpath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "fatalOnly", "getFatalOnly", "mainClass", "getMainClass", "gradle-core"})
    public static abstract class LintWorkActionParameters
    implements WorkParameters {
        @NotNull
        public abstract Property<String> getMainClass();

        @NotNull
        public abstract ListProperty<String> getArguments();

        @NotNull
        public abstract ConfigurableFileCollection getClasspath();

        @NotNull
        public abstract Property<Boolean> getAndroid();

        @NotNull
        public abstract Property<Boolean> getFatalOnly();

        @NotNull
        public abstract Property<Boolean> getCacheClassLoader();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/lint/AndroidLintWorkAction$Companion;", "", "()V", "ERRNO_APPLIED_SUGGESTIONS", "", "ERRNO_CREATED_BASELINE", "ERRNO_ERRORS", "ERRNO_EXISTS", "ERRNO_HELP", "ERRNO_INVALID_ARGS", "ERRNO_SUCCESS", "ERRNO_USAGE", "cachedClassLoader", "Ljava/net/URLClassLoader;", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

