/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.lint;

import com.android.build.gradle.internal.ide.dependencies.ArtifactHandler;
import com.android.build.gradle.internal.ide.dependencies.ResolvedArtifact;
import com.android.build.gradle.internal.lint.DependencyCaches;
import com.android.build.gradle.internal.lint.ExternalLintModelArtifactHandler;
import com.android.build.gradle.internal.lint.ProjectKey;
import com.android.build.gradle.internal.lint.ProjectKeyKt;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.caching.CreatingCache;
import com.android.tools.lint.model.DefaultLintModelAndroidLibrary;
import com.android.tools.lint.model.DefaultLintModelJavaLibrary;
import com.android.tools.lint.model.DefaultLintModelMavenName;
import com.android.tools.lint.model.DefaultLintModelModuleLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.ArtifactCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&Bq\b\u0002\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0004\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000b\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\fH\u0002JT\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0014JX\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0014J4\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0014J0\u0010#\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0014J\f\u0010$\u001a\u00020%*\u00020\tH\u0002R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/build/gradle/internal/lint/ExternalLintModelArtifactHandler;", "Lcom/android/build/gradle/internal/ide/dependencies/ArtifactHandler;", "Lcom/android/tools/lint/model/LintModelLibrary;", "localJarCache", "Lcom/android/ide/common/caching/CreatingCache;", "Ljava/io/File;", "", "mavenCoordinatesCache", "Lcom/android/build/gradle/internal/ide/dependencies/ResolvedArtifact;", "Lcom/android/builder/model/MavenCoordinates;", "projectExplodedAarsMap", "", "Lcom/android/build/gradle/internal/lint/ProjectKey;", "projectJarsMap", "baseModuleModelFileMap", "(Lcom/android/ide/common/caching/CreatingCache;Lcom/android/ide/common/caching/CreatingCache;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getProjectJar", "key", "handleAndroidLibrary", "aarFile", "folder", "localJavaLibraries", "isProvided", "", "variantName", "", "coordinatesSupplier", "Lkotlin/Function0;", "addressSupplier", "handleAndroidModule", "projectPath", "buildId", "lintJar", "handleJavaLibrary", "jarFile", "handleJavaModule", "toMavenName", "Lcom/android/tools/lint/model/LintModelMavenName;", "Companion", "gradle-core"})
public final class ExternalLintModelArtifactHandler
extends ArtifactHandler<LintModelLibrary> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CreatingCache<File, List<File>> localJarCache;
    @NotNull
    private final Map<ProjectKey, File> projectExplodedAarsMap;
    @NotNull
    private final Map<ProjectKey, File> projectJarsMap;
    @NotNull
    private final Map<ProjectKey, File> baseModuleModelFileMap;

    private ExternalLintModelArtifactHandler(CreatingCache<File, List<File>> localJarCache2, CreatingCache<ResolvedArtifact, MavenCoordinates> mavenCoordinatesCache, Map<ProjectKey, ? extends File> projectExplodedAarsMap, Map<ProjectKey, ? extends File> projectJarsMap, Map<ProjectKey, ? extends File> baseModuleModelFileMap) {
        super(localJarCache2, mavenCoordinatesCache);
        this.localJarCache = localJarCache2;
        this.projectExplodedAarsMap = projectExplodedAarsMap;
        this.projectJarsMap = projectJarsMap;
        this.baseModuleModelFileMap = baseModuleModelFileMap;
    }

    @Override
    @NotNull
    protected LintModelLibrary handleAndroidLibrary(@NotNull File aarFile, @NotNull File folder, @NotNull List<? extends File> localJavaLibraries, boolean isProvided, @Nullable String variantName, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkParameterIsNotNull((Object)aarFile, (String)"aarFile");
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        Intrinsics.checkParameterIsNotNull(localJavaLibraries, (String)"localJavaLibraries");
        Intrinsics.checkParameterIsNotNull(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkParameterIsNotNull(addressSupplier, (String)"addressSupplier");
        String[] stringArray = new String[]{"jars", "classes.jar"};
        return (LintModelLibrary)new DefaultLintModelAndroidLibrary(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)FileUtils.join((File)folder, (String[])stringArray)), (Iterable)localJavaLibraries), (String)addressSupplier.invoke(), new File(folder, "AndroidManifest.xml"), folder, new File(folder, "res"), new File(folder, "assets"), new File(folder, "lint.jar"), new File(folder, "public.txt"), new File(folder, "R.txt"), new File(folder, "annotations.zip"), new File(folder, "proguard.txt"), isProvided, this.toMavenName((MavenCoordinates)coordinatesSupplier2.invoke()));
    }

    @Override
    @NotNull
    protected LintModelLibrary handleAndroidModule(@NotNull String projectPath, @NotNull String buildId, @Nullable String variantName, @NotNull File aarFile, @Nullable File lintJar, boolean isProvided, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> addressSupplier) {
        Iterable iterable;
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull((Object)aarFile, (String)"aarFile");
        Intrinsics.checkParameterIsNotNull(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkParameterIsNotNull(addressSupplier, (String)"addressSupplier");
        ProjectKey key = new ProjectKey(buildId, projectPath, variantName);
        Object object = this.projectExplodedAarsMap.get(key);
        if (object == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"unable to find project exploded aar for ", (Object)key));
        }
        String[] folder = object;
        object = new String[]{"jars", "classes.jar"};
        Collection collection = CollectionsKt.listOf((Object)FileUtils.join((File)folder, (String[])object));
        object = (List)this.localJarCache.get((Object)folder);
        if (object == null) {
            boolean bl = false;
            iterable = CollectionsKt.emptyList();
        } else {
            iterable = (Iterable)object;
        }
        return (LintModelLibrary)new DefaultLintModelAndroidLibrary(CollectionsKt.plus((Collection)collection, (Iterable)iterable), (String)addressSupplier.invoke(), new File((File)folder, "AndroidManifest.xml"), (File)folder, new File((File)folder, "res"), new File((File)folder, "assets"), new File((File)folder, "lint.jar"), new File((File)folder, "public.txt"), new File((File)folder, "R.txt"), new File((File)folder, "annotations.zip"), new File((File)folder, "proguard.txt"), isProvided, this.toMavenName((MavenCoordinates)coordinatesSupplier2.invoke()));
    }

    @Override
    @NotNull
    protected LintModelLibrary handleJavaLibrary(@NotNull File jarFile, boolean isProvided, @NotNull Function0<? extends MavenCoordinates> coordinatesSupplier2, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkParameterIsNotNull((Object)jarFile, (String)"jarFile");
        Intrinsics.checkParameterIsNotNull(coordinatesSupplier2, (String)"coordinatesSupplier");
        Intrinsics.checkParameterIsNotNull(addressSupplier, (String)"addressSupplier");
        return (LintModelLibrary)new DefaultLintModelJavaLibrary((String)addressSupplier.invoke(), CollectionsKt.listOf((Object)jarFile), this.toMavenName((MavenCoordinates)coordinatesSupplier2.invoke()), isProvided);
    }

    @Override
    @NotNull
    protected LintModelLibrary handleJavaModule(@NotNull String projectPath, @NotNull String buildId, @Nullable String variantName, @NotNull Function0<String> addressSupplier) {
        Intrinsics.checkParameterIsNotNull((Object)projectPath, (String)"projectPath");
        Intrinsics.checkParameterIsNotNull((Object)buildId, (String)"buildId");
        Intrinsics.checkParameterIsNotNull(addressSupplier, (String)"addressSupplier");
        String artifactAddress = (String)addressSupplier.invoke();
        ProjectKey key = new ProjectKey(buildId, projectPath, variantName);
        Map<ProjectKey, File> map = this.baseModuleModelFileMap;
        boolean bl = false;
        Map<ProjectKey, File> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(key)) {
            return (LintModelLibrary)new DefaultLintModelModuleLibrary((String)addressSupplier.invoke(), projectPath, null, false);
        }
        File jar = this.getProjectJar(key);
        return (LintModelLibrary)new DefaultLintModelJavaLibrary(artifactAddress, CollectionsKt.listOf((Object)jar), (LintModelMavenName)LintModelMavenName.Companion.getNONE(), false);
    }

    private final LintModelMavenName toMavenName(MavenCoordinates $this$toMavenName) {
        return (LintModelMavenName)new DefaultLintModelMavenName($this$toMavenName.getGroupId(), $this$toMavenName.getArtifactId(), $this$toMavenName.getVersion());
    }

    private final File getProjectJar(ProjectKey key) {
        File file = this.projectJarsMap.get(key);
        if (file == null) {
            String string = "Could not find jar for project " + key + '\n' + this.projectJarsMap.keySet().size() + " known projects: \n" + CollectionsKt.joinToString$default((Iterable)this.projectJarsMap.entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)getProjectJar.1.INSTANCE, (int)30, null);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return file;
    }

    public /* synthetic */ ExternalLintModelArtifactHandler(CreatingCache localJarCache2, CreatingCache mavenCoordinatesCache, Map projectExplodedAarsMap, Map projectJarsMap, Map baseModuleModelFileMap, DefaultConstructorMarker $constructor_marker) {
        this((CreatingCache<File, List<File>>)localJarCache2, (CreatingCache<ResolvedArtifact, MavenCoordinates>)mavenCoordinatesCache, projectExplodedAarsMap, projectJarsMap, baseModuleModelFileMap);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J[\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0010H\u0000\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/lint/ExternalLintModelArtifactHandler$Companion;", "", "()V", "create", "Lcom/android/build/gradle/internal/lint/ExternalLintModelArtifactHandler;", "dependencyCaches", "Lcom/android/build/gradle/internal/lint/DependencyCaches;", "projectExplodedAars", "Lorg/gradle/api/artifacts/ArtifactCollection;", "testedProjectExplodedAars", "compileProjectJars", "runtimeProjectJars", "baseModuleModelFile", "buildMapping", "Lcom/google/common/collect/ImmutableMap;", "", "Lcom/android/build/gradle/internal/ide/dependencies/BuildMapping;", "create$gradle_core", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExternalLintModelArtifactHandler create$gradle_core(@NotNull DependencyCaches dependencyCaches, @Nullable ArtifactCollection projectExplodedAars, @Nullable ArtifactCollection testedProjectExplodedAars, @NotNull ArtifactCollection compileProjectJars, @NotNull ArtifactCollection runtimeProjectJars, @Nullable ArtifactCollection baseModuleModelFile, @NotNull ImmutableMap<String, String> buildMapping) {
            Intrinsics.checkParameterIsNotNull((Object)dependencyCaches, (String)"dependencyCaches");
            Intrinsics.checkParameterIsNotNull((Object)compileProjectJars, (String)"compileProjectJars");
            Intrinsics.checkParameterIsNotNull((Object)runtimeProjectJars, (String)"runtimeProjectJars");
            Intrinsics.checkParameterIsNotNull(buildMapping, (String)"buildMapping");
            Object projectExplodedAarsMap = null;
            ArtifactCollection artifactCollection = projectExplodedAars;
            ArtifactCollection artifactCollection2 = artifactCollection == null ? null : ProjectKeyKt.asProjectKeyedMap(artifactCollection, buildMapping);
            projectExplodedAarsMap = artifactCollection2 == null ? MapsKt.emptyMap() : artifactCollection2;
            artifactCollection2 = testedProjectExplodedAars;
            if (artifactCollection2 != null) {
                artifactCollection = artifactCollection2;
                boolean bl = false;
                boolean bl2 = false;
                ArtifactCollection it = artifactCollection;
                boolean bl3 = false;
                projectExplodedAarsMap = MapsKt.plus((Map)projectExplodedAarsMap, ProjectKeyKt.asProjectKeyedMap(it, buildMapping));
            }
            Map projectJarsMap = MapsKt.plus(ProjectKeyKt.asProjectKeyedMap(compileProjectJars, buildMapping), ProjectKeyKt.asProjectKeyedMap(runtimeProjectJars, buildMapping));
            ArtifactCollection artifactCollection3 = baseModuleModelFile;
            Map<ProjectKey, File> map = artifactCollection3 == null ? null : ProjectKeyKt.asProjectKeyedMap(artifactCollection3, buildMapping);
            Map<ProjectKey, File> baseModuleModelFileMap = map == null ? MapsKt.emptyMap() : map;
            CreatingCache<File, List<File>> creatingCache = dependencyCaches.getLocalJarCache();
            CreatingCache<ResolvedArtifact, MavenCoordinates> creatingCache2 = dependencyCaches.getMavenCoordinatesCache();
            map = Collections.unmodifiableMap(projectExplodedAarsMap);
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"unmodifiableMap(projectExplodedAarsMap)");
            Map<ProjectKey, File> map2 = map;
            map = Collections.unmodifiableMap(projectJarsMap);
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"unmodifiableMap(projectJarsMap)");
            Map<ProjectKey, File> map3 = map;
            map = Collections.unmodifiableMap(baseModuleModelFileMap);
            Intrinsics.checkExpressionValueIsNotNull(map, (String)"unmodifiableMap(baseModuleModelFileMap)");
            return new ExternalLintModelArtifactHandler(creatingCache, creatingCache2, map2, map3, map, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

