/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.services;

import com.android.SdkConstants;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2DaemonManagerMaintainer;
import com.android.build.gradle.internal.services.Aapt2DaemonServiceKey;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.services.Aapt2ThreadPoolBuildServiceKt;
import com.android.build.gradle.internal.services.PartialInProcessResourceProcessor;
import com.android.build.gradle.internal.services.ServiceRegistrationAction;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.builder.internal.aapt.v2.Aapt2DaemonImpl;
import com.android.builder.internal.aapt.v2.Aapt2DaemonManager;
import com.android.utils.ILogger;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0016\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u0013R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService$Parameters;", "Ljava/lang/AutoCloseable;", "()V", "closer", "Lcom/google/common/io/Closer;", "kotlin.jvm.PlatformType", "logger", "Lcom/android/utils/ILogger;", "registeredServices", "", "Lcom/android/build/gradle/internal/services/Aapt2DaemonServiceKey;", "services", "", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "close", "", "getAapt2ExecutablePath", "Ljava/nio/file/Path;", "aapt2", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "getLeasingAapt2", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "aapt2Input", "getManager", "key", "aaptExecutablePath", "registerAaptService", "aapt2Version", "", "Parameters", "RegistrationAction", "gradle-core"})
public abstract class Aapt2DaemonBuildService
implements BuildService<Parameters>,
AutoCloseable {
    @NotNull
    private final Set<Aapt2DaemonServiceKey> registeredServices;
    @NotNull
    private final Map<Aapt2DaemonServiceKey, Aapt2DaemonManager> services;
    private final Closer closer;
    @NotNull
    private final ILogger logger;

    public Aapt2DaemonBuildService() {
        boolean bl = false;
        this.registeredServices = new LinkedHashSet();
        bl = false;
        this.services = new LinkedHashMap();
        this.closer = Closer.create();
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"getLogger(this.javaClass)");
        this.logger = loggerWrapper;
    }

    @NotNull
    public final Aapt2 getLeasingAapt2(@NotNull Aapt2Input aapt2Input) {
        Intrinsics.checkParameterIsNotNull((Object)aapt2Input, (String)"aapt2Input");
        Object object = aapt2Input.getVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"aapt2Input.version.get()");
        Aapt2DaemonManager manager = this.getManager(new Aapt2DaemonServiceKey((String)object), this.getAapt2ExecutablePath(aapt2Input));
        Aapt2 leasingAapt2 = manager.getLeasingAapt2Daemon();
        if (!((Boolean)aapt2Input.getUseJvmResourceCompiler().get()).booleanValue()) {
            return leasingAapt2;
        }
        return new PartialInProcessResourceProcessor(leasingAapt2);
    }

    @NotNull
    public final synchronized Aapt2DaemonServiceKey registerAaptService(@NotNull String aapt2Version, @NotNull Path aaptExecutablePath) {
        Intrinsics.checkParameterIsNotNull((Object)aapt2Version, (String)"aapt2Version");
        Intrinsics.checkParameterIsNotNull((Object)aaptExecutablePath, (String)"aaptExecutablePath");
        Aapt2DaemonServiceKey key = new Aapt2DaemonServiceKey(aapt2Version);
        if (this.registeredServices.add(key)) {
            Aapt2DaemonManager manager = this.getManager(key, aaptExecutablePath);
            this.closer.register(Aapt2Daemon.getAapt2DaemonServiceRegistry().registerServiceAsCloseable(key, manager));
        }
        return key;
    }

    private final synchronized Aapt2DaemonManager getManager(Aapt2DaemonServiceKey key, Path aaptExecutablePath) {
        Aapt2DaemonManager aapt2DaemonManager;
        Map<Aapt2DaemonServiceKey, Aapt2DaemonManager> $this$getOrPut$iv = this.services;
        boolean $i$f$getOrPut = false;
        Aapt2DaemonManager value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            boolean bl = false;
            Aapt2DaemonManager answer$iv = new Aapt2DaemonManager(this.logger, (Function1)new Function1<Integer, com.android.builder.internal.aapt.v2.Aapt2Daemon>(aaptExecutablePath, this){
                final /* synthetic */ Path $aaptExecutablePath;
                final /* synthetic */ Aapt2DaemonBuildService this$0;
                {
                    this.$aaptExecutablePath = $aaptExecutablePath;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final com.android.builder.internal.aapt.v2.Aapt2Daemon invoke(int displayId) {
                    return (com.android.builder.internal.aapt.v2.Aapt2Daemon)new Aapt2DaemonImpl(Intrinsics.stringPlus((String)"#", (Object)displayId), this.$aaptExecutablePath, Aapt2Daemon.access$getDaemonTimeouts$p(), Aapt2DaemonBuildService.access$getLogger$p(this.this$0));
                }
            }, Aapt2Daemon.access$getDaemonExpiryTimeSeconds$p(), TimeUnit.SECONDS, (Aapt2DaemonManager.Listener)new Aapt2DaemonManagerMaintainer(), null, 32, null);
            $this$getOrPut$iv.put(key, answer$iv);
            aapt2DaemonManager = answer$iv;
        } else {
            aapt2DaemonManager = value$iv;
        }
        Aapt2DaemonManager aapt2DaemonManager2 = aapt2DaemonManager;
        boolean bl = false;
        boolean bl2 = false;
        Aapt2DaemonManager it = aapt2DaemonManager2;
        boolean bl3 = false;
        this.closer.register(new Closeable(it){
            final /* synthetic */ Aapt2DaemonManager $it;
            {
                this.$it = $it;
            }

            public final void close() {
                this.$it.shutdown();
            }
        });
        return aapt2DaemonManager2;
    }

    @NotNull
    public final Path getAapt2ExecutablePath(@NotNull Aapt2Input aapt2) {
        Intrinsics.checkParameterIsNotNull((Object)aapt2, (String)"aapt2");
        Path path = aapt2.getBinaryDirectory().getSingleFile().toPath().resolve(SdkConstants.FN_AAPT2);
        boolean bl = false;
        boolean bl2 = false;
        Path it = path;
        boolean bl3 = false;
        if (!Files.exists(it, new LinkOption[0])) {
            throw new InvalidUserDataException("Specified AAPT2 executable does not exist: " + it + ". Must supply one of aapt2 from maven or custom location.");
        }
        Path path2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"aapt2.binaryDirectory.singleFile.toPath().resolve(SdkConstants.FN_AAPT2).also {\n            if (!Files.exists(it)) {\n                throw InvalidUserDataException(\n                    \"Specified AAPT2 executable does not exist: $it. \"\n                            + \"Must supply one of aapt2 from maven or custom location.\"\n                )\n            }\n        }");
        return path2;
    }

    @Override
    public void close() {
        this.closer.close();
    }

    public static final /* synthetic */ ILogger access$getLogger$p(Aapt2DaemonBuildService $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService$Parameters;", "Lorg/gradle/api/services/BuildServiceParameters;", "()V", "errorFormatMode", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "getErrorFormatMode", "()Lorg/gradle/api/provider/Property;", "gradle-core"})
    public static abstract class Parameters
    implements BuildServiceParameters {
        @NotNull
        public abstract Property<SyncOptions.ErrorFormatMode> getErrorFormatMode();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService$RegistrationAction;", "Lcom/android/build/gradle/internal/services/ServiceRegistrationAction;", "Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService;", "Lcom/android/build/gradle/internal/services/Aapt2DaemonBuildService$Parameters;", "project", "Lorg/gradle/api/Project;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "(Lorg/gradle/api/Project;Lcom/android/build/gradle/options/ProjectOptions;)V", "getProjectOptions", "()Lcom/android/build/gradle/options/ProjectOptions;", "configure", "", "parameters", "gradle-core"})
    public static final class RegistrationAction
    extends ServiceRegistrationAction<Aapt2DaemonBuildService, Parameters> {
        @NotNull
        private final ProjectOptions projectOptions;

        public RegistrationAction(@NotNull Project project2, @NotNull ProjectOptions projectOptions) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
            super(project2, Aapt2DaemonBuildService.class, Aapt2ThreadPoolBuildServiceKt.computeMaxAapt2Daemons(projectOptions));
            this.projectOptions = projectOptions;
        }

        @NotNull
        public final ProjectOptions getProjectOptions() {
            return this.projectOptions;
        }

        @Override
        public void configure(@NotNull Parameters parameters) {
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            parameters.getErrorFormatMode().set((Object)SyncOptions.getErrorFormatMode(this.projectOptions));
        }
    }
}

