/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.ProjectInfo;
import com.android.build.gradle.internal.tasks.AndroidTestTask;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.test.report.CompositeTestResults;
import com.android.build.gradle.internal.test.report.ReportType;
import com.android.build.gradle.internal.test.report.TestReport;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.utils.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.logging.ConsoleRenderer;

public abstract class AndroidReportTask
extends DefaultTask
implements AndroidTestTask {
    private final transient List<AndroidTestTask> subTasks = Lists.newArrayList();
    private final List<File> resultsDirectories = Lists.newArrayList();
    private ReportType reportType;
    private boolean ignoreFailures;
    private boolean testFailed;

    @OutputDirectory
    public abstract DirectoryProperty getReportsDir();

    @Override
    @OutputDirectory
    public abstract DirectoryProperty getResultsDir();

    @Override
    @Internal
    public boolean getTestFailed() {
        return this.testFailed;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Input
    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public void addTask(AndroidTestTask task) {
        this.subTasks.add(task);
        this.resultsDirectories.add(((Directory)task.getResultsDir().get()).getAsFile());
        this.dependsOn(new Object[]{task});
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getResultsDirectories() {
        return this.resultsDirectories;
    }

    public void setWillRun() {
        for (AndroidTestTask task : this.subTasks) {
            task.setIgnoreFailures(true);
        }
    }

    @TaskAction
    public void createReport() throws IOException {
        File resultsOutDir = ((Directory)this.getResultsDir().get()).getAsFile();
        File reportOutDir = ((Directory)this.getResultsDir().get()).getAsFile();
        FileUtils.cleanOutputDir((File)resultsOutDir);
        FileUtils.cleanOutputDir((File)reportOutDir);
        this.copyResults(resultsOutDir);
        TestReport report = new TestReport(this.reportType, resultsOutDir, reportOutDir);
        CompositeTestResults compositeTestResults = report.generateReport();
        if (!compositeTestResults.getFailures().isEmpty()) {
            this.testFailed = true;
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(new File(reportOutDir, "index.html"));
            String message = "There were failing tests. See the report at: " + reportUrl;
            if (this.getIgnoreFailures()) {
                this.getLogger().warn(message);
            } else {
                throw new GradleException(message);
            }
        }
    }

    private void copyResults(File reportOutDir) throws IOException {
        List<File> resultDirectories = this.getResultsDirectories();
        for (File directory2 : resultDirectories) {
            FileUtils.copyDirectory((File)directory2, (File)reportOutDir);
        }
    }

    public static class CreationAction
    extends TaskCreationAction<AndroidReportTask> {
        private final GlobalScope scope;
        private final TaskKind taskKind;
        private final ProjectInfo projectInfo;

        public CreationAction(GlobalScope scope, TaskKind taskKind, ProjectInfo projectInfo) {
            this.scope = scope;
            this.taskKind = taskKind;
            this.projectInfo = projectInfo;
        }

        @Override
        public String getName() {
            return (this.taskKind == TaskKind.CONNECTED ? "connected" : "device") + "AndroidTest";
        }

        @Override
        public Class<AndroidReportTask> getType() {
            return AndroidReportTask.class;
        }

        @Override
        public void configure(AndroidReportTask task) {
            task.setGroup("verification");
            task.setDescription(this.taskKind == TaskKind.CONNECTED ? "Installs and runs instrumentation tests for all flavors on connected devices." : "Installs and runs instrumentation tests using all Device Providers.");
            task.setReportType(ReportType.MULTI_FLAVOR);
            String defaultReportsDir = this.scope.getReportsDir().getAbsolutePath() + "/" + "androidTests";
            String defaultResultsDir = this.scope.getOutputsDir().getAbsolutePath() + "/" + "androidTest-results";
            String subfolderName = this.taskKind == TaskKind.CONNECTED ? "/connected/" : "/devices/";
            HasConfigurableValuesKt.setDisallowChanges(task.getResultsDir(), task.getProject().provider(() -> {
                String dir = this.scope.getExtension().getTestOptions().getResultsDir();
                String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultResultsDir;
                return this.projectInfo.getProject().getLayout().getProjectDirectory().dir(rootLocation + subfolderName + "all");
            }));
            HasConfigurableValuesKt.setDisallowChanges(task.getReportsDir(), task.getProject().provider(() -> {
                String dir = this.scope.getExtension().getTestOptions().getReportDir();
                String rootLocation = dir != null && !dir.isEmpty() ? dir : defaultReportsDir;
                return this.projectInfo.getProject().getLayout().getProjectDirectory().dir(rootLocation + subfolderName + "all");
            }));
        }

        public static enum TaskKind {
            CONNECTED,
            DEVICE_PROVIDER;

        }
    }
}

