/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.Version;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.tasks.AppMetadataTask;
import com.android.build.gradle.internal.tasks.AppMetadataTaskKt;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.internal.tasks.VariantAwareTaskKt;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b'\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "agpVersion", "Lorg/gradle/api/provider/Property;", "", "getAgpVersion", "()Lorg/gradle/api/provider/Property;", "appMetadataVersion", "getAppMetadataVersion", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "doTaskAction", "", "Companion", "CreationAction", "gradle-core"})
public abstract class AppMetadataTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String APP_METADATA_VERSION = "1.0";

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Input
    @NotNull
    public abstract Property<String> getAppMetadataVersion();

    @Input
    @NotNull
    public abstract Property<String> getAgpVersion();

    @Override
    protected void doTaskAction() {
        File appMetadataFile = ((RegularFile)this.getOutputFile().get()).getAsFile();
        FileUtils.deleteIfExists((File)appMetadataFile);
        Files.createParentDirs((File)appMetadataFile);
        Intrinsics.checkExpressionValueIsNotNull((Object)appMetadataFile, (String)"appMetadataFile");
        Object object = this.getAppMetadataVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"appMetadataVersion.get()");
        String string = (String)object;
        object = this.getAgpVersion().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"agpVersion.get()");
        AppMetadataTaskKt.writeAppMetadataFile(appMetadataFile, string, (String)object);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0016\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AppMetadataTask;", "creationConfig", "Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;", "(Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;)V", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "variantName", "", "name", "(Lcom/android/build/api/artifact/impl/ArtifactsImpl;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends TaskCreationAction<AppMetadataTask> {
        @NotNull
        private final ArtifactsImpl artifacts;
        @NotNull
        private final String variantName;
        @NotNull
        private final String name;
        @NotNull
        private final Class<AppMetadataTask> type;

        public CreationAction(@NotNull ArtifactsImpl artifacts2, @NotNull String variantName, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)artifacts2, (String)"artifacts");
            Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.artifacts = artifacts2;
            this.variantName = variantName;
            this.name = name;
            this.type = AppMetadataTask.class;
        }

        public /* synthetic */ CreationAction(ArtifactsImpl artifactsImpl, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = "writeAppMetadata";
            }
            this(artifactsImpl, string, string2);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public CreationAction(@NotNull ApplicationCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            this(creationConfig.getArtifacts(), creationConfig.getName(), creationConfig.computeTaskName("write", "AppMetadata"));
        }

        @Override
        @NotNull
        public Class<AppMetadataTask> getType() {
            return this.type;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AppMetadataTask> taskProvider) {
            Intrinsics.checkParameterIsNotNull(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.artifacts.setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("app-metadata.properties").on(InternalArtifactType.APP_METADATA.INSTANCE);
        }

        @Override
        public void configure(@NotNull AppMetadataTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            VariantAwareTask variantAwareTask = task;
            Project project2 = task.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"task.project");
            VariantAwareTaskKt.configureVariantProperties(variantAwareTask, this.variantName, project2);
            HasConfigurableValuesKt.setDisallowChanges(task.getAppMetadataVersion(), AppMetadataTask.APP_METADATA_VERSION);
            HasConfigurableValuesKt.setDisallowChanges(task.getAgpVersion(), Version.ANDROID_GRADLE_PLUGIN_VERSION);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask$Companion;", "", "()V", "APP_METADATA_VERSION", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

