/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.Charsets;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\rH\u0007J2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00150\u0014H\u0002R \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048G@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "<set-?>", "Ljava/io/File;", "fakeOutputDir", "getFakeOutputDir", "()Ljava/io/File;", "featureTransitiveDeps", "Lorg/gradle/api/artifacts/ArtifactCollection;", "doTaskAction", "", "getFeatureTransitiveDepsFiles", "Lorg/gradle/api/file/FileCollection;", "updateLibraryMap", "", "file", "projectPath", "", "map", "", "", "CreationAction", "gradle-core"})
public abstract class CheckMultiApkLibrariesTask
extends NonIncrementalTask {
    private ArtifactCollection featureTransitiveDeps;
    private File fakeOutputDir;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getFeatureTransitiveDepsFiles() {
        ArtifactCollection artifactCollection = this.featureTransitiveDeps;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureTransitiveDeps");
            throw null;
        }
        FileCollection fileCollection2 = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"featureTransitiveDeps.artifactFiles");
        return fileCollection2;
    }

    @OutputDirectory
    @NotNull
    public final File getFakeOutputDir() {
        File file = this.fakeOutputDir;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fakeOutputDir");
        throw null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected void doTaskAction() {
        var2_1 = false;
        map = new LinkedHashMap<K, V>();
        found = false;
        var4_3 = this.featureTransitiveDeps;
        if (var4_3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"featureTransitiveDeps");
            throw null;
        }
        var3_4 = var4_3.iterator();
        while (var3_4.hasNext()) {
            artifact = (ResolvedArtifactResult)var3_4.next();
            if (!(artifact.getId().getComponentIdentifier() instanceof ProjectComponentIdentifier)) {
                throw new GradleException(Intrinsics.stringPlus((String)artifact.getId().getComponentIdentifier().getDisplayName(), (Object)" is not a Gradle project."));
            }
            var6_6 /* !! */  = artifact.getId().getComponentIdentifier();
            if (var6_6 /* !! */  == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ProjectComponentIdentifier");
            }
            projectPath = ((ProjectComponentIdentifier)var6_6 /* !! */ ).getProjectPath();
            if (!artifact.getFile().isFile()) continue;
            if (found) ** GOTO lbl-1000
            var6_6 /* !! */  = artifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)var6_6 /* !! */ , (String)"artifact.file");
            Intrinsics.checkExpressionValueIsNotNull((Object)projectPath, (String)"projectPath");
            if (this.updateLibraryMap((File)var6_6 /* !! */ , projectPath, map)) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            found = v0;
        }
        if (found) {
            output = new StringBuilder();
            var5_5 = MapsKt.toSortedMap((Map)map);
            var6_7 = false;
            var4_3 = var5_5.entrySet().iterator();
            while (var4_3.hasNext()) {
                var7_10 = var5_5 = (Map.Entry)var4_3.next();
                var8_12 = false;
                library = (String)var7_10.getKey();
                var8_11 = var5_5;
                var9_13 = false;
                projectPaths = (List)var8_11.getValue();
                if (projectPaths.size() <= 1) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)projectPaths, (String)"projectPaths");
                output.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)projectPaths), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null)).append(" all package the same library [" + library + "].\n");
            }
            output.append("\nMultiple APKs packaging the same library can cause runtime errors.\nPlacing each of the above libraries in its own dynamic feature and adding that\nfeature as a dependency of modules requiring it will resolve this issue.\nLibraries that are always used together can be combined into a single feature\nmodule to be imported by their dependents. If a library is required by all\nfeature modules it can be added to the base module instead.");
            throw new GradleException(output.toString());
        }
    }

    private final boolean updateLibraryMap(File file, String projectPath, Map<String, List<String>> map) {
        boolean found = false;
        for (String library : Files.readLines((File)file, (Charset)Charsets.UTF_8)) {
            List<String> list;
            Intrinsics.checkExpressionValueIsNotNull((Object)library, (String)"library");
            String libraryWithoutVariant = StringsKt.substringBeforeLast$default((String)library, (String)"::", null, (int)2, null);
            if (map.containsKey(libraryWithoutVariant)) {
                found = true;
                list = map.get(libraryWithoutVariant);
                if (list == null) continue;
                list.add(projectPath);
                continue;
            }
            list = map;
            Object object = new String[]{projectPath};
            object = CollectionsKt.mutableListOf((Object[])object);
            boolean bl = false;
            list.put(libraryWithoutVariant, object);
        }
        return found;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/CheckMultiApkLibrariesTask;", "Lcom/android/build/gradle/internal/component/ComponentCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ComponentCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<CheckMultiApkLibrariesTask, ComponentCreationConfig> {
        public CreationAction(@NotNull ComponentCreationConfig creationConfig) {
            Intrinsics.checkParameterIsNotNull((Object)creationConfig, (String)"creationConfig");
            super(creationConfig, false);
        }

        @Override
        @NotNull
        public String getName() {
            return this.computeTaskName("check", "Libraries");
        }

        @Override
        @NotNull
        public Class<CheckMultiApkLibrariesTask> getType() {
            return CheckMultiApkLibrariesTask.class;
        }

        @Override
        public void configure(@NotNull CheckMultiApkLibrariesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
            super.configure((Task)task);
            task.featureTransitiveDeps = VariantDependencies.getArtifactCollection$default(this.creationConfig.getVariantDependencies(), AndroidArtifacts.ConsumedConfigType.REVERSE_METADATA_VALUES, AndroidArtifacts.ArtifactScope.PROJECT, AndroidArtifacts.ArtifactType.PACKAGED_DEPENDENCIES, null, 8, null);
            String[] stringArray = new String[]{"check-libraries", this.creationConfig.getDirName()};
            File file = FileUtils.join((File)this.creationConfig.getGlobalScope().getIntermediatesDir(), (String[])stringArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"join(\n                        creationConfig.globalScope.intermediatesDir,\n                        \"check-libraries\",\n                        creationConfig.dirName\n                    )");
            task.fakeOutputDir = file;
        }
    }
}

