/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.transform.TransformException;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.crash.PluginCrashReporter;
import com.android.build.gradle.internal.errors.MessageReceiverImpl;
import com.android.build.gradle.internal.profile.ProfileAwareWorkAction;
import com.android.build.gradle.internal.tasks.DexMergingTask;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexArchiveMerger;
import com.android.builder.dexing.DexEntryBucket;
import com.android.builder.dexing.DexingType;
import com.android.ide.common.blame.MessageReceiver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@VisibleForTesting
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0005H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingWorkAction;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction;", "Lcom/android/build/gradle/internal/tasks/DexMergingWorkAction$Params;", "()V", "merge", "", "sharedParams", "Lcom/android/build/gradle/internal/tasks/DexMergingTask$SharedParams;", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "dexArchiveEntries", "", "Lcom/android/builder/dexing/DexArchiveEntry;", "outputDir", "Ljava/io/File;", "mainDexListOutput", "Ljava/nio/file/Path;", "run", "Params", "gradle-core"})
public abstract class DexMergingWorkAction
extends ProfileAwareWorkAction<Params> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List dexArchiveEntries = ((DexEntryBucket)((Params)this.getParameters()).getDexEntryBucket().get()).getDexEntriesWithContents();
        if (dexArchiveEntries.isEmpty()) {
            return;
        }
        Object object = ((Params)this.getParameters()).getUseForkJoinPool().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.useForkJoinPool.get()");
        ForkJoinPool forkJoinPool = (Boolean)object != false ? new ForkJoinPool() : (ForkJoinPool)null;
        try {
            object = ((Params)this.getParameters()).getSharedParams().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.sharedParams.get()");
            DexMergingTask.SharedParams sharedParams = (DexMergingTask.SharedParams)object;
            object = ((Directory)((Params)this.getParameters()).getOutputDirForBucket().get()).getAsFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"parameters.outputDirForBucket.get().asFile");
            Object object2 = object;
            object = (File)((Params)this.getParameters()).getMainDexListOutput().getAsFile().getOrNull();
            this.merge(sharedParams, forkJoinPool, dexArchiveEntries, (File)object2, object == null ? null : ((File)object).toPath());
        }
        finally {
            object = forkJoinPool;
            if (object != null) {
                ((ForkJoinPool)object).shutdown();
            }
            object = forkJoinPool;
            if (object != null) {
                ((ForkJoinPool)object).awaitTermination(100L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void merge(DexMergingTask.SharedParams sharedParams, ForkJoinPool forkJoinPool, List<DexArchiveEntry> dexArchiveEntries, File outputDir, Path mainDexListOutput) {
        LoggerWrapper loggerWrapper = LoggerWrapper.getLogger(DexMergingWorkAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)loggerWrapper, (String)"getLogger(DexMergingWorkAction::class.java)");
        LoggerWrapper logger = loggerWrapper;
        Object object = sharedParams.getErrorFormatMode().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sharedParams.errorFormatMode.get()");
        SyncOptions.ErrorFormatMode errorFormatMode = (SyncOptions.ErrorFormatMode)((Object)object);
        object = Logging.getLogger(DexMergingTask.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getLogger(DexMergingTask::class.java)");
        MessageReceiverImpl messageReceiver = new MessageReceiverImpl(errorFormatMode, (Logger)object);
        try {
            Collection<Path> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Path path;
            File it;
            boolean bl;
            boolean bl2;
            File file;
            Object object2 = sharedParams.getMinSdkVersion().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"sharedParams.minSdkVersion.get()");
            int d8MinSdkVersion = ((Number)object2).intValue();
            DexingType dexingType = (DexingType)sharedParams.getDexingType().get();
            if (d8MinSdkVersion < 21 && dexingType == DexingType.NATIVE_MULTIDEX) {
                d8MinSdkVersion = 21;
            }
            MessageReceiver messageReceiver2 = messageReceiver;
            Object object3 = sharedParams.getDebuggable().get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"sharedParams.debuggable.get()");
            DexArchiveMerger merger = DexArchiveMerger.createD8DexMerger((MessageReceiver)messageReceiver2, (int)d8MinSdkVersion, (boolean)((Boolean)object3), (ForkJoinPool)forkJoinPool);
            boolean bl3 = false;
            List proguardRules = new ArrayList();
            Object object4 = (File)sharedParams.getMainDexListConfig().getAaptGeneratedRules().getAsFile().getOrNull();
            if (object4 != null) {
                file = object4;
                bl2 = false;
                bl = false;
                it = file;
                boolean bl4 = false;
                path = it.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it.toPath()");
                proguardRules.add(path);
            }
            object4 = (File)sharedParams.getMainDexListConfig().getUserMultidexProguardRules().getAsFile().getOrNull();
            if (object4 != null) {
                file = object4;
                bl2 = false;
                bl = false;
                it = file;
                boolean bl5 = false;
                path = it.toPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it.toPath()");
                proguardRules.add(path);
            }
            object4 = (File)sharedParams.getMainDexListConfig().getUserMultidexKeepFile().getAsFile().getOrNull();
            Path path2 = object4 == null ? null : ((File)object4).toPath();
            object4 = (Iterable)sharedParams.getMainDexListConfig().getLibraryClasses();
            Path path3 = path2;
            List list = (List)sharedParams.getMainDexListConfig().getPlatformMultidexProguardRules().getOrNull();
            List list2 = proguardRules;
            Path path4 = outputDir.toPath();
            List<DexArchiveEntry> list3 = dexArchiveEntries;
            DexArchiveMerger dexArchiveMerger = merger;
            boolean $i$f$map = false;
            void var14_19 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                Path path5 = it2.toPath();
                collection.add(path5);
            }
            collection = (List)destination$iv$iv;
            dexArchiveMerger.mergeDexArchives(list3, path4, list2, list, path3, (Collection)collection, mainDexListOutput);
        }
        catch (Exception e) {
            PluginCrashReporter.maybeReportException(e);
            logger.error(null, Throwables.getStackTraceAsString((Throwable)e), new Object[0]);
            throw new TransformException((Throwable)e);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0016\u001a\u00020\u00172\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00182\b\u0010\b\u001a\u0004\u0018\u00010\u0018R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/DexMergingWorkAction$Params;", "Lcom/android/build/gradle/internal/profile/ProfileAwareWorkAction$Parameters;", "()V", "dexEntryBucket", "Lorg/gradle/api/provider/Property;", "Lcom/android/builder/dexing/DexEntryBucket;", "getDexEntryBucket", "()Lorg/gradle/api/provider/Property;", "mainDexListOutput", "Lorg/gradle/api/file/RegularFileProperty;", "getMainDexListOutput", "()Lorg/gradle/api/file/RegularFileProperty;", "outputDirForBucket", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDirForBucket", "()Lorg/gradle/api/file/DirectoryProperty;", "sharedParams", "Lcom/android/build/gradle/internal/tasks/DexMergingTask$SharedParams;", "getSharedParams", "useForkJoinPool", "", "getUseForkJoinPool", "initialize", "", "Ljava/io/File;", "gradle-core"})
    public static abstract class Params
    extends ProfileAwareWorkAction.Parameters {
        @NotNull
        public abstract Property<DexMergingTask.SharedParams> getSharedParams();

        @NotNull
        public abstract Property<Boolean> getUseForkJoinPool();

        @NotNull
        public abstract Property<DexEntryBucket> getDexEntryBucket();

        @NotNull
        public abstract DirectoryProperty getOutputDirForBucket();

        @NotNull
        public abstract RegularFileProperty getMainDexListOutput();

        public final void initialize(@NotNull Property<DexMergingTask.SharedParams> sharedParams, boolean useForkJoinPool, @NotNull DexEntryBucket dexEntryBucket, @NotNull File outputDirForBucket, @Nullable File mainDexListOutput) {
            Intrinsics.checkParameterIsNotNull(sharedParams, (String)"sharedParams");
            Intrinsics.checkParameterIsNotNull((Object)dexEntryBucket, (String)"dexEntryBucket");
            Intrinsics.checkParameterIsNotNull((Object)outputDirForBucket, (String)"outputDirForBucket");
            this.getSharedParams().set((Provider)sharedParams);
            this.getUseForkJoinPool().set((Object)useForkJoinPool);
            this.getDexEntryBucket().set((Object)dexEntryBucket);
            this.getOutputDirForBucket().set(outputDirForBucket);
            this.getMainDexListOutput().set(mainDexListOutput);
        }
    }
}

